/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.index.cluster;

import cern.colt.Arrays;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.index.cluster.ContiguousDocumentalStrategy;
import it.unimi.dsi.mg4j.index.cluster.DocumentalClusterIndexReader;
import it.unimi.dsi.mg4j.search.AbstractDocumentIterator;
import it.unimi.dsi.mg4j.search.DocumentIterator;
import it.unimi.dsi.mg4j.search.IntervalIterator;
import it.unimi.dsi.mg4j.search.IntervalIterators;
import it.unimi.dsi.mg4j.search.visitor.DocumentIteratorVisitor;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentalConcatenatedClusterDocumentIterator
extends AbstractDocumentIterator
implements DocumentIterator {
    private static final boolean DEBUG = false;
    private static final boolean ASSERTS = false;
    protected final DocumentIterator[] documentIterator;
    protected final int n;
    protected final int[] documentIteratorIndex;
    protected final ContiguousDocumentalStrategy strategy;
    protected int currentIterator;
    protected int lastIterator = -1;
    private final DocumentalClusterIndexReader indexReader;
    private final ReferenceArraySet<Index> indices = new ReferenceArraySet();

    public DocumentalConcatenatedClusterDocumentIterator(DocumentalClusterIndexReader indexReader, DocumentIterator[] documentIterator, int[] usedIndex) {
        this.documentIterator = documentIterator;
        this.n = documentIterator.length;
        this.indexReader = indexReader;
        this.documentIteratorIndex = usedIndex;
        this.strategy = (ContiguousDocumentalStrategy)indexReader.index.strategy;
        int i = this.n;
        while (i-- != 0) {
            if (!documentIterator[i].hasNext()) {
                throw new IllegalArgumentException("All component document iterators must be nonempty");
            }
            this.indices.addAll(documentIterator[i].indices());
        }
    }

    @Override
    public IntervalIterator intervalIterator() throws IOException {
        return this.documentIterator[this.lastIterator].intervalIterator();
    }

    @Override
    public IntervalIterator intervalIterator(Index index) throws IOException {
        if (!this.indices.contains((Object)index)) {
            return IntervalIterators.TRUE;
        }
        return this.documentIterator[this.lastIterator].intervalIterator(index);
    }

    @Override
    public Reference2ReferenceMap<Index, IntervalIterator> intervalIterators() throws IOException {
        return this.documentIterator[this.lastIterator].intervalIterators();
    }

    @Override
    public ReferenceSet<Index> indices() {
        return this.indices;
    }

    @Override
    public int skipTo(int p) throws IOException {
        if (this.last >= p) {
            return this.last;
        }
        if (this.currentIterator == this.n) {
            return Integer.MAX_VALUE;
        }
        this.next = -1;
        int k = this.strategy.localIndex(p);
        while (this.currentIterator < this.n && this.documentIteratorIndex[this.currentIterator] < k) {
            ++this.currentIterator;
        }
        int globalResult = Integer.MAX_VALUE;
        if (this.currentIterator < this.n && (globalResult = this.documentIterator[this.currentIterator].skipTo(this.strategy.localPointer(p))) == Integer.MAX_VALUE && ++this.currentIterator < this.n) {
            globalResult = this.documentIterator[this.currentIterator].nextDocument();
        }
        this.lastIterator = globalResult == Integer.MAX_VALUE ? -1 : this.currentIterator;
        this.last = globalResult == Integer.MAX_VALUE ? Integer.MAX_VALUE : this.strategy.globalPointer(this.documentIteratorIndex[this.currentIterator], globalResult);
        return this.last;
    }

    @Override
    public int nextDocument() throws IOException {
        if (this.next >= 0) {
            this.last = this.next;
            this.next = -1;
            return this.last;
        }
        if (this.currentIterator == this.n) {
            this.last = -1;
            return -1;
        }
        int result = this.documentIterator[this.currentIterator].nextDocument();
        if (result != -1) {
            this.lastIterator = this.currentIterator;
            this.last = this.strategy.globalPointer(this.documentIteratorIndex[this.lastIterator], result);
            return this.last;
        }
        ++this.currentIterator;
        if (this.currentIterator < this.n) {
            this.lastIterator = this.currentIterator;
            this.last = this.strategy.globalPointer(this.documentIteratorIndex[this.currentIterator], this.documentIterator[this.lastIterator].nextDocument());
            return this.last;
        }
        this.last = -1;
        return -1;
    }

    @Override
    public boolean accept(DocumentIteratorVisitor visitor) throws IOException {
        boolean result = true;
        for (DocumentIterator d : this.documentIterator) {
            if (!(result &= d.accept(visitor))) break;
        }
        return result;
    }

    @Override
    public boolean acceptOnTruePaths(DocumentIteratorVisitor visitor) throws IOException {
        return this.documentIterator[this.lastIterator].acceptOnTruePaths(visitor);
    }

    @Override
    public void dispose() throws IOException {
        this.indexReader.close();
    }

    public String toString() {
        return this.getClass().getSimpleName() + Arrays.toString((Object[])this.documentIterator);
    }
}

