/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.util;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Enumeration;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Fast {
    private static final boolean ASSERTS = false;
    public static final int FIXED_POINT_BITS = 31;
    public static final long FIXED_POINT_MULTIPLIER = 0x80000000L;
    private static final int[] GOLOMB_STEP = new int[]{820265763, 526396203, 388324070, 307788343, 254967594, 217639494, 189853975, 168364179, 151246997, 137290538, 125693039, 115902852, 107527942, 100282037, 93951212};
    private static final int GOLOMB_STEP_LENGTH = GOLOMB_STEP.length;
    private static final int GOLOMB_THRESHOLD = 88372385;
    private static final long GOLOMB_ADD = (long)(-(1.0 + Math.log(2.0)) / 2.0 * 2.147483648E9);
    private static final long GOLOMB_MULT = (int)(Math.log(2.0) * 2.147483648E9);
    private static final long GOLOMB_GAUSSIAN = (long)(2.0 * Math.sqrt(0.6366197723675814) * Math.log(2.0) * 2.147483648E9);
    private static final long[] SQRT_2_TO = new long[32];
    private static final NumberFormat FORMAT_DOUBLE;
    private static final NumberFormat FORMAT_LONG;
    public static final int[] BYTELSB;
    public static final int[] BYTEMSB;
    private static final Runtime RUNTIME;

    private Fast() {
    }

    public static int mostSignificantBit(int x) {
        return x < 32768 ? (x < 128 ? (x < 8 ? (x < 2 ? (x < 1 ? (x < 0 ? 31 : -1) : 0) : (x < 4 ? 1 : 2)) : (x < 32 ? (x < 16 ? 3 : 4) : (x < 64 ? 5 : 6))) : (x < 2048 ? (x < 512 ? (x < 256 ? 7 : 8) : (x < 1024 ? 9 : 10)) : (x < 8192 ? (x < 4096 ? 11 : 12) : (x < 16384 ? 13 : 14)))) : (x < 0x800000 ? (x < 524288 ? (x < 131072 ? (x < 65536 ? 15 : 16) : (x < 262144 ? 17 : 18)) : (x < 0x200000 ? (x < 0x100000 ? 19 : 20) : (x < 0x400000 ? 21 : 22))) : (x < 0x8000000 ? (x < 0x2000000 ? (x < 0x1000000 ? 23 : 24) : (x < 0x4000000 ? 25 : 26)) : (x < 0x20000000 ? (x < 0x10000000 ? 27 : 28) : (x < 0x40000000 ? 29 : 30))));
    }

    public static int mostSignificantBit(long x) {
        return x < 0x80000000L ? (x < 32768L ? (x < 128L ? (x < 8L ? (x < 2L ? (x < 1L ? (x < 0L ? 63 : -1) : 0) : (x < 4L ? 1 : 2)) : (x < 32L ? (x < 16L ? 3 : 4) : (x < 64L ? 5 : 6))) : (x < 2048L ? (x < 512L ? (x < 256L ? 7 : 8) : (x < 1024L ? 9 : 10)) : (x < 8192L ? (x < 4096L ? 11 : 12) : (x < 16384L ? 13 : 14)))) : (x < 0x800000L ? (x < 524288L ? (x < 131072L ? (x < 65536L ? 15 : 16) : (x < 262144L ? 17 : 18)) : (x < 0x200000L ? (x < 0x100000L ? 19 : 20) : (x < 0x400000L ? 21 : 22))) : (x < 0x8000000L ? (x < 0x2000000L ? (x < 0x1000000L ? 23 : 24) : (x < 0x4000000L ? 25 : 26)) : (x < 0x20000000L ? (x < 0x10000000L ? 27 : 28) : (x < 0x40000000L ? 29 : 30))))) : (x < 0x800000000000L ? (x < 0x8000000000L ? (x < 0x800000000L ? (x < 0x200000000L ? (x < 0x100000000L ? 31 : 32) : (x < 0x400000000L ? 33 : 34)) : (x < 0x2000000000L ? (x < 0x1000000000L ? 35 : 36) : (x < 0x4000000000L ? 37 : 38))) : (x < 0x80000000000L ? (x < 0x20000000000L ? (x < 0x10000000000L ? 39 : 40) : (x < 0x40000000000L ? 41 : 42)) : (x < 0x200000000000L ? (x < 0x100000000000L ? 43 : 44) : (x < 0x400000000000L ? 45 : 46)))) : (x < 0x80000000000000L ? (x < 0x8000000000000L ? (x < 0x2000000000000L ? (x < 0x1000000000000L ? 47 : 48) : (x < 0x4000000000000L ? 49 : 50)) : (x < 0x20000000000000L ? (x < 0x10000000000000L ? 51 : 52) : (x < 0x40000000000000L ? 53 : 54))) : (x < 0x800000000000000L ? (x < 0x200000000000000L ? (x < 0x100000000000000L ? 55 : 56) : (x < 0x400000000000000L ? 57 : 58)) : (x < 0x2000000000000000L ? (x < 0x1000000000000000L ? 59 : 60) : (x < 0x4000000000000000L ? 61 : 62)))));
    }

    public static int leastSignificantBit(int x) {
        if (x == 0) {
            return -1;
        }
        if ((x & 0xFF) != 0) {
            return BYTELSB[x & 0xFF];
        }
        if ((x & 0xFFFF) != 0) {
            return BYTELSB[x >>> 8 & 0xFF] + 8;
        }
        if ((x & 0xFFFFFF) != 0) {
            return BYTELSB[x >>> 16 & 0xFF] + 16;
        }
        return BYTELSB[x >>> 24 & 0xFF] + 24;
    }

    public static int leastSignificantBit(long x) {
        if (x == 0L) {
            return -1;
        }
        if ((x & 0xFFL) != 0L) {
            return BYTELSB[(int)(x & 0xFFL)];
        }
        if ((x & 0xFFFFL) != 0L) {
            return BYTELSB[(int)(x >>> 8 & 0xFFL)] + 8;
        }
        if ((x & 0xFFFFFFL) != 0L) {
            return BYTELSB[(int)(x >>> 16 & 0xFFL)] + 16;
        }
        if ((x & 0xFFFFFFFFL) != 0L) {
            return BYTELSB[(int)(x >>> 24 & 0xFFL)] + 24;
        }
        if ((x & 0xFFFFFFFFFFL) != 0L) {
            return BYTELSB[(int)(x >>> 32 & 0xFFL)] + 32;
        }
        if ((x & 0xFFFFFFFFFFFFL) != 0L) {
            return BYTELSB[(int)(x >>> 40 & 0xFFL)] + 40;
        }
        if ((x & 0xFFFFFFFFFFFFFFL) != 0L) {
            return BYTELSB[(int)(x >>> 48 & 0xFFL)] + 48;
        }
        return BYTELSB[(int)(x >>> 56 & 0xFFL)] + 56;
    }

    public static int golombModulus(int p, int q) {
        int f = (int)((long)p * 0x80000000L / (long)q);
        if (f < 88372385) {
            return (int)(GOLOMB_ADD + GOLOMB_MULT * (long)q / (long)p + 0x80000000L - 1L >> 31);
        }
        int i = GOLOMB_STEP_LENGTH;
        while (i-- != 0) {
            if (f >= GOLOMB_STEP[i]) continue;
            return i + 2;
        }
        return 1;
    }

    public static int gaussianGolombModulus(long quantumSigma, int shift) {
        return (int)(((GOLOMB_GAUSSIAN >> 15) * (quantumSigma >> 16) >> 15) * (SQRT_2_TO[shift] >> 16) + 0x80000000L - 1L >> 31);
    }

    public static long quantumSigma(int frequency, int numberOfDocuments, int quantum) {
        return (long)(Math.sqrt((double)quantum * (1.0 - (double)frequency / (double)numberOfDocuments)) * (double)numberOfDocuments / (double)frequency * 2.147483648E9);
    }

    public static int int2nat(int x) {
        return x >= 0 ? x << 1 : -((x << 1) + 1);
    }

    public static int nat2int(int x) {
        return x % 2 == 0 ? x >> 1 : -(x >> 1) - 1;
    }

    public static long int2nat(long x) {
        return x >= 0L ? x << 1 : -((x << 1) + 1L);
    }

    public static long nat2int(long x) {
        return x % 2L == 0L ? x >> 1 : -(x >> 1) - 1L;
    }

    public static String format(double d) {
        StringBuffer s = new StringBuffer();
        return FORMAT_DOUBLE.format(d, s, new FieldPosition(0)).toString();
    }

    public static String format(long l) {
        StringBuffer s = new StringBuffer();
        return FORMAT_LONG.format(l, s, new FieldPosition(0)).toString();
    }

    public static String formatSize(long l) {
        if (l >= 1000000000000L) {
            return Fast.format((double)l / 1.0E12) + "T";
        }
        if (l >= 1000000000L) {
            return Fast.format((double)l / 1.0E9) + "G";
        }
        if (l >= 1000000L) {
            return Fast.format((double)l / 1000000.0) + "M";
        }
        if (l >= 1000L) {
            return Fast.format((double)l / 1000.0) + "K";
        }
        return Long.toString(l);
    }

    public static String formatBinarySize(long l) {
        if ((l & -l) != l) {
            throw new IllegalArgumentException("Not a power of 2: " + l);
        }
        if (l >= 0x10000000000L) {
            return Fast.format(l >> 40) + "Ti";
        }
        if (l >= 0x40000000L) {
            return Fast.format(l >> 30) + "Gi";
        }
        if (l >= 0x100000L) {
            return Fast.format(l >> 20) + "Mi";
        }
        if (l >= 1024L) {
            return Fast.format(l >> 10) + "Ki";
        }
        return Long.toString(l);
    }

    public static boolean log4JIsConfigured() {
        if (Logger.getRootLogger().getAllAppenders().hasMoreElements()) {
            return true;
        }
        Enumeration loggers = LogManager.getCurrentLoggers();
        while (loggers.hasMoreElements()) {
            Logger logger = (Logger)loggers.nextElement();
            if (!logger.getAllAppenders().hasMoreElements()) continue;
            return true;
        }
        return false;
    }

    public static void ensureLog4JIsConfigured() {
        Fast.ensureLog4JIsConfigured(Level.INFO);
    }

    public static void ensureLog4JIsConfigured(Level level) {
        if (!Fast.log4JIsConfigured()) {
            System.err.println("WARNING: MG4J is autoconfiguring Log4J. You should configure Log4J properly instead.");
            BasicConfigurator.configure();
            LogManager.getRootLogger().setLevel(level);
        }
    }

    public static Logger getLogger(Class<?> klass) {
        Logger logger = Logger.getLogger(klass);
        Fast.ensureLog4JIsConfigured();
        return logger;
    }

    public static boolean memoryIsLow() {
        return Fast.availableMemory() * 100L < RUNTIME.totalMemory() * 5L;
    }

    public static long availableMemory() {
        return RUNTIME.freeMemory() + (RUNTIME.maxMemory() - RUNTIME.totalMemory());
    }

    public static int percAvailableMemory() {
        return (int)(Fast.availableMemory() * 100L / Runtime.getRuntime().maxMemory());
    }

    public static void compactMemory() {
        try {
            byte[][] unused = new byte[128][];
            int i = unused.length;
            while (i-- != 0) {
                unused[i] = new byte[2000000000];
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
    }

    static {
        int i = SQRT_2_TO.length;
        while (i-- != 0) {
            Fast.SQRT_2_TO[i] = (long)(Math.sqrt((double)(1L << i) / 2.0) * 2.147483648E9);
        }
        FORMAT_DOUBLE = new DecimalFormat("#,##0.00");
        FORMAT_LONG = new DecimalFormat("#,###");
        BYTELSB = new int[]{-1, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 7, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0};
        BYTEMSB = new int[]{-1, 0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
        RUNTIME = Runtime.getRuntime();
    }
}

