/*
 * Decompiled with CFR 0.152.
 */
package test.it.unimi.dsi.mg4j.search;

import it.unimi.dsi.fastutil.ints.AbstractIntIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import it.unimi.dsi.fastutil.objects.ReferenceSets;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.index.IndexIterator;
import it.unimi.dsi.mg4j.index.IndexReader;
import it.unimi.dsi.mg4j.index.NullTermProcessor;
import it.unimi.dsi.mg4j.index.TooManyTermsException;
import it.unimi.dsi.mg4j.search.DocumentIterator;
import it.unimi.dsi.mg4j.search.Interval;
import it.unimi.dsi.mg4j.search.IntervalIterator;
import it.unimi.dsi.mg4j.search.IntervalIterators;
import it.unimi.dsi.mg4j.search.Intervals;
import it.unimi.dsi.mg4j.search.visitor.DocumentIteratorVisitor;
import it.unimi.dsi.mg4j.util.MutableString;
import java.io.IOException;
import java.util.Arrays;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntArrayDocumentIterator
extends AbstractIntIterator
implements DocumentIterator {
    private static final Index index = new TestIndex();
    private final int[] document;
    private final int[][][] interval;
    private int curr = -1;
    private IntervalIterator currentIterator;

    public IntArrayDocumentIterator(int[] document, int[][][] interval) {
        int i;
        this.document = document;
        this.interval = interval;
        if (document.length != interval.length) {
            throw new IllegalArgumentException();
        }
        for (i = 0; i < document.length - 1; ++i) {
            if (document[i] < document[i + 1]) continue;
            throw new IllegalArgumentException("Document array is not increasing");
        }
        for (i = 0; i < document.length; ++i) {
            for (int j = 0; j < interval[i].length; ++j) {
                if (interval[i][j].length == 0 && interval[i].length != 1) {
                    throw new IllegalArgumentException("Empty interval in a non-singleton antichain");
                }
                if (j <= 0 || interval[i][j][0] > interval[i][j - 1][0] && interval[i][j][interval[i][j].length - 1] > interval[i][j - 1][interval[i][j - 1].length - 1]) continue;
                throw new IllegalArgumentException("Not an antichain: " + Arrays.toString(interval[i][j - 1]) + " vs. " + Arrays.toString(interval[i][j]));
            }
        }
    }

    public boolean hasNext() {
        return this.curr < this.document.length - 1;
    }

    @Override
    public int nextInt() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.curr;
        this.currentIterator = null;
        return this.document[this.curr];
    }

    @Override
    public int nextDocument() {
        if (!this.hasNext()) {
            return -1;
        }
        return this.nextInt();
    }

    @Override
    public int skipTo(int n) {
        if (this.curr != -1 && this.document[this.curr] >= n) {
            return this.document[this.curr];
        }
        while (this.hasNext()) {
            int result = this.nextInt();
            if (result < n) continue;
            return result;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean accept(DocumentIteratorVisitor visitor) {
        if (!visitor.visitPre(this)) {
            return false;
        }
        return visitor.visitPost(this);
    }

    @Override
    public boolean acceptOnTruePaths(DocumentIteratorVisitor visitor) {
        if (!visitor.visitPre(this)) {
            return false;
        }
        return visitor.visitPost(this);
    }

    @Override
    public void dispose() {
    }

    @Override
    public int document() {
        if (this.curr == -1) {
            throw new IllegalStateException();
        }
        return this.document[this.curr];
    }

    @Override
    public ReferenceSet<Index> indices() {
        return ReferenceSets.singleton((Object)index);
    }

    @Override
    public IntervalIterator intervalIterator() {
        if (this.curr == -1) {
            throw new IllegalStateException();
        }
        if (this.currentIterator != null) {
            return this.currentIterator;
        }
        if (this.interval[this.curr].length == 0) {
            return IntervalIterators.FALSE;
        }
        if (this.interval[this.curr].length == 1 && this.interval[this.curr][0].length == 0) {
            return IntervalIterators.TRUE;
        }
        this.currentIterator = new ArrayIntervalIterator(this.interval[this.curr]);
        return this.currentIterator;
    }

    @Override
    public IntervalIterator intervalIterator(Index index) {
        return this.intervalIterator();
    }

    @Override
    public Reference2ReferenceMap<Index, IntervalIterator> intervalIterators() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IntervalIterator iterator() {
        return this.intervalIterator();
    }

    public void reset() {
        this.curr = -1;
    }

    public String toString() {
        MutableString result = new MutableString();
        result.append('[');
        for (int i = 0; i < this.document.length; ++i) {
            if (i != 0) {
                result.append(", ");
            }
            result.append('<').append(this.document[i]).append(':').append(new ArrayIntervalIterator(this.interval[i])).append('>');
        }
        return result.append(']').toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ArrayIntervalIterator
    extends AbstractObjectIterator<Interval>
    implements IntervalIterator {
        private int curr = -1;
        private final int[][] interval;

        private static String toString(int[] interval) {
            if (interval.length == 0) {
                return Intervals.EMPTY_INTERVAL.toString();
            }
            if (interval.length == 1) {
                return Interval.valueOf(interval[0]).toString();
            }
            return Interval.valueOf(interval[0], interval[1]).toString();
        }

        public ArrayIntervalIterator(int[][] interval) {
            this.interval = interval;
        }

        @Override
        public int extent() {
            return 1;
        }

        @Override
        public void reset() {
            this.curr = -1;
        }

        @Override
        public boolean hasNext() {
            return this.curr < this.interval.length - 1;
        }

        @Override
        public Interval next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.curr;
            return this.interval[this.curr].length == 1 ? Interval.valueOf(this.interval[this.curr][0]) : Interval.valueOf(this.interval[this.curr][0], this.interval[this.curr][1]);
        }

        @Override
        public Interval nextInterval() {
            if (!this.hasNext()) {
                return null;
            }
            return this.next();
        }

        public String toString() {
            MutableString result = new MutableString();
            result.append('{');
            boolean first = true;
            for (int[] i : this.interval) {
                if (!first) {
                    result.append(',');
                }
                first = false;
                result.append(ArrayIntervalIterator.toString(i));
            }
            return result.append('}').toString();
        }
    }

    private static class TestIndex
    extends Index {
        private static final long serialVersionUID = 1L;

        public TestIndex() {
            super(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, null, true, true, NullTermProcessor.getInstance(), "text", null, null);
        }

        public IndexIterator documents(CharSequence prefix, int limit) throws IOException, TooManyTermsException {
            throw new UnsupportedOperationException();
        }

        public IndexReader getReader() throws IOException {
            throw new UnsupportedOperationException();
        }

        public IndexReader getReader(int bufferSize) throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

