/*
 * Decompiled with CFR 0.152.
 */
package test.it.unimi.dsi.mg4j.util;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.mg4j.io.InputBitStream;
import it.unimi.dsi.mg4j.io.OutputBitStream;
import it.unimi.dsi.mg4j.util.SemiExternalGammaList;
import java.io.IOException;
import junit.framework.TestCase;

public class SemiExternalGammaListTest
extends TestCase {
    private static InputBitStream buildInputStream(LongList longs) throws IOException {
        byte[] array = new byte[longs.size() * 4];
        OutputBitStream streamer = new OutputBitStream(array);
        for (int i = 0; i < longs.size(); ++i) {
            streamer.writeLongGamma(longs.getLong(i));
        }
        int size = (int)(streamer.writtenBits() / 8L) + (streamer.writtenBits() % 8L == 0L ? 0 : 1);
        byte[] smaller = new byte[size];
        System.arraycopy(array, 0, smaller, 0, size);
        return new InputBitStream(smaller);
    }

    public void testSemiExternalGammaListGammaCoding() throws IOException {
        int i;
        long[] longs = new long[]{10L, 300L, 450L, 650L, 1000L, 1290L, 1699L};
        LongArrayList listLongs = new LongArrayList(longs);
        SemiExternalGammaList list = new SemiExternalGammaList(SemiExternalGammaListTest.buildInputStream((LongList)listLongs), 1, listLongs.size());
        for (i = 0; i < longs.length; ++i) {
            SemiExternalGammaListTest.assertEquals((String)("test failed for index: " + i), (long)longs[i], (long)list.getLong(i));
        }
        list = new SemiExternalGammaList(SemiExternalGammaListTest.buildInputStream((LongList)listLongs), 2, listLongs.size());
        for (i = 0; i < longs.length; ++i) {
            SemiExternalGammaListTest.assertEquals((String)("test failed for index: " + i), (long)longs[i], (long)list.getLong(i));
        }
        list = new SemiExternalGammaList(SemiExternalGammaListTest.buildInputStream((LongList)listLongs), 4, listLongs.size());
        for (i = 0; i < longs.length; ++i) {
            SemiExternalGammaListTest.assertEquals((String)("test failed for index: " + i), (long)longs[i], (long)list.getLong(i));
        }
        list = new SemiExternalGammaList(SemiExternalGammaListTest.buildInputStream((LongList)listLongs), 7, listLongs.size());
        for (i = 0; i < longs.length; ++i) {
            SemiExternalGammaListTest.assertEquals((String)("test failed for index: " + i), (long)longs[i], (long)list.getLong(i));
        }
        list = new SemiExternalGammaList(SemiExternalGammaListTest.buildInputStream((LongList)listLongs), 8, listLongs.size());
        for (i = 0; i < longs.length; ++i) {
            SemiExternalGammaListTest.assertEquals((String)("test failed for index: " + i), (long)longs[i], (long)list.getLong(i));
        }
    }

    public void testEmptySemiExternalGammaListGammaCoding() throws IOException {
        long[] longs = new long[]{};
        LongArrayList listOffsets = new LongArrayList(longs);
        new SemiExternalGammaList(SemiExternalGammaListTest.buildInputStream((LongList)listOffsets), 1, listOffsets.size());
        SemiExternalGammaListTest.assertTrue((boolean)true);
    }
}

