/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics;

import edu.unc.genomics.Interval;
import java.util.List;
import net.sf.samtools.AlignmentBlock;
import net.sf.samtools.Cigar;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileSource;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMValidationError;

public class SAMEntry
extends Interval {
    private static final long serialVersionUID = -439658908814430105L;
    private SAMRecord r;

    public SAMEntry(SAMRecord r) {
        super(r.getReferenceName(), r.getAlignmentStart(), r.getAlignmentEnd());
        int extend;
        this.r = r;
        int n = extend = r.getInferredInsertSize() == 0 ? r.getReadLength() : Math.abs(r.getInferredInsertSize());
        if (r.getReadNegativeStrandFlag()) {
            this.start = r.getAlignmentStart() + r.getReadLength() - 1;
            this.stop = this.start - extend + 1;
        } else {
            this.stop = this.start + extend - 1;
        }
    }

    public String getReadName() {
        return this.r.getReadName();
    }

    public int getReadNameLength() {
        return this.r.getReadNameLength();
    }

    public void setReadName(String value) {
        this.r.setReadName(value);
    }

    public String getReadString() {
        return this.r.getReadString();
    }

    public void setReadString(String value) {
        this.r.setReadString(value);
    }

    public byte[] getReadBases() {
        return this.r.getReadBases();
    }

    public void setReadBases(byte[] value) {
        this.r.setReadBases(value);
    }

    public int getReadLength() {
        return this.r.getReadLength();
    }

    public String getBaseQualityString() {
        return this.r.getBaseQualityString();
    }

    public void setBaseQualityString(String value) {
        this.r.setBaseQualityString(value);
    }

    public byte[] getBaseQualities() {
        return this.r.getBaseQualities();
    }

    public void setBaseQualities(byte[] value) {
        this.r.setBaseQualities(value);
    }

    public byte[] getOriginalBaseQualities() {
        return this.r.getOriginalBaseQualities();
    }

    public void setOriginalBaseQualities(byte[] oq) {
        this.r.setOriginalBaseQualities(oq);
    }

    public String getReferenceName() {
        return this.r.getReferenceName();
    }

    public void setReferenceName(String value) {
        this.r.setReferenceName(value);
    }

    public Integer getReferenceIndex() {
        return this.r.getReferenceIndex();
    }

    public void setReferenceIndex(int referenceIndex) {
        this.r.setReferenceIndex(referenceIndex);
    }

    public String getMateReferenceName() {
        return this.r.getMateReferenceName();
    }

    public void setMateReferenceName(String mateReferenceName) {
        this.r.setMateReferenceName(mateReferenceName);
    }

    public Integer getMateReferenceIndex() {
        return this.r.getMateReferenceIndex();
    }

    public void setMateReferenceIndex(int referenceIndex) {
        this.r.setMateReferenceIndex(referenceIndex);
    }

    public int getAlignmentStart() {
        return this.r.getAlignmentStart();
    }

    public void setAlignmentStart(int value) {
        this.r.setAlignmentStart(value);
    }

    public int getAlignmentEnd() {
        return this.r.getAlignmentEnd();
    }

    public int getUnclippedStart() {
        return this.r.getUnclippedStart();
    }

    public int getUnclippedEnd() {
        return this.r.getUnclippedEnd();
    }

    public int getReferencePositionAtReadPosition(int offset) {
        return this.r.getReferencePositionAtReadPosition(offset);
    }

    public void setAlignmentEnd(int value) {
        this.r.setAlignmentEnd(value);
    }

    public int getMateAlignmentStart() {
        return this.r.getMateAlignmentStart();
    }

    public void setMateAlignmentStart(int mateAlignmentStart) {
        this.r.setMateAlignmentStart(mateAlignmentStart);
    }

    public int getInferredInsertSize() {
        return this.r.getInferredInsertSize();
    }

    public void setInferredInsertSize(int inferredInsertSize) {
        this.r.setInferredInsertSize(inferredInsertSize);
    }

    public int getMappingQuality() {
        return this.r.getMappingQuality();
    }

    public void setMappingQuality(int value) {
        this.r.setMappingQuality(value);
    }

    public String getCigarString() {
        return this.r.getCigarString();
    }

    public void setCigarString(String value) {
        this.r.setCigarString(value);
    }

    public Cigar getCigar() {
        return this.r.getCigar();
    }

    public int getCigarLength() {
        return this.r.getCigarLength();
    }

    public void setCigar(Cigar cigar) {
        this.r.setCigar(cigar);
    }

    public SAMReadGroupRecord getReadGroup() {
        return this.r.getReadGroup();
    }

    public int getFlags() {
        return this.r.getFlags();
    }

    public void setFlags(int value) {
        this.r.setFlags(value);
    }

    public boolean getReadPairedFlag() {
        return this.r.getReadPairedFlag();
    }

    public boolean getProperPairFlag() {
        return this.r.getProperPairFlag();
    }

    public boolean getReadUnmappedFlag() {
        return this.r.getReadUnmappedFlag();
    }

    public boolean getMateUnmappedFlag() {
        return this.r.getMateUnmappedFlag();
    }

    public boolean getReadNegativeStrandFlag() {
        return this.r.getReadNegativeStrandFlag();
    }

    public boolean getMateNegativeStrandFlag() {
        return this.r.getMateNegativeStrandFlag();
    }

    public boolean getFirstOfPairFlag() {
        return this.r.getFirstOfPairFlag();
    }

    public boolean getSecondOfPairFlag() {
        return this.r.getSecondOfPairFlag();
    }

    public boolean getNotPrimaryAlignmentFlag() {
        return this.r.getNotPrimaryAlignmentFlag();
    }

    public boolean getReadFailsVendorQualityCheckFlag() {
        return this.r.getReadFailsVendorQualityCheckFlag();
    }

    public boolean getDuplicateReadFlag() {
        return this.r.getDuplicateReadFlag();
    }

    public void setReadPairedFlag(boolean flag) {
        this.r.setReadPairedFlag(flag);
    }

    public void setProperPairFlag(boolean flag) {
        this.r.setProperPairFlag(flag);
    }

    public void setReadUnmappedFlag(boolean flag) {
        this.r.setReadUnmappedFlag(flag);
    }

    public void setMateUnmappedFlag(boolean flag) {
        this.r.setMateUnmappedFlag(flag);
    }

    public void setReadNegativeStrandFlag(boolean flag) {
        this.r.setReadNegativeStrandFlag(flag);
    }

    public void setMateNegativeStrandFlag(boolean flag) {
        this.r.setMateNegativeStrandFlag(flag);
    }

    public void setFirstOfPairFlag(boolean flag) {
        this.r.setFirstOfPairFlag(flag);
    }

    public void setSecondOfPairFlag(boolean flag) {
        this.r.setSecondOfPairFlag(flag);
    }

    public void setNotPrimaryAlignmentFlag(boolean flag) {
        this.r.setNotPrimaryAlignmentFlag(flag);
    }

    public void setReadFailsVendorQualityCheckFlag(boolean flag) {
        this.r.setReadFailsVendorQualityCheckFlag(flag);
    }

    public void setDuplicateReadFlag(boolean flag) {
        this.r.setDuplicateReadFlag(flag);
    }

    public SAMFileReader.ValidationStringency getValidationStringency() {
        return this.r.getValidationStringency();
    }

    public void setValidationStringency(SAMFileReader.ValidationStringency validationStringency) {
        this.r.setValidationStringency(validationStringency);
    }

    public Object getAttribute(String tag) {
        return this.r.getAttribute(tag);
    }

    public Integer getIntegerAttribute(String tag) {
        return this.r.getIntegerAttribute(tag);
    }

    public Short getShortAttribute(String tag) {
        return this.r.getShortAttribute(tag);
    }

    public Byte getByteAttribute(String tag) {
        return this.r.getByteAttribute(tag);
    }

    public String getStringAttribute(String tag) {
        return this.r.getStringAttribute(tag);
    }

    public Character getCharacterAttribute(String tag) {
        return this.r.getCharacterAttribute(tag);
    }

    public Float getFloatAttribute(String tag) {
        return this.r.getFloatAttribute(tag);
    }

    public byte[] getByteArrayAttribute(String tag) {
        return this.r.getByteArrayAttribute(tag);
    }

    public byte[] getUnsignedByteArrayAttribute(String tag) {
        return this.r.getUnsignedByteArrayAttribute(tag);
    }

    public byte[] getSignedByteArrayAttribute(String tag) {
        return this.r.getSignedByteArrayAttribute(tag);
    }

    public short[] getUnsignedShortArrayAttribute(String tag) {
        return this.r.getUnsignedShortArrayAttribute(tag);
    }

    public short[] getSignedShortArrayAttribute(String tag) {
        return this.r.getSignedShortArrayAttribute(tag);
    }

    public int[] getUnsignedIntArrayAttribute(String tag) {
        return this.r.getUnsignedIntArrayAttribute(tag);
    }

    public int[] getSignedIntArrayAttribute(String tag) {
        return this.r.getSignedIntArrayAttribute(tag);
    }

    public float[] getFloatArrayAttribute(String tag) {
        return this.r.getFloatArrayAttribute(tag);
    }

    public boolean isUnsignedArrayAttribute(String tag) {
        return this.r.isUnsignedArrayAttribute(tag);
    }

    public void setAttribute(String tag, Object value) {
        this.r.setAttribute(tag, value);
    }

    public void setUnsignedArrayAttribute(String tag, Object value) {
        this.r.setUnsignedArrayAttribute(tag, value);
    }

    public List<SAMRecord.SAMTagAndValue> getAttributes() {
        return this.r.getAttributes();
    }

    public SAMFileHeader getHeader() {
        return this.r.getHeader();
    }

    public void setHeader(SAMFileHeader header) {
        this.r.setHeader(header);
    }

    public byte[] getVariableBinaryRepresentation() {
        return this.r.getVariableBinaryRepresentation();
    }

    public int getAttributesBinarySize() {
        return this.r.getAttributesBinarySize();
    }

    public List<AlignmentBlock> getAlignmentBlocks() {
        return this.r.getAlignmentBlocks();
    }

    public List<SAMValidationError> validateCigar(long recordNumber) {
        return this.r.validateCigar(recordNumber);
    }

    @Override
    public int hashCode() {
        return this.r.hashCode();
    }

    public boolean isValid() {
        return this.r.isValid().size() == 0;
    }

    public SAMFileSource getFileSource() {
        return this.r.getFileSource();
    }

    @Override
    public String toString() {
        return this.r.toString();
    }

    public String getSAMString() {
        return this.r.getSAMString();
    }
}

