/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.io;

import edu.unc.genomics.SAMEntry;
import edu.unc.genomics.io.IntervalFile;
import edu.unc.genomics.io.IntervalFileFormatException;
import edu.unc.genomics.io.SAMEntryIterator;
import edu.unc.genomics.util.Samtools;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.sf.samtools.BAMIndex;
import net.sf.samtools.BAMIndexMetaData;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecordIterator;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.SAMSequenceRecord;
import org.apache.log4j.Logger;

public class SAMFile
extends IntervalFile<SAMEntry> {
    private static final Logger log = Logger.getLogger(SAMFile.class);
    private SAMFileReader reader;
    private SAMRecordIterator it;
    private int count = 0;
    private Path bam;
    private Path index;
    private boolean allowUnmappedReads = false;

    public SAMFile(Path p) {
        super(p);
        this.reader = new SAMFileReader(p.toFile());
    }

    public SAMFile(Path p, boolean allowUnmappedReads) {
        this(p);
        this.allowUnmappedReads = allowUnmappedReads;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
        if (this.bam != null) {
            Files.deleteIfExists(this.bam);
        }
        if (this.index != null) {
            Files.deleteIfExists(this.index);
        }
    }

    @Override
    public int count() {
        if (this.count == 0) {
            if (this.bam == null) {
                this.convertToBAM();
            }
            BAMIndex index = this.reader.getIndex();
            int nRefs = this.reader.getFileHeader().getSequenceDictionary().size();
            for (int i = 0; i < nRefs; ++i) {
                BAMIndexMetaData data = index.getMetaData(i);
                this.count += data.getAlignedRecordCount();
                this.count += data.getUnalignedRecordCount();
            }
        }
        return this.count;
    }

    @Override
    public Set<String> chromosomes() {
        HashSet<String> chromosomes = new HashSet<String>();
        SAMSequenceDictionary dict = this.reader.getFileHeader().getSequenceDictionary();
        for (SAMSequenceRecord seqRec : dict.getSequences()) {
            chromosomes.add(seqRec.getSequenceName());
        }
        return chromosomes;
    }

    @Override
    public Iterator<SAMEntry> iterator() {
        if (this.it != null) {
            this.it.close();
        }
        this.it = this.reader.iterator();
        return new SAMEntryIterator(this.it, this.allowUnmappedReads);
    }

    @Override
    public Iterator<SAMEntry> query(String chr, int start, int stop) {
        if (this.bam == null) {
            this.convertToBAM();
        }
        if (this.it != null) {
            this.it.close();
        }
        this.it = this.reader.query(chr, start, stop, false);
        return new SAMEntryIterator(this.it, this.allowUnmappedReads);
    }

    private void convertToBAM() {
        this.bam = this.p.resolveSibling(this.p.getFileName() + ".bam");
        Samtools.samToBam(this.p, this.bam);
        this.index = this.p.resolveSibling(this.bam.getFileName() + ".bai");
        Samtools.indexBAMFile(this.bam, this.index);
        this.reader = new SAMFileReader(this.bam.toFile());
        if (!this.reader.hasIndex()) {
            throw new IntervalFileFormatException("Error indexing BAM file: " + this.bam);
        }
        this.reader.enableIndexMemoryMapping(false);
        this.reader.enableIndexCaching(true);
    }

    public boolean doesAllowUnmappedReads() {
        return this.allowUnmappedReads;
    }

    public void setAllowUnmappedReads(boolean allowUnmappedReads) {
        this.allowUnmappedReads = allowUnmappedReads;
    }
}

