/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.index;

import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.mg4j.index.BitStreamHPIndex;
import it.unimi.dsi.mg4j.index.CompressionFlags;
import it.unimi.dsi.mg4j.index.PrefixMap;
import it.unimi.dsi.mg4j.index.TermMap;
import it.unimi.dsi.mg4j.index.TermProcessor;
import it.unimi.dsi.mg4j.index.payload.Payload;
import it.unimi.dsi.mg4j.io.InputBitStream;
import it.unimi.dsi.mg4j.util.Properties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class FileHPIndex
extends BitStreamHPIndex {
    private static final long serialVersionUID = 0L;
    public final String basename;
    public final File indexFile;
    public final File positionsFile;

    public FileHPIndex(String basename, int numberOfDocuments, int numberOfTerms, long numberOfPostings, long numberOfOccurrences, int maxCount, Payload payload, CompressionFlags.Coding frequencyCoding, CompressionFlags.Coding pointerCoding, CompressionFlags.Coding countCoding, CompressionFlags.Coding positionCoding, int quantum, int height, int bufferSize, TermProcessor termProcessor, String field, Properties properties, TermMap termMap, PrefixMap prefixMap, IntList sizes, LongList offsets) {
        super(numberOfDocuments, numberOfTerms, numberOfPostings, numberOfOccurrences, maxCount, payload, frequencyCoding, pointerCoding, countCoding, positionCoding, quantum, height, bufferSize, termProcessor, field, properties, termMap, prefixMap, sizes, offsets);
        this.basename = basename;
        this.indexFile = new File(basename + ".index");
        this.positionsFile = new File(basename + ".positions");
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.basename + ")";
    }

    public FileInputStream getInputStream() throws FileNotFoundException {
        return new FileInputStream(this.indexFile);
    }

    public InputBitStream getInputBitStream(int bufferSize) throws FileNotFoundException {
        return new InputBitStream(this.indexFile, bufferSize);
    }

    public InputStream getPositionsInputStream() throws IOException {
        return new FileInputStream(this.positionsFile);
    }

    public InputBitStream getPositionsInputBitStream(int bufferSize) throws IOException {
        return new InputBitStream(this.positionsFile, bufferSize);
    }
}

