/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.dst;

import edu.emory.mathcs.jtransforms.dct.DoubleDCT_1D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class DoubleDST_1D {
    private int n;
    private DoubleDCT_1D dct;

    public DoubleDST_1D(int n) {
        this.n = n;
        this.dct = new DoubleDCT_1D(n);
    }

    public void forward(double[] dArray, boolean bl) {
        this.forward(dArray, 0, bl);
    }

    public void forward(final double[] dArray, final int n, boolean bl) {
        int n2;
        if (this.n == 1) {
            return;
        }
        int n3 = this.n / 2;
        int n4 = 1 + n;
        int n5 = n + this.n;
        for (n2 = n4; n2 < n5; n2 += 2) {
            dArray[n2] = -dArray[n2];
        }
        this.dct.forward(dArray, n, bl);
        n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && n3 > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            n2 = 2;
            int n6 = n3 / n2;
            Future[] futureArray = new Future[n2];
            for (int i = 0; i < n2; ++i) {
                final int n7 = i * n6;
                final int n8 = i == n2 - 1 ? n3 : n7 + n6;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n4 = n + DoubleDST_1D.this.n - 1;
                        for (int i = n7; i < n8; ++i) {
                            int n2 = n + i;
                            double d = dArray[n2];
                            int n3 = n4 - i;
                            dArray[n2] = dArray[n3];
                            dArray[n3] = d;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9 = n + this.n - 1;
            for (int i = 0; i < n3; ++i) {
                int n10 = n + i;
                double d = dArray[n10];
                int n11 = n9 - i;
                dArray[n10] = dArray[n11];
                dArray[n11] = d;
            }
        }
    }

    public void inverse(double[] dArray, boolean bl) {
        this.inverse(dArray, 0, bl);
    }

    public void inverse(final double[] dArray, final int n, boolean bl) {
        int n2;
        int n3;
        if (this.n == 1) {
            return;
        }
        int n4 = this.n / 2;
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && n4 > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            n5 = 2;
            n3 = n4 / n5;
            Future[] futureArray = new Future[n5];
            for (n2 = 0; n2 < n5; ++n2) {
                final int n6 = n2 * n3;
                final int n7 = n2 == n5 - 1 ? n4 : n6 + n3;
                futureArray[n2] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n4 = n + DoubleDST_1D.this.n - 1;
                        for (int i = n6; i < n7; ++i) {
                            int n2 = n + i;
                            double d = dArray[n2];
                            int n3 = n4 - i;
                            dArray[n2] = dArray[n3];
                            dArray[n3] = d;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            n3 = n + this.n - 1;
            for (int i = 0; i < n4; ++i) {
                double d = dArray[n + i];
                dArray[n + i] = dArray[n3 - i];
                dArray[n3 - i] = d;
            }
        }
        this.dct.inverse(dArray, n, bl);
        n3 = 1 + n;
        int n8 = n + this.n;
        for (n2 = n3; n2 < n8; n2 += 2) {
            dArray[n2] = -dArray[n2];
        }
    }
}

