/*
 * Decompiled with CFR 0.152.
 */
package test.it.unimi.dsi.mg4j.search;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import it.unimi.dsi.fastutil.ints.IntSortedSets;
import it.unimi.dsi.mg4j.search.Interval;
import it.unimi.dsi.mg4j.search.Intervals;
import java.util.Arrays;
import junit.framework.TestCase;

public class IntervalTest
extends TestCase {
    public void testLength() {
        IntervalTest.assertEquals((int)0, (int)Intervals.EMPTY_INTERVAL.length());
        IntervalTest.assertEquals((int)1, (int)Interval.valueOf(0).length());
        IntervalTest.assertEquals((int)2, (int)Interval.valueOf(0, 1).length());
    }

    public void testContainsElement() {
        IntervalTest.assertTrue((boolean)Interval.valueOf(0).contains(0));
        IntervalTest.assertFalse((boolean)Interval.valueOf(0).contains(1));
        IntervalTest.assertFalse((boolean)Interval.valueOf(0).contains(-1));
        IntervalTest.assertTrue((boolean)Interval.valueOf(0, 1).contains(0));
        IntervalTest.assertTrue((boolean)Interval.valueOf(0, 1).contains(1));
        IntervalTest.assertFalse((boolean)Interval.valueOf(0).contains(2));
        IntervalTest.assertFalse((boolean)Interval.valueOf(0).contains(-1));
        IntervalTest.assertFalse((boolean)Intervals.EMPTY_INTERVAL.contains(0));
        IntervalTest.assertFalse((boolean)Intervals.EMPTY_INTERVAL.contains(1));
        IntervalTest.assertFalse((boolean)Intervals.EMPTY_INTERVAL.contains(-1));
    }

    public void testContainsInterval() {
        IntervalTest.assertTrue((boolean)Interval.valueOf(0).contains(Interval.valueOf(0)));
        IntervalTest.assertTrue((boolean)Interval.valueOf(0).contains(Intervals.EMPTY_INTERVAL));
        IntervalTest.assertFalse((boolean)Interval.valueOf(0).contains(Interval.valueOf(0, 1)));
        IntervalTest.assertFalse((boolean)Interval.valueOf(0).contains(Interval.valueOf(-1, 0)));
        IntervalTest.assertTrue((boolean)Interval.valueOf(0, 1).contains(Interval.valueOf(0)));
        IntervalTest.assertTrue((boolean)Interval.valueOf(0, 1).contains(Interval.valueOf(1)));
        IntervalTest.assertTrue((boolean)Interval.valueOf(0, 1).contains(Interval.valueOf(0, 1)));
        IntervalTest.assertTrue((boolean)Interval.valueOf(0, 1).contains(Intervals.EMPTY_INTERVAL));
        IntervalTest.assertFalse((boolean)Interval.valueOf(0).contains(Interval.valueOf(-1, 0)));
        IntervalTest.assertFalse((boolean)Interval.valueOf(0).contains(Interval.valueOf(1, 2)));
        IntervalTest.assertFalse((boolean)Interval.valueOf(0).contains(Interval.valueOf(-1, 2)));
        IntervalTest.assertTrue((boolean)Intervals.EMPTY_INTERVAL.contains(Intervals.EMPTY_INTERVAL));
        IntervalTest.assertFalse((boolean)Intervals.EMPTY_INTERVAL.contains(Interval.valueOf(0)));
        IntervalTest.assertFalse((boolean)Intervals.EMPTY_INTERVAL.contains(Interval.valueOf(1)));
        IntervalTest.assertFalse((boolean)Intervals.EMPTY_INTERVAL.contains(Interval.valueOf(0, 1)));
    }

    public void testContainsRadius() {
        boolean ok = false;
        try {
            Intervals.EMPTY_INTERVAL.contains(0, 1);
        }
        catch (IllegalArgumentException e) {
            ok = true;
        }
        IntervalTest.assertTrue((boolean)ok);
        IntervalTest.assertTrue((boolean)Interval.valueOf(0).contains(1, 1));
        IntervalTest.assertFalse((boolean)Interval.valueOf(0).contains(2, 1));
        ok = false;
        try {
            Intervals.EMPTY_INTERVAL.contains(0, 1, 2);
        }
        catch (IllegalArgumentException e) {
            ok = true;
        }
        IntervalTest.assertTrue((boolean)ok);
        IntervalTest.assertTrue((boolean)Interval.valueOf(0).contains(1, 1, 2));
        IntervalTest.assertTrue((boolean)Interval.valueOf(0).contains(2, 1, 2));
        IntervalTest.assertFalse((boolean)Interval.valueOf(0).contains(3, 1, 2));
    }

    public void testCompareInt() {
        boolean ok = false;
        try {
            Intervals.EMPTY_INTERVAL.compareTo(0);
        }
        catch (IllegalArgumentException e) {
            ok = true;
        }
        IntervalTest.assertTrue((boolean)ok);
        IntervalTest.assertEquals((int)-1, (int)Interval.valueOf(0).compareTo(-1));
        IntervalTest.assertEquals((int)0, (int)Interval.valueOf(0).compareTo(0));
        IntervalTest.assertEquals((int)1, (int)Interval.valueOf(0).compareTo(1));
        IntervalTest.assertEquals((int)-1, (int)Interval.valueOf(0, 1).compareTo(-1));
        IntervalTest.assertEquals((int)0, (int)Interval.valueOf(0, 1).compareTo(0));
        IntervalTest.assertEquals((int)0, (int)Interval.valueOf(0, 1).compareTo(1));
        IntervalTest.assertEquals((int)1, (int)Interval.valueOf(0, 1).compareTo(2));
        ok = false;
        try {
            Intervals.EMPTY_INTERVAL.compareTo(0, 1);
        }
        catch (IllegalArgumentException e) {
            ok = true;
        }
        IntervalTest.assertTrue((boolean)ok);
        IntervalTest.assertEquals((int)-1, (int)Interval.valueOf(0).compareTo(-2, 1));
        IntervalTest.assertEquals((int)0, (int)Interval.valueOf(0).compareTo(-1, 1));
        IntervalTest.assertEquals((int)0, (int)Interval.valueOf(0).compareTo(0, 1));
        IntervalTest.assertEquals((int)0, (int)Interval.valueOf(0).compareTo(1, 1));
        IntervalTest.assertEquals((int)1, (int)Interval.valueOf(0).compareTo(2, 1));
        IntervalTest.assertEquals((int)-1, (int)Interval.valueOf(0, 1).compareTo(-2, 1));
        IntervalTest.assertEquals((int)0, (int)Interval.valueOf(0, 1).compareTo(-1, 1));
        IntervalTest.assertEquals((int)0, (int)Interval.valueOf(0, 1).compareTo(0, 1));
        IntervalTest.assertEquals((int)0, (int)Interval.valueOf(0, 1).compareTo(1, 1));
        IntervalTest.assertEquals((int)0, (int)Interval.valueOf(0, 1).compareTo(2, 1));
        IntervalTest.assertEquals((int)1, (int)Interval.valueOf(0, 1).compareTo(3, 1));
        ok = false;
        try {
            Intervals.EMPTY_INTERVAL.compareTo(0, 1, 2);
        }
        catch (IllegalArgumentException e) {
            ok = true;
        }
        IntervalTest.assertTrue((boolean)ok);
        IntervalTest.assertEquals((int)-1, (int)Interval.valueOf(0).compareTo(-2, 1, 2));
        IntervalTest.assertEquals((int)0, (int)Interval.valueOf(0).compareTo(-1, 1, 2));
        IntervalTest.assertEquals((int)0, (int)Interval.valueOf(0).compareTo(0, 1, 2));
        IntervalTest.assertEquals((int)0, (int)Interval.valueOf(0).compareTo(1, 1, 2));
        IntervalTest.assertEquals((int)0, (int)Interval.valueOf(0).compareTo(2, 1, 2));
        IntervalTest.assertEquals((int)1, (int)Interval.valueOf(0).compareTo(3, 1, 2));
        IntervalTest.assertEquals((int)-1, (int)Interval.valueOf(0, 1).compareTo(-2, 1, 2));
        IntervalTest.assertEquals((int)0, (int)Interval.valueOf(0, 1).compareTo(-1, 1, 2));
        IntervalTest.assertEquals((int)0, (int)Interval.valueOf(0, 1).compareTo(0, 1, 2));
        IntervalTest.assertEquals((int)0, (int)Interval.valueOf(0, 1).compareTo(1, 1, 2));
        IntervalTest.assertEquals((int)0, (int)Interval.valueOf(0, 1).compareTo(2, 1, 2));
        IntervalTest.assertEquals((int)0, (int)Interval.valueOf(0, 1).compareTo(3, 1, 2));
        IntervalTest.assertEquals((int)1, (int)Interval.valueOf(0, 1).compareTo(4, 1, 2));
    }

    private IntSortedSet toSortedSet(Interval interval) {
        if (interval == Intervals.EMPTY_INTERVAL) {
            return IntSortedSets.EMPTY_SET;
        }
        IntRBTreeSet set = new IntRBTreeSet();
        for (int i = interval.left; i <= interval.right; ++i) {
            set.add(i);
        }
        return set;
    }

    public void testSubsets() {
        for (int i = 0; i < 10; ++i) {
            for (int j = i - 1; j < 10; ++j) {
                Interval interval = j < i ? Intervals.EMPTY_INTERVAL : Interval.valueOf(i, j);
                IntSortedSet set = this.toSortedSet(interval);
                IntervalTest.assertEquals((Object)set, (Object)interval);
                IntervalTest.assertTrue((boolean)Arrays.equals(IntIterators.unwrap((IntIterator)set.iterator()), IntIterators.unwrap((IntIterator)set.iterator())));
                IntervalTest.assertEquals((Object)new IntOpenHashSet((IntCollection)set), (Object)interval);
                for (int k = j - 1; k <= i + 1; ++k) {
                    IntervalTest.assertTrue((boolean)Arrays.equals(IntIterators.unwrap((IntIterator)set.iterator(k)), IntIterators.unwrap((IntIterator)set.iterator(k))));
                    IntervalTest.assertEquals((Object)set.headSet(k), (Object)interval.headSet(k));
                    IntervalTest.assertEquals((Object)set.tailSet(k), (Object)interval.tailSet(k));
                    for (int l = k; l <= i + 1; ++l) {
                        IntervalTest.assertEquals((Object)set.subSet(k, l), (Object)interval.subSet(k, l));
                    }
                }
            }
        }
    }
}

