/*
 * Decompiled with CFR 0.152.
 */
package it.unipi.di.util;

import it.unimi.dsi.mg4j.util.MutableString;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.regex.Pattern;
import java.util.zip.Deflater;

public abstract class Utils {
    private static ByteBuffer bb = ByteBuffer.allocateDirect(8);
    private static double giga = Math.pow(2.0, 30.0);
    private static double mega = Math.pow(2.0, 20.0);
    private static double kilo = Math.pow(2.0, 10.0);
    private static int[] offsets = new int[1000000];
    private static char[] chars = new char[100000];
    private static byte[] buff = new byte[(int)Math.pow(2.0, 10.0) * 16];

    private Utils() {
    }

    public static double round(double val, int precision) {
        return (double)Math.round(val * (double)precision) / (double)precision;
    }

    public static String formatSize(long size) {
        if ((double)size >= giga) {
            return Utils.round((double)size / giga, 10) + "GB";
        }
        if ((double)size >= mega) {
            return Utils.round((double)size / mega, 10) + "MB";
        }
        if ((double)size >= kilo) {
            return Utils.round((double)size / kilo, 10) + "KB";
        }
        return size + " bytes";
    }

    public static String elapsedTime(long start, long stop) {
        return Utils.elapsedTime(stop - start);
    }

    public static String elapsedTime(long msecs) {
        int timeInSeconds = (int)msecs / 1000;
        int hours = timeInSeconds / 3600;
        int minutes = (timeInSeconds -= hours * 3600) / 60;
        int seconds = timeInSeconds -= minutes * 60;
        return hours + "h " + minutes + "min " + seconds + "sec";
    }

    public static byte[] intToBytes(int val) {
        return new byte[]{(byte)(val >>> 24), (byte)(val >>> 16), (byte)(val >>> 8), (byte)val};
    }

    public static byte[] longToBytes(long val) {
        bb.clear();
        bb.putLong(val);
        bb.flip();
        byte[] byteData = new byte[8];
        bb.get(byteData);
        return byteData;
    }

    public static byte[] merge(byte[] b1, byte[] b2) {
        byte[] buff = new byte[b1.length + b2.length];
        System.arraycopy(b1, 0, buff, 0, b1.length);
        System.arraycopy(b2, 0, buff, b1.length, b2.length);
        return buff;
    }

    public static long bytesToLong(byte[] array) {
        bb.clear();
        bb.put(array);
        bb.flip();
        return bb.getLong();
    }

    public static int bytesToInt(byte[] array) {
        int i = (0xFF & array[0]) << 24;
        i |= (0xFF & array[1]) << 16;
        i |= (0xFF & array[2]) << 8;
        return i |= 0xFF & array[3];
    }

    public static byte[] zip(byte[] input, int off, int len) {
        Deflater compressor = new Deflater();
        compressor.setLevel(9);
        compressor.setInput(input, off, len);
        compressor.finish();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(input.length);
        byte[] buf = new byte[1024];
        while (!compressor.finished()) {
            int count = compressor.deflate(buf);
            bos.write(buf, 0, count);
        }
        compressor.end();
        return bos.toByteArray();
    }

    public static byte[] loadFromDisk(String file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        FileChannel ch = fis.getChannel();
        ByteBuffer buff = ByteBuffer.allocate((int)ch.size());
        ch.read(buff);
        fis.close();
        ch.close();
        return buff.array();
    }

    public static String getSortingCols(String line, int[] fields, Pattern p) {
        int i;
        if (fields == null || fields.length == 0) {
            return line;
        }
        String[] a = p.split(line);
        StringBuffer sb = new StringBuffer();
        for (i = 0; i < fields.length - 1; ++i) {
            sb.append(a[fields[i]]);
            sb.append(p.pattern());
        }
        sb.append(a[fields[i]]);
        return sb.toString();
    }

    public static String trimLeftZeros(String str) {
        int i;
        for (i = 0; i < str.length() && str.charAt(i) == '0'; ++i) {
        }
        return str.substring(i);
    }

    public static String getKey(String line, int[] cols, char sep, boolean numeric) {
        if (cols.length == 0) {
            return numeric ? Utils.pad(line) : line;
        }
        int j = 1;
        Utils.offsets[0] = -1;
        for (int i = 0; i < line.length(); ++i) {
            if (line.charAt(i) != sep) continue;
            Utils.offsets[j] = i;
            ++j;
        }
        Utils.offsets[j] = line.length();
        int n = 0;
        for (int i = 0; i < cols.length; ++i) {
            int dim;
            int stop;
            if (cols[i] > j) continue;
            int start = offsets[cols[i]] + 1;
            int n2 = stop = cols[i] + 1 > j ? -1 : offsets[cols[i] + 1];
            if (numeric && (dim = stop - start) < 20) {
                int padding = 20 - dim;
                int limit = n + padding;
                while (n < limit) {
                    Utils.chars[n] = 48;
                    ++n;
                }
            }
            for (int k = start; k < stop; ++k) {
                Utils.chars[n] = line.charAt(k);
                ++n;
            }
            Utils.chars[n] = sep;
            ++n;
        }
        if (n == 0) {
            return "";
        }
        return new String(chars, 0, n - 1);
    }

    public static String pad(String str) {
        int n;
        for (n = 0; n < 20 - str.length(); ++n) {
            Utils.chars[n] = 48;
        }
        int limit = n + str.length();
        int i = 0;
        while (n < limit) {
            Utils.chars[n] = str.charAt(i++);
            ++n;
        }
        return new String(chars, 0, n);
    }

    public static long getLong(byte[] buff, int pos) {
        return (long)(buff[pos] & 0xFF) << 56 | (long)((buff[pos + 1] & 0xFF) << 48) | (long)((buff[pos + 2] & 0xFF) << 40) | (long)((buff[pos + 3] & 0xFF) << 32) | (long)((buff[pos + 4] & 0xFF) << 24) | (long)((buff[pos + 5] & 0xFF) << 16) | (long)((buff[pos + 6] & 0xFF) << 8) | (long)((buff[pos + 7] & 0xFF) << 0);
    }

    public static MutableString getField(MutableString rec, int field, MutableString fieldSeparator) {
        if (field == -1) {
            return rec;
        }
        int l = fieldSeparator.length();
        int start = 0;
        int end = 0;
        for (int k = -1; k < field; ++k) {
            start = end;
            if ((end = rec.indexOf(fieldSeparator, end)) == -1) {
                end = rec.length();
                continue;
            }
            end += l;
        }
        if (start == end) {
            return null;
        }
        return rec.substring(start, end);
    }
}

