/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.io;

import edu.ucsc.genome.TrackHeader;
import edu.unc.genomics.Contig;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import org.apache.log4j.Logger;

public class WigFileWriter
implements Closeable {
    private static final Logger log = Logger.getLogger(WigFileWriter.class);
    private static final DecimalFormat formatter = new DecimalFormat();
    private final Path p;
    private final PrintWriter writer;

    public WigFileWriter(Path p, OpenOption ... options) throws IOException {
        this.p = p;
        log.debug((Object)("Initializing Wig file writer " + p));
        this.writer = new PrintWriter(Files.newBufferedWriter(p, Charset.defaultCharset(), options));
    }

    public WigFileWriter(Path p, TrackHeader header) throws IOException {
        this(p, new OpenOption[0]);
        if (header.getType() != TrackHeader.Type.WIGGLE) {
            log.error((Object)("Refusing to write track header with type=" + header.getType().getId() + " to Wig file"));
        } else {
            log.debug((Object)("Writing Wig file header: " + header));
            this.writer.println(header);
        }
    }

    @Override
    public final void close() throws IOException {
        log.debug((Object)("Closing Wig file writer " + this.p));
        this.writer.close();
    }

    public final void write(Contig contig) {
        float sparsity = (float)contig.coverage() / (float)contig.length();
        if ((double)sparsity < 0.55 || contig.getVariableStepSpan() > contig.getMinStep()) {
            this.writeVariableStepContig(contig);
        } else {
            this.writeFixedStepContig(contig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeFixedStepContig(Contig contig) {
        log.debug((Object)("Writing contig: " + contig.getFixedStepHeader()));
        PrintWriter printWriter = this.writer;
        synchronized (printWriter) {
            this.writer.println(contig.getFixedStepHeader());
            int step = contig.getMinStep();
            for (int bp = contig.getFirstBaseWithData(); bp <= contig.high(); bp += step) {
                this.writer.println(formatter.format(contig.get(bp)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeVariableStepContig(Contig contig) {
        log.debug((Object)("Writing contig: " + contig.getVariableStepHeader()));
        PrintWriter printWriter = this.writer;
        synchronized (printWriter) {
            this.writer.println(contig.getVariableStepHeader());
            int bp = contig.getFirstBaseWithData();
            int span = contig.getVariableStepSpan();
            while (bp <= contig.high()) {
                float value = contig.get(bp);
                if (!Float.isNaN(value)) {
                    this.writer.println(bp + "\t" + formatter.format(value));
                    bp += span;
                    continue;
                }
                ++bp;
            }
        }
    }

    public final Path getPath() {
        return this.p;
    }

    static {
        formatter.setMaximumFractionDigits(8);
        formatter.setGroupingUsed(false);
        DecimalFormatSymbols symbols = formatter.getDecimalFormatSymbols();
        symbols.setInfinity("Inf");
        symbols.setNaN("NaN");
        formatter.setDecimalFormatSymbols(symbols);
    }
}

