/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics;

import edu.unc.genomics.SubmittedJob;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.apache.log4j.Logger;

public class JobQueue
implements ListModel<SubmittedJob>,
Iterable<SubmittedJob> {
    private static final Logger log = Logger.getLogger(JobQueue.class);
    private final List<SubmittedJob> submittedJobs = new ArrayList<SubmittedJob>();
    private final List<ListDataListener> dataListeners = new ArrayList<ListDataListener>();

    public void add(SubmittedJob job) {
        int N = this.submittedJobs.size();
        this.submittedJobs.add(job);
        ListDataEvent e = new ListDataEvent(this, 1, N, N);
        for (ListDataListener l : this.dataListeners) {
            l.intervalAdded(e);
        }
    }

    public void remove(SubmittedJob job) {
        this.submittedJobs.remove(job);
        int N = this.submittedJobs.size();
        ListDataEvent e = new ListDataEvent(this, 2, N, N);
        for (ListDataListener l : this.dataListeners) {
            l.intervalAdded(e);
        }
    }

    public void update(SubmittedJob job) {
        int index = this.submittedJobs.indexOf(job);
        ListDataEvent e = new ListDataEvent(this, 0, index, index);
        for (ListDataListener l : this.dataListeners) {
            l.intervalAdded(e);
        }
    }

    @Override
    public int getSize() {
        return this.submittedJobs.size();
    }

    @Override
    public SubmittedJob getElementAt(int index) {
        return this.submittedJobs.get(index);
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        this.dataListeners.add(l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this.dataListeners.remove(l);
    }

    @Override
    public Iterator<SubmittedJob> iterator() {
        return this.submittedJobs.iterator();
    }
}

