/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.document;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.mg4j.document.AbstractDocumentIterator;
import it.unimi.dsi.mg4j.document.CompositeDocumentFactory;
import it.unimi.dsi.mg4j.document.Document;
import it.unimi.dsi.mg4j.document.DocumentFactory;
import it.unimi.dsi.mg4j.document.DocumentIterator;
import it.unimi.dsi.mg4j.document.DocumentSequence;
import it.unimi.dsi.mg4j.document.IdentityDocumentFactory;
import it.unimi.dsi.mg4j.document.JdbcDocumentCollection;
import it.unimi.dsi.mg4j.document.PropertyBasedDocumentFactory;
import it.unimi.dsi.mg4j.io.MultipleInputStream;
import it.unimi.dsi.mg4j.util.MG4JClassParser;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;

public class CSVDocumentCollection
implements DocumentSequence,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String fileName;
    private final String separator;
    private final String[] column;
    private final int titleColumn;
    private final DocumentFactory factory;
    private transient BufferedReader reader;
    private transient int readLines;

    public CSVDocumentCollection(String fileName, String separator, String[] column, int titleColumn, DocumentFactory factory) throws FileNotFoundException {
        this.fileName = fileName;
        this.separator = separator;
        this.column = column;
        if (titleColumn >= column.length) {
            throw new IllegalArgumentException("The title column (" + titleColumn + ") is larger than or equal to the number of columns (" + column.length + ")");
        }
        this.titleColumn = titleColumn;
        this.factory = factory;
        this.reader = new BufferedReader(new InputStreamReader(new FileInputStream(fileName)));
        this.readLines = -1;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.reader = new BufferedReader(new InputStreamReader(new FileInputStream(this.fileName)));
        this.readLines = -1;
    }

    public DocumentIterator iterator() {
        return new AbstractDocumentIterator(){
            final Reference2ObjectMap<Enum<?>, Object> metadata = new Reference2ObjectArrayMap(2);

            public Document nextDocument() throws IOException {
                String line = CSVDocumentCollection.this.reader.readLine();
                if (line == null) {
                    return null;
                }
                CSVDocumentCollection.this.readLines++;
                String[] field = line.split(CSVDocumentCollection.this.separator);
                if (field.length != CSVDocumentCollection.this.column.length) {
                    throw new IOException("Line " + CSVDocumentCollection.this.readLines + " has less (" + field.length + ") fields than the number of columns (" + CSVDocumentCollection.this.column.length + ").");
                }
                InputStream[] a = new InputStream[CSVDocumentCollection.this.column.length];
                for (int i = 0; i < CSVDocumentCollection.this.column.length; ++i) {
                    a[i] = new ByteArrayInputStream(field[i].getBytes());
                }
                String title = CSVDocumentCollection.this.titleColumn >= 0 ? field[CSVDocumentCollection.this.titleColumn] : Integer.toString(CSVDocumentCollection.this.readLines);
                this.metadata.put((Object)PropertyBasedDocumentFactory.MetadataKeys.TITLE, (Object)title);
                this.metadata.put((Object)PropertyBasedDocumentFactory.MetadataKeys.URI, (Object)Integer.toString(CSVDocumentCollection.this.readLines));
                return CSVDocumentCollection.this.factory.getDocument(MultipleInputStream.getStream(a), this.metadata);
            }
        };
    }

    public DocumentFactory factory() {
        return this.factory;
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public static void main(String[] arg) throws JSAPException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, IOException, InstantiationException {
        SimpleJSAP jsap = new SimpleJSAP(JdbcDocumentCollection.class.getName(), "Saves a serialised document collection based on a set of database rows.", new Parameter[]{new FlaggedOption("separator", (StringParser)JSAP.STRING_PARSER, ",", false, 's', "separator", "The regexp used to split lines into fields."), new FlaggedOption("factory", (StringParser)MG4JClassParser.getParser(), IdentityDocumentFactory.class.getName(), false, 'f', "factory", "A document factory with a standard constructor."), new FlaggedOption("property", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'p', "property", "A 'key=value' specification, or the name of a property file").setAllowMultipleDeclarations(true), new FlaggedOption("titleColumn", (StringParser)JSAP.INTEGER_PARSER, "-1", false, 't', "title-column", "The index of the column to be used as a title (starting from 0)."), new UnflaggedOption("collection", (StringParser)JSAP.STRING_PARSER, true, "The filename for the serialised collection."), new UnflaggedOption("fileName", (StringParser)JSAP.STRING_PARSER, true, "The filename of the source CSV file."), new UnflaggedOption("column", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, true, "Columns names that will be indexed.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        int titleColumn = jsapResult.getInt("titleColumn");
        String collection = jsapResult.getString("collection");
        String fileName = jsapResult.getString("fileName");
        String separator = jsapResult.getString("separator").equals("\\t") ? "\t" : jsapResult.getString("separator");
        String[] column = jsapResult.getStringArray("column");
        DocumentFactory[] factory = new DocumentFactory[column.length];
        for (int i = 0; i < factory.length; ++i) {
            factory[i] = PropertyBasedDocumentFactory.getInstance(jsapResult.getClass("factory"), jsapResult.getStringArray("property"));
        }
        BinIO.storeObject((Object)new CSVDocumentCollection(fileName, separator, column, titleColumn, CompositeDocumentFactory.getFactory(factory, column)), (CharSequence)collection);
    }
}

