/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.document;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.mg4j.document.AbstractDocumentCollection;
import it.unimi.dsi.mg4j.document.Document;
import it.unimi.dsi.mg4j.document.DocumentFactory;
import it.unimi.dsi.mg4j.document.IdentityDocumentFactory;
import it.unimi.dsi.mg4j.document.PropertyBasedDocumentFactory;
import it.unimi.dsi.mg4j.io.FileLinesCollection;
import it.unimi.dsi.mg4j.io.NullInputStream;
import it.unimi.dsi.mg4j.util.MG4JClassParser;
import it.unimi.dsi.mg4j.util.MimeTypeResolver;
import it.unimi.dsi.mg4j.util.MutableString;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSetDocumentCollection
extends AbstractDocumentCollection
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final String[] file;
    private final String[] uri;
    private final DocumentFactory factory;
    private InputStream last = NullInputStream.getInstance();

    public FileSetDocumentCollection(String[] file, DocumentFactory factory) {
        this(file, null, factory);
    }

    public FileSetDocumentCollection(String[] file, String[] uri, DocumentFactory factory) {
        this.file = file;
        this.uri = uri;
        this.factory = factory;
    }

    @Override
    public DocumentFactory factory() {
        return this.factory;
    }

    @Override
    public int size() {
        return this.file.length;
    }

    @Override
    public Reference2ObjectMap<Enum<?>, Object> metadata(int index) {
        this.ensureDocumentIndex(index);
        Reference2ObjectArrayMap metadata = new Reference2ObjectArrayMap(2);
        metadata.put((Object)PropertyBasedDocumentFactory.MetadataKeys.TITLE, (Object)this.file[index]);
        if (this.uri != null) {
            metadata.put((Object)PropertyBasedDocumentFactory.MetadataKeys.URI, (Object)this.uri[index]);
        } else {
            metadata.put((Object)PropertyBasedDocumentFactory.MetadataKeys.URI, (Object)new File(this.file[index]).toURI().toString());
        }
        metadata.put((Object)PropertyBasedDocumentFactory.MetadataKeys.MIMETYPE, (Object)MimeTypeResolver.getContentType(this.file[index]));
        return metadata;
    }

    @Override
    public Document document(int index) throws IOException {
        return this.factory.getDocument(this.stream(index), this.metadata(index));
    }

    @Override
    public InputStream stream(int index) throws IOException {
        this.ensureDocumentIndex(index);
        this.last.close();
        this.last = new FileInputStream(this.file[index]);
        return this.last;
    }

    @Override
    public FileSetDocumentCollection copy() {
        return new FileSetDocumentCollection(this.file, this.uri, this.factory.copy());
    }

    @Override
    public void close() throws IOException {
        this.last.close();
        super.close();
    }

    public static void main(String[] arg) throws IOException, JSAPException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        SimpleJSAP jsap = new SimpleJSAP(FileSetDocumentCollection.class.getName(), "Saves a serialised document collection based on a set of files.", new Parameter[]{new FlaggedOption("factory", (StringParser)MG4JClassParser.getParser(), IdentityDocumentFactory.class.getName(), false, 'f', "factory", "A document factory with a standard constructor."), new FlaggedOption("property", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'p', "property", "A 'key=value' specification, or the name of a property file").setAllowMultipleDeclarations(true), new FlaggedOption("uris", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'u', "uris", "A file containing a list of URIs in ASCII encoding, one per line, that will be associated to each file"), new UnflaggedOption("collection", (StringParser)JSAP.STRING_PARSER, true, "The filename for the serialised collection."), new UnflaggedOption("file", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, true, "A list of files that will be indexed. If missing, a list of files will be read from standard input.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        String[] uri = null;
        if (jsapResult.getString("uris") != null) {
            List<MutableString> lines = new FileLinesCollection(jsapResult.getString("uris"), "ASCII").allLines();
            uri = new String[lines.size()];
            int i = 0;
            for (MutableString l : lines) {
                uri[i++] = ((Object)l).toString();
            }
        }
        PropertyBasedDocumentFactory factory = PropertyBasedDocumentFactory.getInstance(jsapResult.getClass("factory"), jsapResult.getStringArray("property"));
        String[] file = (String[])jsapResult.getObjectArray("file", (Object[])new String[0]);
        if (file.length == 0) {
            String s;
            ObjectArrayList files = new ObjectArrayList();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            while ((s = bufferedReader.readLine()) != null) {
                files.add((Object)s);
            }
            file = (String[])files.toArray((Object[])new String[0]);
        }
        if (file.length == 0) {
            System.err.println("WARNING: empty file set.");
        }
        if (uri != null && file.length != uri.length) {
            throw new IllegalArgumentException("The number of files (" + file.length + ") and the number of URIs (" + uri.length + ") differ");
        }
        BinIO.storeObject((Object)new FileSetDocumentCollection(file, uri, factory), (CharSequence)jsapResult.getString("collection"));
    }
}

