/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.ParameterException;
import edu.unc.genomics.Assembly;
import edu.unc.genomics.PathConverter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.zip.DataFormatException;

public class AssemblyConverter
implements IStringConverter<Assembly> {
    public static final Path ASSEMBLIES_DIR = Paths.get("resources", "assemblies");

    public Assembly convert(String value) throws ParameterException {
        PathConverter converter;
        Path p = ASSEMBLIES_DIR.resolve(value + ".len");
        if (!Files.isReadable(p) && !Files.isReadable(p = (converter = new PathConverter()).convert(value))) {
            throw new ParameterException("Cannot find Assembly file: " + value);
        }
        try {
            return new Assembly(p);
        }
        catch (IOException | DataFormatException e) {
            throw new ParameterException("Error loading Assembly from file: " + p);
        }
    }
}

