/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.index.remote;

import it.unimi.dsi.mg4j.index.AbstractPrefixMap;
import it.unimi.dsi.mg4j.index.PrefixMap;
import it.unimi.dsi.mg4j.index.remote.RemoteIndexServerConnection;
import it.unimi.dsi.mg4j.search.Interval;
import it.unimi.dsi.mg4j.util.Fast;
import it.unimi.dsi.mg4j.util.MutableString;
import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;
import java.net.SocketAddress;
import org.apache.log4j.Logger;

public class RemotePrefixMap
extends AbstractPrefixMap
implements PrefixMap,
Serializable {
    static final long serialVersionUID = 1L;
    private SocketAddress address;
    private transient RemoteIndexServerConnection remoteConnection;
    private final int size;
    public static final byte GET_INTERVAL = 0;
    public static final byte GET_PREFIX = 1;
    public static final byte HAS_PREFIXES = 2;

    public RemotePrefixMap(SocketAddress address, int size) {
        this.address = address;
        this.size = size;
    }

    public int size() {
        return this.size;
    }

    private void ensureConnection() throws IOException {
        if (this.remoteConnection == null) {
            this.remoteConnection = new RemoteIndexServerConnection(this.address, 3);
        }
    }

    public Interval getInterval(CharSequence prefix) {
        try {
            this.ensureConnection();
            this.remoteConnection.outputStream.writeByte(0);
            new MutableString(prefix).writeSelfDelimUTF8(this.remoteConnection.outputStream);
            this.remoteConnection.outputStream.flush();
            return Interval.valueOf(this.remoteConnection.inputStream.readInt(), this.remoteConnection.inputStream.readInt());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public CharSequence getPrefix(Interval interval) {
        try {
            this.ensureConnection();
            this.remoteConnection.outputStream.writeByte(1);
            this.remoteConnection.outputStream.writeInt(interval.left);
            this.remoteConnection.outputStream.writeInt(interval.right);
            this.remoteConnection.outputStream.flush();
            return new MutableString().readSelfDelimUTF8(this.remoteConnection.inputStream);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean hasPrefixes() {
        try {
            this.ensureConnection();
            this.remoteConnection.outputStream.writeByte(2);
            this.remoteConnection.outputStream.flush();
            return this.remoteConnection.inputStream.readBoolean();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class ServerThread
    extends it.unimi.dsi.mg4j.index.remote.ServerThread {
        private static final boolean DEBUG = false;
        private static final Logger LOGGER = Fast.getLogger(ServerThread.class);
        private final PrefixMap prefixMap;

        public ServerThread(Socket socket, PrefixMap prefixMap) throws IOException {
            super(socket);
            this.prefixMap = prefixMap;
        }

        public void run() {
            try {
                MutableString s = new MutableString();
                block8: while (true) {
                    byte command = this.inputStream.readByte();
                    switch (command) {
                        case 0: {
                            Interval interval = this.prefixMap.getInterval(s.readSelfDelimUTF8(this.inputStream));
                            this.outputStream.writeInt(interval.left);
                            this.outputStream.writeInt(interval.right);
                            this.outputStream.flush();
                            continue block8;
                        }
                        case 1: {
                            this.prefixMap.getPrefix(Interval.valueOf(this.inputStream.readInt(), this.inputStream.readInt()), s).writeSelfDelimUTF8(this.outputStream);
                            this.outputStream.flush();
                            continue block8;
                        }
                        case 2: {
                            this.outputStream.writeBoolean(this.prefixMap.hasPrefixes());
                            this.outputStream.flush();
                            continue block8;
                        }
                    }
                    LOGGER.error((Object)("Unknown remote command: " + command));
                }
            }
            catch (EOFException e) {
                LOGGER.warn((Object)"The socket has been closed");
            }
            catch (Exception e) {
                LOGGER.fatal((Object)e, (Throwable)e);
            }
        }
    }
}

