/*
 * Decompiled with CFR 0.152.
 */
package test.it.unimi.dsi.mg4j.util;

import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectRBTreeSet;
import it.unimi.dsi.fastutil.objects.ObjectSets;
import it.unimi.dsi.mg4j.search.Interval;
import it.unimi.dsi.mg4j.search.Intervals;
import it.unimi.dsi.mg4j.util.ImmutableExternalTriePrefixDictionary;
import it.unimi.dsi.mg4j.util.TernaryIntervalSearchTree;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import test.it.unimi.dsi.mg4j.util.TernaryIntervalSearchTreeTest;

public class ImmutableExternalTriePrefixDictionaryTest
extends TestCase {
    public void testLargeSet(int blockSize) throws IOException {
        int j;
        int i;
        List<String> c = Arrays.asList(TernaryIntervalSearchTreeTest.WORDS);
        TernaryIntervalSearchTree t = new TernaryIntervalSearchTree(c);
        ImmutableExternalTriePrefixDictionary d = new ImmutableExternalTriePrefixDictionary(c, blockSize);
        for (i = 0; i < TernaryIntervalSearchTreeTest.WORDS.length; ++i) {
            ImmutableExternalTriePrefixDictionaryTest.assertTrue((String)TernaryIntervalSearchTreeTest.WORDS[i], (boolean)d.contains(TernaryIntervalSearchTreeTest.WORDS[i]));
        }
        for (i = 0; i < TernaryIntervalSearchTreeTest.WORDS.length; ++i) {
            ImmutableExternalTriePrefixDictionaryTest.assertEquals((String)TernaryIntervalSearchTreeTest.WORDS[i], (String)((Object)d.get(i)).toString());
        }
        for (i = 0; i < TernaryIntervalSearchTreeTest.WORDS.length; ++i) {
            for (j = 0; j < TernaryIntervalSearchTreeTest.WORDS[i].length(); ++j) {
                String s = TernaryIntervalSearchTreeTest.WORDS[i].substring(0, j + 1);
                ImmutableExternalTriePrefixDictionaryTest.assertEquals((String)s, (Object)t.getInterval(s), (Object)d.getInterval(s));
                s = s + " ";
                ImmutableExternalTriePrefixDictionaryTest.assertEquals((String)s, (Object)t.getInterval(s), (Object)d.getInterval(s));
                s = s.substring(0, s.length() - 1) + "~";
                ImmutableExternalTriePrefixDictionaryTest.assertEquals((String)s, (Object)t.getInterval(s), (Object)d.getInterval(s));
            }
        }
        ObjectRBTreeSet p = new ObjectRBTreeSet();
        for (int i2 = 0; i2 < TernaryIntervalSearchTreeTest.WORDS.length; ++i2) {
            for (int j2 = 0; j2 < TernaryIntervalSearchTreeTest.WORDS[i2].length(); ++j2) {
                p.add(TernaryIntervalSearchTreeTest.WORDS[i2].substring(0, j2 + 1));
            }
        }
        d = new ImmutableExternalTriePrefixDictionary((Iterable<? extends CharSequence>)p, blockSize);
        t = new TernaryIntervalSearchTree((Collection<? extends CharSequence>)p);
        j = 0;
        for (String s : p) {
            ImmutableExternalTriePrefixDictionaryTest.assertTrue((String)s, (boolean)d.contains(s));
            ImmutableExternalTriePrefixDictionaryTest.assertEquals((String)s, (String)((Object)d.get(j++)).toString());
            ImmutableExternalTriePrefixDictionaryTest.assertEquals((String)s, (Object)t.getInterval(s), (Object)d.getInterval(s));
        }
        ObjectIterator<CharSequence> k = d.iterator();
        Iterator i3 = p.iterator();
        while (i3.hasNext()) {
            ImmutableExternalTriePrefixDictionaryTest.assertEquals((boolean)i3.hasNext(), (boolean)k.hasNext());
            ImmutableExternalTriePrefixDictionaryTest.assertEquals((String)((String)i3.next()).toString(), (String)((Object)((CharSequence)k.next())).toString());
        }
    }

    public void testLargeSet64() throws IOException {
        this.testLargeSet(64);
    }

    public void testLargeSet128() throws IOException {
        this.testLargeSet(128);
    }

    public void testLargeSet256() throws IOException {
        this.testLargeSet(256);
    }

    public void testLargeSet1024() throws IOException {
        this.testLargeSet(1024);
    }

    public void testLargeSet16384() throws IOException {
        this.testLargeSet(16384);
    }

    public void testSingleton() throws IOException {
        ImmutableExternalTriePrefixDictionary d = new ImmutableExternalTriePrefixDictionary((Iterable<? extends CharSequence>)ObjectSets.singleton((Object)"a"), 1024);
        ImmutableExternalTriePrefixDictionaryTest.assertTrue((boolean)d.contains("a"));
        ImmutableExternalTriePrefixDictionaryTest.assertFalse((boolean)d.contains("b"));
        ImmutableExternalTriePrefixDictionaryTest.assertFalse((boolean)d.contains("0"));
    }

    public void testPrefixOutOfRange() throws IOException {
        ImmutableExternalTriePrefixDictionary d = new ImmutableExternalTriePrefixDictionary((Iterable<? extends CharSequence>)new ObjectOpenHashSet((Object[])new String[]{"ab", "ac"}));
        ImmutableExternalTriePrefixDictionaryTest.assertEquals((Object)Intervals.EMPTY_INTERVAL, (Object)d.getInterval("b"));
        ImmutableExternalTriePrefixDictionaryTest.assertEquals((Object)Interval.valueOf(0, 1), (Object)d.getInterval("a"));
    }
}

