/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics;

import com.beust.jcommander.IStringConverterFactory;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import edu.unc.genomics.AssemblyFactory;
import edu.unc.genomics.CommandLineToolException;
import edu.unc.genomics.IntervalFileFactory;
import edu.unc.genomics.PathFactory;
import edu.unc.genomics.WigFileFactory;
import java.io.IOException;

public abstract class CommandLineTool {
    private final JCommander jc = new JCommander((Object)this);
    public static final int DEFAULT_CHUNK_SIZE = 500000;

    public CommandLineTool() {
        this.jc.addConverterFactory((IStringConverterFactory)new PathFactory());
        this.jc.addConverterFactory((IStringConverterFactory)new AssemblyFactory());
        this.jc.addConverterFactory((IStringConverterFactory)new IntervalFileFactory());
        this.jc.addConverterFactory((IStringConverterFactory)new WigFileFactory());
        this.jc.setProgramName(this.getClass().getSimpleName());
    }

    public abstract void run() throws IOException;

    public void instanceMain(String[] args) throws CommandLineToolException {
        try {
            this.toolRunnerMain(args);
        }
        catch (ParameterException e) {
            System.err.println(e.getMessage());
            this.jc.usage();
            System.exit(-1);
        }
    }

    public void toolRunnerMain(String[] args) throws ParameterException, CommandLineToolException {
        this.jc.parse(args);
        try {
            this.run();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CommandLineToolException("IO error while running tool");
        }
    }
}

