/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.ngs;

import com.beust.jcommander.Parameter;
import edu.ucsc.genome.TrackHeader;
import edu.unc.genomics.Assembly;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.Interval;
import edu.unc.genomics.io.IntervalFile;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class RollingReadLength
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(RollingReadLength.class);
    @Parameter(names={"-i", "--input"}, description="Input file (reads)", required=true)
    public IntervalFile<? extends Interval> intervalFile;
    @Parameter(names={"-a", "--assembly"}, description="Genome assembly", required=true)
    public Assembly assembly;
    @Parameter(names={"-o", "--output"}, description="Output file (Wig)", required=true)
    public Path outputFile;

    @Override
    public void run() throws IOException {
        log.debug((Object)"Initializing output file");
        int mapped = 0;
        try (BufferedWriter writer = Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]);){
            TrackHeader header = new TrackHeader("wiggle_0");
            header.setName("Converted " + this.intervalFile.getPath().getFileName());
            header.setDescription("Converted " + this.intervalFile.getPath().getFileName());
            writer.write(header.toString());
            writer.newLine();
            for (String chr : this.assembly) {
                log.debug((Object)("Processing chromosome " + chr));
                writer.write("fixedStep chrom=" + chr + " start=1 step=1 span=1");
                writer.newLine();
                int start = 1;
                while (start < this.assembly.getChrLength(chr)) {
                    int stop = start + 500000 - 1;
                    int length = stop - start + 1;
                    int[] sum = new int[length];
                    int[] count = new int[length];
                    Iterator it = this.intervalFile.query(chr, start, stop);
                    while (it.hasNext()) {
                        Interval entry = (Interval)it.next();
                        for (int i = entry.getStart(); i <= entry.getStop(); ++i) {
                            int n = i - start;
                            sum[n] = sum[n] + entry.length();
                            int n2 = i - start;
                            count[n2] = count[n2] + 1;
                        }
                        ++mapped;
                    }
                    for (int i = 0; i < sum.length; ++i) {
                        if (count[i] == 0) {
                            writer.write(String.valueOf(Float.NaN));
                        } else {
                            writer.write(String.valueOf(sum[i] / count[i]));
                        }
                        writer.newLine();
                    }
                    start = stop + 1;
                }
            }
        }
        log.info((Object)("Mapped " + mapped + " reads"));
    }

    public static void main(String[] args) {
        new RollingReadLength().instanceMain(args);
    }
}

