/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.ngs;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.Interval;
import edu.unc.genomics.ReadablePathValidator;
import edu.unc.genomics.io.IntervalFileReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class ReadLengthDistributionMatrix
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(ReadLengthDistributionMatrix.class);
    @Parameter(names={"-i", "--input"}, description="Input file (reads)", required=true, validateWith=ReadablePathValidator.class)
    public Path intervalFile;
    @Parameter(names={"-c", "--chr"}, description="Chromosome", required=true)
    public String chr;
    @Parameter(names={"-s", "--start"}, description="Start base pair", required=true)
    public int start;
    @Parameter(names={"-e", "--stop"}, description="Stop base pair", required=true)
    public int stop;
    @Parameter(names={"-m", "--min"}, description="Minimum fragment length bin (bp)")
    public int min = 1;
    @Parameter(names={"-l", "--max"}, description="Maximum fragment length bin (bp)")
    public int max = 200;
    @Parameter(names={"-b", "--bin"}, description="Bin size (bp)")
    public int binSize = 1;
    @Parameter(names={"-o", "--output"}, description="Matrix output file (tabular)", required=true)
    public Path outputFile;
    @Parameter(names={"-p", "--pileup"}, description="Pileup output file (tabular)")
    public Path pileupFile;

    @Override
    public void run() throws IOException {
        int regionLength = this.stop - this.start + 1;
        int lengthRange = this.max - this.min + 1;
        int histLength = lengthRange / this.binSize;
        if (histLength * this.binSize != lengthRange) {
            ++histLength;
        }
        log.debug((Object)"Binning reads by genomic location and length");
        int[][] counts = new int[histLength][regionLength];
        int[] pileup = new int[regionLength];
        int skipped = 0;
        try (IntervalFileReader reader = IntervalFileReader.autodetect((Path)this.intervalFile);){
            Iterator reads = reader.query(this.chr, this.start, this.stop);
            while (reads.hasNext()) {
                Interval read = (Interval)reads.next();
                if (read.length() < this.min || read.length() > this.max) {
                    ++skipped;
                    continue;
                }
                int bin = (read.length() - this.min) / this.binSize;
                int intersectStart = Math.max(read.getStart(), this.start);
                int intersectStop = Math.min(read.getStop(), this.stop);
                for (int i = intersectStart; i <= intersectStop; ++i) {
                    int[] nArray = counts[bin];
                    int n = i - this.start;
                    nArray[n] = nArray[n] + 1;
                    int n2 = i - this.start;
                    pileup[n2] = pileup[n2] + 1;
                }
            }
        }
        log.info((Object)("Skipped " + skipped + " reads with length outside range"));
        var8_8 = null;
        try (Writer writer = Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]);){
            writer.write(this.chr);
            for (int bp = this.start; bp <= this.stop; ++bp) {
                writer.write("\t" + bp);
            }
            for (int i = histLength - 1; i >= 0; --i) {
                ((BufferedWriter)writer).newLine();
                writer.write(String.valueOf(this.min + i * this.binSize));
                for (int j = 0; j < regionLength; ++j) {
                    writer.write("\t" + counts[i][j]);
                }
            }
        }
        catch (Throwable x2) {
            var8_8 = x2;
            throw x2;
        }
        if (this.pileupFile != null) {
            writer = new PrintWriter(Files.newBufferedWriter(this.pileupFile, Charset.defaultCharset(), new OpenOption[0]));
            var8_8 = null;
            try {
                ((PrintWriter)writer).println("Pos\tValue");
                for (int i = 0; i < regionLength; ++i) {
                    ((PrintWriter)writer).println(this.start + i + "\t" + pileup[i]);
                }
            }
            catch (Throwable throwable) {
                var8_8 = throwable;
                throw throwable;
            }
            finally {
                if (writer != null) {
                    if (var8_8 != null) {
                        try {
                            ((PrintWriter)writer).close();
                        }
                        catch (Throwable x2) {
                            var8_8.addSuppressed(x2);
                        }
                    } else {
                        ((PrintWriter)writer).close();
                    }
                }
            }
        }
    }

    public static void main(String[] args) {
        new ReadLengthDistributionMatrix().instanceMain(args);
    }
}

