/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.fft;

public class RealFFTUtils_3D {
    private static final int ONE = 1;
    private static final int TWO = 2;
    private static final int ZERO = 0;
    private final int columns;
    private final int rows;
    private final int rowStride;
    private final int slices;
    private final int sliceStride;

    public RealFFTUtils_3D(int n, int n2, int n3) {
        this.slices = n;
        this.rows = n2;
        this.columns = n3;
        this.rowStride = n3;
        this.sliceStride = n2 * this.rowStride;
    }

    public int getIndex(int n, int n2, int n3) {
        int n4;
        int n5 = n3 & 1;
        int n6 = n2 << 1;
        int n7 = n << 1;
        int n8 = n == 0 ? 0 : this.slices - n;
        int n9 = n4 = n2 == 0 ? 0 : this.rows - n2;
        if (n3 <= 1) {
            if (n2 == 0) {
                if (n == 0) {
                    return n3 == 0 ? 0 : Integer.MIN_VALUE;
                }
                if (n7 < this.slices) {
                    return n * this.sliceStride + n3;
                }
                if (n7 > this.slices) {
                    int n10 = n8 * this.sliceStride;
                    return n5 == 0 ? n10 : -(n10 + 1);
                }
                return n5 == 0 ? n * this.sliceStride : Integer.MIN_VALUE;
            }
            if (n6 < this.rows) {
                return n * this.sliceStride + n2 * this.rowStride + n3;
            }
            if (n6 > this.rows) {
                int n11 = n8 * this.sliceStride + n4 * this.rowStride;
                return n5 == 0 ? n11 : -(n11 + 1);
            }
            if (n == 0) {
                return n5 == 0 ? n2 * this.rowStride : Integer.MIN_VALUE;
            }
            if (n7 < this.slices) {
                return n * this.sliceStride + n2 * this.rowStride + n3;
            }
            if (n7 > this.slices) {
                int n12 = n8 * this.sliceStride + n2 * this.rowStride;
                return n5 == 0 ? n12 : -(n12 + 1);
            }
            int n13 = n * this.sliceStride + n2 * this.rowStride;
            return n5 == 0 ? n13 : Integer.MIN_VALUE;
        }
        if (n3 < this.columns) {
            return n * this.sliceStride + n2 * this.rowStride + n3;
        }
        if (n3 > this.columns + 1) {
            int n14 = (this.columns << 1) - n3;
            int n15 = n8 * this.sliceStride + n4 * this.rowStride + n14;
            return n5 == 0 ? n15 : -(n15 + 2);
        }
        if (n2 == 0) {
            if (n == 0) {
                return n5 == 0 ? 1 : Integer.MIN_VALUE;
            }
            if (n7 < this.slices) {
                int n16 = n8 * this.sliceStride;
                return n5 == 0 ? n16 + 1 : -n16;
            }
            if (n7 > this.slices) {
                int n17 = n * this.sliceStride;
                return n5 == 0 ? n17 + 1 : n17;
            }
            int n18 = n * this.sliceStride;
            return n5 == 0 ? n18 + 1 : Integer.MIN_VALUE;
        }
        if (n6 < this.rows) {
            int n19 = n8 * this.sliceStride + n4 * this.rowStride;
            return n5 == 0 ? n19 + 1 : -n19;
        }
        if (n6 > this.rows) {
            int n20 = n * this.sliceStride + n2 * this.rowStride;
            return n5 == 0 ? n20 + 1 : n20;
        }
        if (n == 0) {
            int n21 = n2 * this.rowStride + 1;
            return n5 == 0 ? n21 : Integer.MIN_VALUE;
        }
        if (n7 < this.slices) {
            int n22 = n8 * this.sliceStride + n2 * this.rowStride;
            return n5 == 0 ? n22 + 1 : -n22;
        }
        if (n7 > this.slices) {
            int n23 = n * this.sliceStride + n2 * this.rowStride;
            return n5 == 0 ? n23 + 1 : n23;
        }
        int n24 = n * this.sliceStride + n2 * this.rowStride;
        return n5 == 0 ? n24 + 1 : Integer.MIN_VALUE;
    }

    public void pack(double d, int n, int n2, int n3, double[] dArray, int n4) {
        int n5 = this.getIndex(n, n2, n3);
        if (n5 >= 0) {
            dArray[n4 + n5] = d;
        } else if (n5 > Integer.MIN_VALUE) {
            dArray[n4 - n5] = -d;
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d][%d] component cannot be modified (always zero)", n, n2, n3));
        }
    }

    public void pack(double d, int n, int n2, int n3, double[][][] dArray) {
        int n4 = this.getIndex(n, n2, n3);
        int n5 = Math.abs(n4);
        int n6 = n5 / this.sliceStride;
        int n7 = n5 % this.sliceStride;
        int n8 = n7 / this.rowStride;
        int n9 = n7 % this.rowStride;
        if (n4 >= 0) {
            dArray[n6][n8][n9] = d;
        } else if (n4 > Integer.MIN_VALUE) {
            dArray[n6][n8][n9] = -d;
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d] component cannot be modified (always zero)", n2, n3));
        }
    }

    public void pack(float f, int n, int n2, int n3, float[] fArray, int n4) {
        int n5 = this.getIndex(n, n2, n3);
        if (n5 >= 0) {
            fArray[n4 + n5] = f;
        } else if (n5 > Integer.MIN_VALUE) {
            fArray[n4 - n5] = -f;
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d][%d] component cannot be modified (always zero)", n, n2, n3));
        }
    }

    public void pack(float f, int n, int n2, int n3, float[][][] fArray) {
        int n4 = this.getIndex(n, n2, n3);
        int n5 = Math.abs(n4);
        int n6 = n5 / this.sliceStride;
        int n7 = n5 % this.sliceStride;
        int n8 = n7 / this.rowStride;
        int n9 = n7 % this.rowStride;
        if (n4 >= 0) {
            fArray[n6][n8][n9] = f;
        } else if (n4 > Integer.MIN_VALUE) {
            fArray[n6][n8][n9] = -f;
        } else {
            throw new IllegalArgumentException(String.format("[%d][%d][%d] component cannot be modified (always zero)", n, n2, n3));
        }
    }

    public double unpack(int n, int n2, int n3, double[] dArray, int n4) {
        int n5 = this.getIndex(n, n2, n3);
        if (n5 >= 0) {
            return dArray[n4 + n5];
        }
        if (n5 > Integer.MIN_VALUE) {
            return -dArray[n4 - n5];
        }
        return 0.0;
    }

    public double unpack(int n, int n2, int n3, double[][][] dArray) {
        int n4 = this.getIndex(n, n2, n3);
        int n5 = Math.abs(n4);
        int n6 = n5 / this.sliceStride;
        int n7 = n5 % this.sliceStride;
        int n8 = n7 / this.rowStride;
        int n9 = n7 % this.rowStride;
        if (n4 >= 0) {
            return dArray[n6][n8][n9];
        }
        if (n4 > Integer.MIN_VALUE) {
            return -dArray[n6][n8][n9];
        }
        return 0.0;
    }

    public float unpack(int n, int n2, int n3, float[] fArray, int n4) {
        int n5 = this.getIndex(n, n2, n3);
        if (n5 >= 0) {
            return fArray[n4 + n5];
        }
        if (n5 > Integer.MIN_VALUE) {
            return -fArray[n4 - n5];
        }
        return 0.0f;
    }

    public float unpack(int n, int n2, int n3, float[][][] fArray) {
        int n4 = this.getIndex(n, n2, n3);
        int n5 = Math.abs(n4);
        int n6 = n5 / this.sliceStride;
        int n7 = n5 % this.sliceStride;
        int n8 = n7 / this.rowStride;
        int n9 = n7 % this.rowStride;
        if (n4 >= 0) {
            return fArray[n6][n8][n9];
        }
        if (n4 > Integer.MIN_VALUE) {
            return -fArray[n6][n8][n9];
        }
        return 0.0f;
    }
}

