/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.ngs;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.Interval;
import edu.unc.genomics.ReadablePathValidator;
import edu.unc.genomics.io.IntervalFileReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import org.apache.commons.math3.stat.Frequency;
import org.apache.log4j.Logger;

public class FragmentLengthDistributionByGene
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(FragmentLengthDistributionByGene.class);
    @Parameter(names={"-i", "--input"}, description="Input file (reads)", required=true, validateWith=ReadablePathValidator.class)
    public Path inputFile;
    @Parameter(names={"-l", "--loci"}, description="Loci file (Bed)", required=true, validateWith=ReadablePathValidator.class)
    public Path lociFile;
    @Parameter(names={"-m", "min"}, description="Minimum read length to count")
    public int min = 1;
    @Parameter(names={"-h", "--max"}, description="Maximum read length to count")
    public int max = 1000;
    @Parameter(names={"-o", "--output"}, description="Output file", required=true)
    public Path outputFile;

    @Override
    public void run() throws IOException {
        Frequency hist = new Frequency();
        try (IntervalFileReader reader = IntervalFileReader.autodetect((Path)this.inputFile);
             IntervalFileReader loci = IntervalFileReader.autodetect((Path)this.lociFile);
             BufferedWriter writer = Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]);){
            writer.write("#Chr\tStart\tStop\tID\tAlignment\tStrand\tDistribution");
            writer.newLine();
            log.debug((Object)"Iterating over all intervals and computing read length distribution");
            for (Interval interval : loci) {
                writer.write(interval.toBed());
                hist.clear();
                Iterator reads = reader.query(interval);
                while (reads.hasNext()) {
                    Interval read = (Interval)reads.next();
                    hist.addValue(read.length());
                }
                for (int i = this.min; i <= this.max; ++i) {
                    writer.write("\t" + hist.getPct(i));
                }
                writer.newLine();
            }
        }
    }

    public static void main(String[] args) {
        new FragmentLengthDistributionByGene().instanceMain(args);
    }
}

