/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.wigmath;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.CommandLineToolException;
import edu.unc.genomics.Interval;
import edu.unc.genomics.ReadablePathValidator;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.io.WigFileReader;
import edu.unc.genomics.ngs.Autocorrelation;
import edu.unc.utils.FloatHistogram;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.log4j.Logger;

public class ValueDistribution
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(Autocorrelation.class);
    @Parameter(names={"-i", "--input"}, description="Input file", required=true, validateWith=ReadablePathValidator.class)
    public Path inputFile;
    @Parameter(names={"-l", "--min"}, description="Minimum bin value")
    public Float min;
    @Parameter(names={"-h", "--max"}, description="Maximum bin value")
    public Float max;
    @Parameter(names={"-n", "--bins"}, description="Number of bins")
    public int numBins = 40;
    @Parameter(names={"-o", "--output"}, description="Output file")
    public Path outputFile;
    FloatHistogram hist;
    double mean;
    double stdev;
    double skewness;
    double kurtosis;
    long N;

    @Override
    public void run() throws IOException {
        try (WigFileReader reader = WigFileReader.autodetect((Path)this.inputFile);){
            log.debug((Object)"Generating histogram of Wig values");
            if (this.min == null) {
                this.min = Float.valueOf((float)reader.min());
            }
            if (this.max == null) {
                this.max = Float.valueOf((float)reader.max());
            }
            this.hist = new FloatHistogram(this.numBins, this.min.floatValue(), this.max.floatValue());
            this.N = reader.numBases();
            this.mean = reader.mean();
            this.stdev = reader.stdev();
            double sumOfCubeOfDeviances = 0.0;
            double sumOfFourthOfDeviances = 0.0;
            for (String chr : reader.chromosomes()) {
                int start = reader.getChrStart(chr);
                int stop = reader.getChrStop(chr);
                log.debug((Object)("Processing chromosome " + chr + " region " + start + "-" + stop));
                int bp = start;
                while (bp < stop) {
                    int chunkStart = bp;
                    int chunkStop = Math.min(bp + 10000000 - 1, stop);
                    Interval chunk = new Interval(chr, chunkStart, chunkStop);
                    log.debug((Object)("Processing chunk " + chunk));
                    try {
                        float[] data = reader.query(chunk).getValues();
                        for (int i = 0; i < data.length; ++i) {
                            if (Float.isNaN(data[i]) || Float.isInfinite(data[i])) continue;
                            this.hist.addValue(data[i]);
                            double deviance = (double)data[i] - this.mean;
                            double cubeOfDeviance = Math.pow(deviance, 3.0);
                            sumOfCubeOfDeviances += cubeOfDeviance;
                            sumOfFourthOfDeviances += deviance * cubeOfDeviance;
                        }
                    }
                    catch (WigFileException e) {
                        log.error((Object)("Error getting data from Wig file for chunk " + chunk));
                        throw new CommandLineToolException("Error getting data from Wig file for chunk " + chunk);
                    }
                    bp = chunkStop + 1;
                }
            }
            this.skewness = sumOfCubeOfDeviances / (double)this.N / Math.pow(this.stdev, 3.0);
            this.kurtosis = sumOfFourthOfDeviances / (double)this.N / Math.pow(this.stdev, 4.0);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Moments:\tmean(w) = " + this.mean + "\n");
        sb.append("\t\tvar(w) = " + this.stdev * this.stdev + "\n");
        sb.append("\t\tskew(w) = " + this.skewness + "\n");
        sb.append("\t\tkur(w) = " + this.kurtosis + "\n");
        sb.append("Histogram:\n");
        sb.append(this.hist);
        if (this.outputFile != null) {
            log.debug((Object)"Writing to output file");
            try (BufferedWriter writer = Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]);){
                writer.write(sb.toString());
            }
        } else {
            System.out.println(sb.toString());
        }
    }

    public static void main(String[] args) throws IOException, WigFileException {
        new ValueDistribution().instanceMain(args);
    }
}

