/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.sf.samtools.BAMFileWriter;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMTextWriter;
import net.sf.samtools.util.BlockCompressedOutputStream;
import net.sf.samtools.util.IOUtil;
import net.sf.samtools.util.Md5CalculatingOutputStream;
import net.sf.samtools.util.RuntimeIOException;

public class SAMFileWriterFactory {
    private static boolean DefaultCreateIndexWhileWriting = false;
    private boolean createIndex = DefaultCreateIndexWhileWriting;
    private static boolean defaultCreateMd5File = false;
    private boolean createMd5File = defaultCreateMd5File;
    private Integer maxRecordsInRam;

    public static void setDefaultCreateMd5File(boolean createMd5File) {
        defaultCreateMd5File = createMd5File;
    }

    public SAMFileWriterFactory setCreateMd5File(boolean createMd5File) {
        this.createMd5File = createMd5File;
        return this;
    }

    public static void setDefaultCreateIndexWhileWriting(boolean setting) {
        DefaultCreateIndexWhileWriting = setting;
    }

    public SAMFileWriterFactory setCreateIndex(boolean setting) {
        this.createIndex = setting;
        return this;
    }

    public SAMFileWriterFactory setMaxRecordsInRam(int maxRecordsInRam) {
        this.maxRecordsInRam = maxRecordsInRam;
        return this;
    }

    public SAMFileWriter makeBAMWriter(SAMFileHeader header, boolean presorted, File outputFile) {
        return this.makeBAMWriter(header, presorted, outputFile, BlockCompressedOutputStream.getDefaultCompressionLevel());
    }

    public SAMFileWriter makeBAMWriter(SAMFileHeader header, boolean presorted, File outputFile, int compressionLevel) {
        try {
            boolean createIndex;
            boolean createMd5File;
            boolean bl = createMd5File = this.createMd5File && IOUtil.isRegularPath(outputFile);
            if (this.createMd5File && !createMd5File) {
                System.err.println("Cannot create MD5 file for BAM because output file is not a regular file: " + outputFile.getAbsolutePath());
            }
            BAMFileWriter ret = createMd5File ? new BAMFileWriter(new Md5CalculatingOutputStream(new FileOutputStream(outputFile, false), new File(outputFile.getAbsolutePath() + ".md5")), outputFile, compressionLevel) : new BAMFileWriter(outputFile, compressionLevel);
            boolean bl2 = createIndex = this.createIndex && IOUtil.isRegularPath(outputFile);
            if (this.createIndex && !createIndex) {
                System.err.println("Cannot create index for BAM because output file is not a regular file: " + outputFile.getAbsolutePath());
            }
            this.initializeBAMWriter(ret, header, presorted, createIndex);
            return ret;
        }
        catch (IOException ioe) {
            throw new RuntimeIOException("Error opening file: " + outputFile.getAbsolutePath());
        }
    }

    private void initializeBAMWriter(BAMFileWriter writer, SAMFileHeader header, boolean presorted, boolean createIndex) {
        writer.setSortOrder(header.getSortOrder(), presorted);
        writer.setHeader(header);
        if (createIndex && writer.getSortOrder().equals((Object)SAMFileHeader.SortOrder.coordinate)) {
            writer.enableBamIndexConstruction();
        }
        if (this.maxRecordsInRam != null) {
            writer.setMaxRecordsInRam(this.maxRecordsInRam);
        }
    }

    public SAMFileWriter makeSAMWriter(SAMFileHeader header, boolean presorted, File outputFile) {
        try {
            SAMTextWriter ret = this.createMd5File ? new SAMTextWriter(new Md5CalculatingOutputStream(new FileOutputStream(outputFile, false), new File(outputFile.getAbsolutePath() + ".md5"))) : new SAMTextWriter(outputFile);
            ret.setSortOrder(header.getSortOrder(), presorted);
            if (this.maxRecordsInRam != null) {
                ret.setMaxRecordsInRam(this.maxRecordsInRam);
            }
            ret.setHeader(header);
            return ret;
        }
        catch (IOException ioe) {
            throw new RuntimeIOException("Error opening file: " + outputFile.getAbsolutePath());
        }
    }

    public SAMFileWriter makeSAMWriter(SAMFileHeader header, boolean presorted, OutputStream stream) {
        SAMTextWriter ret = new SAMTextWriter(stream);
        ret.setSortOrder(header.getSortOrder(), presorted);
        if (this.maxRecordsInRam != null) {
            ret.setMaxRecordsInRam(this.maxRecordsInRam);
        }
        ret.setHeader(header);
        return ret;
    }

    public SAMFileWriter makeSAMOrBAMWriter(SAMFileHeader header, boolean presorted, File outputFile) {
        String filename = outputFile.getName();
        if (filename.endsWith(".bam")) {
            return this.makeBAMWriter(header, presorted, outputFile);
        }
        if (filename.endsWith(".sam")) {
            return this.makeSAMWriter(header, presorted, outputFile);
        }
        return this.makeBAMWriter(header, presorted, outputFile);
    }
}

