/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.io;

import edu.unc.genomics.Interval;
import edu.unc.genomics.io.BAMFile;
import edu.unc.genomics.io.BedFile;
import edu.unc.genomics.io.BedGraphFile;
import edu.unc.genomics.io.BigBedFile;
import edu.unc.genomics.io.GFFFile;
import edu.unc.genomics.io.GeneTrackFile;
import edu.unc.genomics.io.IntervalFileSniffer;
import edu.unc.genomics.io.IntervalFileSnifferException;
import edu.unc.genomics.io.SAMFile;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class IntervalFile<T extends Interval>
implements Iterable<T>,
Closeable {
    private static final Logger log = Logger.getLogger(IntervalFile.class);
    protected Path p;

    protected IntervalFile(Path p) {
        this.p = p;
    }

    public static IntervalFile<? extends Interval> autodetect(Path p) throws IntervalFileSnifferException, IOException {
        IntervalFileSniffer sniffer = new IntervalFileSniffer(p);
        if (sniffer.isBigBed()) {
            log.debug((Object)("Autodetected BigBed filetype for: " + p.getFileName().toString()));
            return new BigBedFile(p);
        }
        if (sniffer.isBAM()) {
            log.debug((Object)("Autodetected BAM filetype for: " + p.getFileName().toString()));
            return new BAMFile(p);
        }
        if (sniffer.isGFF()) {
            log.debug((Object)("Autodetected GFF filetype for: " + p.getFileName().toString()));
            return new GFFFile(p);
        }
        if (sniffer.isBedGraph()) {
            log.debug((Object)("Autodetected BedGraph filetype for: " + p.getFileName().toString()));
            return new BedGraphFile(p);
        }
        if (sniffer.isBed()) {
            log.debug((Object)("Autodetected Bed filetype for: " + p.getFileName().toString()));
            return new BedFile(p);
        }
        if (sniffer.isSAM()) {
            log.debug((Object)("Autodetected SAM filetype for: " + p.getFileName().toString()));
            return new SAMFile(p);
        }
        if (sniffer.isGeneTrack()) {
            log.debug((Object)("Autodetected GeneTrack filetype for: " + p.getFileName().toString()));
            return new GeneTrackFile(p);
        }
        throw new IntervalFileSnifferException("Could not autodetect Interval file format");
    }

    public static List<Interval> loadAll(Path p) throws IntervalFileSnifferException, IOException {
        ArrayList<Interval> intervals = new ArrayList<Interval>();
        try (IntervalFile<Interval> intervalFile = IntervalFile.autodetect(p);){
            for (Interval interval : intervalFile) {
                intervals.add(interval);
            }
        }
        return intervals;
    }

    public List<T> loadAll() {
        ArrayList<Interval> intervals = new ArrayList<Interval>();
        for (Interval interval : this) {
            intervals.add(interval);
        }
        return intervals;
    }

    public abstract int count();

    public abstract Set<String> chromosomes();

    public Iterator<T> query(Interval i) throws UnsupportedOperationException {
        return this.query(i.getChr(), i.low(), i.high());
    }

    public abstract Iterator<T> query(String var1, int var2, int var3) throws UnsupportedOperationException;

    public Path getPath() {
        return this.p;
    }
}

