/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.index.remote;

import it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import it.unimi.dsi.mg4j.util.Fast;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import org.apache.log4j.Logger;

public class RemoteIndexServerConnection
implements Closeable {
    private static final Logger LOGGER = Fast.getLogger(RemoteIndexServerConnection.class);
    public final Socket socket = new Socket();
    public final DataInputStream inputStream;
    public final DataOutputStream outputStream;

    public RemoteIndexServerConnection(SocketAddress address, byte command) throws IOException {
        this.socket.connect(address);
        this.inputStream = new DataInputStream((InputStream)new FastBufferedInputStream(this.socket.getInputStream()));
        this.outputStream = new DataOutputStream((OutputStream)new FastBufferedOutputStream(this.socket.getOutputStream()));
        this.outputStream.writeByte(command);
        this.outputStream.flush();
    }

    public synchronized void close() throws IOException {
        this.socket.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (!this.socket.isClosed()) {
                LOGGER.warn((Object)("This " + this.getClass().getName() + " [" + this.toString() + "] should have been closed."));
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    public String toString() {
        return this.getClass().getName() + ":" + this.socket.toString();
    }
}

