/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.query;

import cern.colt.Sorting;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2ReferenceMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2DoubleMap;
import it.unimi.dsi.fastutil.objects.Reference2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.query.IntervalSelector;
import it.unimi.dsi.mg4j.query.SelectedInterval;
import it.unimi.dsi.mg4j.query.nodes.Query;
import it.unimi.dsi.mg4j.query.nodes.QueryBuilderVisitor;
import it.unimi.dsi.mg4j.query.nodes.QueryBuilderVisitorException;
import it.unimi.dsi.mg4j.query.nodes.QueryTransformer;
import it.unimi.dsi.mg4j.query.parser.QueryParser;
import it.unimi.dsi.mg4j.query.parser.QueryParserException;
import it.unimi.dsi.mg4j.search.DocumentIterator;
import it.unimi.dsi.mg4j.search.score.AbstractAggregator;
import it.unimi.dsi.mg4j.search.score.DocumentScoreInfo;
import it.unimi.dsi.mg4j.search.score.LinearAggregator;
import it.unimi.dsi.mg4j.search.score.ScoredDocumentBoundedSizeQueue;
import it.unimi.dsi.mg4j.search.score.Scorer;
import it.unimi.dsi.mg4j.util.Fast;
import it.unimi.dsi.mg4j.util.FlyweightPrototype;
import it.unimi.dsi.mg4j.util.FlyweightPrototypes;
import java.io.IOException;
import java.util.Arrays;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryEngine
implements FlyweightPrototype<QueryEngine> {
    private static final Logger LOGGER = Fast.getLogger(QueryEngine.class);
    private static final boolean ASSERTS = false;
    public final QueryParser queryParser;
    public final Object2ReferenceMap<String, Index> indexMap;
    public final int numIndices;
    public volatile boolean multiplex;
    public volatile IntervalSelector intervalSelector;
    private Scorer scorer;
    private final QueryBuilderVisitor<DocumentIterator> builderVisitor;
    protected final Reference2DoubleOpenHashMap<Index> index2Weight;
    private QueryTransformer transformer;

    public QueryEngine(QueryParser queryParser, QueryBuilderVisitor<DocumentIterator> builderVisitor, Object2ReferenceMap<String, Index> indexMap) {
        this.queryParser = queryParser;
        this.builderVisitor = builderVisitor;
        this.indexMap = indexMap;
        this.numIndices = indexMap.size();
        this.index2Weight = new Reference2DoubleOpenHashMap();
        this.index2Weight.defaultReturnValue(1.0 / (double)this.numIndices);
    }

    @Override
    public synchronized QueryEngine copy() {
        QueryEngine newEngine = new QueryEngine(FlyweightPrototypes.copy(this.queryParser), this.builderVisitor.copy(), this.indexMap);
        newEngine.multiplex = this.multiplex;
        newEngine.intervalSelector = FlyweightPrototypes.copy(this.intervalSelector);
        newEngine.scorer = FlyweightPrototypes.copy(this.scorer);
        newEngine.setWeights((Reference2DoubleMap<Index>)this.index2Weight);
        return newEngine;
    }

    public synchronized void equalize(int samples) {
        if (this.scorer == null) {
            throw new IllegalStateException("There is no scorer");
        }
        if (!(this.scorer instanceof AbstractAggregator)) {
            throw new IllegalStateException("The current scorer is not aggregated");
        }
        ((AbstractAggregator)this.scorer).equalize(samples);
    }

    public synchronized void score(Scorer[] scorer, double[] weight) {
        if (scorer.length == 0) {
            this.scorer = null;
        } else {
            this.scorer = scorer.length == 1 ? scorer[0] : new LinearAggregator(scorer, weight);
            this.scorer.setWeights((Reference2DoubleMap<Index>)this.index2Weight);
        }
    }

    public synchronized void transformer(QueryTransformer transformer) {
        this.transformer = transformer;
    }

    public synchronized void setWeights(Reference2DoubleMap<Index> index2Weight) {
        this.index2Weight.clear();
        this.index2Weight.defaultReturnValue(0.0);
        this.index2Weight.putAll(index2Weight);
        if (this.scorer != null) {
            this.scorer.setWeights(index2Weight);
        }
    }

    private String multiplex(String query) {
        if (!this.multiplex) {
            return query;
        }
        ObjectIterator it = this.indexMap.keySet().iterator();
        StringBuilder builder = new StringBuilder();
        while (it.hasNext()) {
            builder.append((String)it.next() + ":(" + query + ")");
            if (!it.hasNext()) continue;
            builder.append(" | ");
        }
        LOGGER.debug((Object)("Multiplex is active: submitting " + builder));
        return builder.toString();
    }

    public int process(String queries, int offset, int length, ObjectArrayList<DocumentScoreInfo<Reference2ObjectMap<Index, SelectedInterval[]>>> results) throws QueryParserException, QueryBuilderVisitorException, IOException {
        LOGGER.debug((Object)("Processing query \"" + queries + "\", offset=" + offset + ", length=" + length));
        String[] part = queries.split(",");
        Query[] partQuery = new Query[part.length];
        for (int i = 0; i < part.length; ++i) {
            String q = this.multiplex(part[i]);
            partQuery[i] = this.queryParser.parse(q);
            if (this.transformer == null) continue;
            partQuery[i] = this.transformer.transform(partQuery[i]);
        }
        return this.process(partQuery, offset, length, results);
    }

    public int process(Query[] query, int offset, int length, ObjectArrayList<DocumentScoreInfo<Reference2ObjectMap<Index, SelectedInterval[]>>> results) throws QueryBuilderVisitorException, IOException {
        LOGGER.debug((Object)("Processing Query array \"" + Arrays.toString(query) + "\", offset=" + offset + ", length=" + length));
        results.clear();
        double lastMinScore = 1.0;
        int total = 0;
        int currOffset = offset;
        int currLength = length;
        IntOpenHashSet alreadySeen = query.length > 1 ? new IntOpenHashSet() : null;
        for (int i = 0; i < query.length; ++i) {
            int initialResultSize = results.size();
            DocumentIterator documentIterator = query[i].accept(this.builderVisitor.prepare());
            int count = this.scorer != null ? this.getScoredResults(documentIterator, currOffset, currLength, lastMinScore, results, (IntSet)alreadySeen) : this.getResults(documentIterator, currOffset, currLength, results, (IntSet)alreadySeen);
            documentIterator.dispose();
            if (results.size() > 0) {
                lastMinScore = ((DocumentScoreInfo)results.get((int)(results.size() - 1))).score;
            }
            total += count;
            if ((currOffset -= count) < 0) {
                currLength += currOffset;
                currOffset = 0;
            }
            boolean someHavePositions = false;
            for (Index index : documentIterator.indices()) {
                someHavePositions |= index.hasPositions;
            }
            if (someHavePositions && this.intervalSelector != null && results.size() != initialResultSize) {
                Object[] sorted = (DocumentScoreInfo[])results.subList(initialResultSize, results.size()).toArray((Object[])new DocumentScoreInfo[results.size() - initialResultSize]);
                Sorting.quickSort((Object[])sorted, DocumentScoreInfo.DOCUMENT_COMPARATOR);
                documentIterator = query[i].accept(this.builderVisitor.prepare());
                for (Object dsi : sorted) {
                    documentIterator.skipTo(((DocumentScoreInfo)dsi).document);
                    ((DocumentScoreInfo)dsi).info = this.intervalSelector.select(documentIterator, (Reference2ObjectMap<Index, SelectedInterval[]>)new Reference2ObjectArrayMap(this.numIndices));
                }
                documentIterator.dispose();
            }
            if (length == results.size()) break;
        }
        return total;
    }

    private int getScoredResults(DocumentIterator documentIterator, int offset, int length, double lastMinScore, ObjectArrayList<DocumentScoreInfo<Reference2ObjectMap<Index, SelectedInterval[]>>> results, IntSet alreadySeen) throws IOException {
        int document;
        ScoredDocumentBoundedSizeQueue top = new ScoredDocumentBoundedSizeQueue(offset + length);
        int count = 0;
        this.scorer.wrap(documentIterator);
        while ((document = this.scorer.nextDocument()) != -1) {
            if (alreadySeen != null && !alreadySeen.add(document)) continue;
            ++count;
            top.enqueue(document, this.scorer.score());
        }
        int n = Math.max(top.size() - offset, 0);
        if (n > 0) {
            int s = results.size();
            results.size(s + n);
            Object[] elements = results.elements();
            int i = n;
            while (i-- != 0) {
                elements[i + s] = top.dequeue();
            }
            double adjustment = lastMinScore / (s != 0 ? ((DocumentScoreInfo)elements[s]).score : 1.0);
            int i2 = n;
            while (i2-- != 0) {
                ((DocumentScoreInfo)elements[i2 + s]).score *= adjustment;
            }
        }
        return count;
    }

    private int getResults(DocumentIterator documentIterator, int offset, int length, ObjectArrayList<DocumentScoreInfo<Reference2ObjectMap<Index, SelectedInterval[]>>> results, IntSet alreadySeen) throws IOException {
        int document;
        int count = 0;
        while ((document = documentIterator.nextDocument()) != -1) {
            if (alreadySeen != null && !alreadySeen.add(document)) continue;
            if (count >= offset && count < offset + length) {
                results.add(new DocumentScoreInfo(document, -1.0));
            }
            ++count;
        }
        return count;
    }

    public String toString() {
        return this.getClass().getName() + this.indexMap;
    }
}

