/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.search.visitor;

import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.mg4j.index.IndexIterator;
import it.unimi.dsi.mg4j.search.visitor.AbstractDocumentIteratorVisitor;
import it.unimi.dsi.mg4j.search.visitor.TermCollectionVisitor;
import java.io.IOException;
import java.util.Arrays;

public class CounterSetupVisitor
extends AbstractDocumentIteratorVisitor {
    public int[] indexNumber;
    public CharSequence[] term;
    public int[] count;
    public int[] frequency;
    private final TermCollectionVisitor termCollectionVisitor;

    public CounterSetupVisitor(TermCollectionVisitor termCollectionVisitor) {
        this.termCollectionVisitor = termCollectionVisitor;
        this.prepare();
    }

    public CounterSetupVisitor prepare() {
        this.count = new int[this.termCollectionVisitor.numberOfPairs()];
        this.frequency = new int[this.termCollectionVisitor.numberOfPairs()];
        this.indexNumber = new int[this.termCollectionVisitor.numberOfPairs()];
        this.term = new CharSequence[this.termCollectionVisitor.numberOfPairs()];
        return this;
    }

    public boolean visit(IndexIterator indexIterator) throws IOException {
        if (indexIterator.frequency() > 0 && indexIterator.index().hasCounts) {
            int id = indexIterator.id();
            this.frequency[id] = indexIterator.frequency();
            this.indexNumber[id] = this.termCollectionVisitor.indexMap().getInt((Object)indexIterator.index());
            this.term[id] = indexIterator.term();
        }
        return true;
    }

    public void update(IndexIterator indexIterator) throws IOException {
        this.count[indexIterator.id()] = indexIterator.count();
    }

    public void clear() {
        IntArrays.fill((int[])this.count, (int)0);
    }

    public String toString() {
        return "[" + Arrays.toString(this.frequency) + ", " + Arrays.toString(this.count) + "]";
    }
}

