/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.util;

import cern.colt.bitvector.BitVector;
import it.unimi.dsi.fastutil.booleans.BooleanIterator;
import it.unimi.dsi.fastutil.chars.Char2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.mg4j.compression.CodedCharSequenceBooleanIterator;
import it.unimi.dsi.mg4j.compression.PrefixCoder;
import it.unimi.dsi.mg4j.index.PrefixMap;
import it.unimi.dsi.mg4j.index.TermMap;
import it.unimi.dsi.mg4j.search.Interval;
import it.unimi.dsi.mg4j.util.ImmutableBinaryTrie;
import it.unimi.dsi.mg4j.util.ImmutableExternalPrefixDictionary;
import it.unimi.dsi.mg4j.util.MutableString;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImmutableTriePrefixTree
extends ImmutableBinaryTrie
implements TermMap,
PrefixMap,
ImmutableExternalPrefixDictionary.IntervalApproximator {
    public static final long serialVersionUID = -7046029254386353130L;
    private final PrefixCoder prefixCoder;
    private final Char2IntMap char2symbol;

    public ImmutableTriePrefixTree(List<? extends CharSequence> words, PrefixCoder prefixCoder, Char2IntMap char2symbol) {
        super((List<BitVector>)ImmutableTriePrefixTree.codeWords(words, prefixCoder, char2symbol));
        this.prefixCoder = prefixCoder;
        this.char2symbol = char2symbol;
    }

    private static ObjectArrayList<BitVector> codeWords(List<? extends CharSequence> words, PrefixCoder prefixCoder, Char2IntMap char2symbol) {
        ObjectArrayList bitWords = new ObjectArrayList();
        Iterator<? extends CharSequence> i = words.iterator();
        while (i.hasNext()) {
            BitVector v = new BitVector(0);
            CodedCharSequenceBooleanIterator booleanIterator = new CodedCharSequenceBooleanIterator(((Object)i.next()).toString(), prefixCoder, char2symbol);
            int size = 0;
            while (booleanIterator.hasNext()) {
                v.setSize(++size);
                if (!booleanIterator.nextBoolean()) continue;
                v.set(size - 1);
            }
            bitWords.add((Object)v);
        }
        return bitWords;
    }

    @Override
    public Interval getApproximatedInterval(CharSequence word) {
        return this.getApproximatedInterval((BooleanIterator)new CodedCharSequenceBooleanIterator(word, this.prefixCoder, this.char2symbol));
    }

    @Deprecated
    public int getIndex(CharSequence s) {
        return this.getNumber(s);
    }

    @Override
    public int getNumber(CharSequence term) {
        return this.get((BooleanIterator)new CodedCharSequenceBooleanIterator(term, this.prefixCoder, this.char2symbol));
    }

    @Override
    public CharSequence getTerm(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MutableString getTerm(int index, MutableString term) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Interval getInterval(CharSequence prefix) {
        return this.getInterval((BooleanIterator)new CodedCharSequenceBooleanIterator(prefix, this.prefixCoder, this.char2symbol));
    }

    @Override
    public CharSequence getPrefix(Interval interval) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MutableString getPrefix(Interval interval, MutableString prefix) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasTerms() {
        return false;
    }

    @Override
    public boolean hasPrefixes() {
        return false;
    }
}

