/*
 * Decompiled with CFR 0.152.
 */
package test.it.unimi.dsi.mg4j.search;

import it.unimi.dsi.mg4j.index.BitStreamIndex;
import it.unimi.dsi.mg4j.index.DiskBasedIndex;
import it.unimi.dsi.mg4j.query.nodes.Query;
import it.unimi.dsi.mg4j.query.nodes.QueryBuilderVisitorException;
import it.unimi.dsi.mg4j.query.parser.QueryParserException;
import it.unimi.dsi.mg4j.query.parser.SimpleParser;
import it.unimi.dsi.mg4j.search.DocumentIterator;
import it.unimi.dsi.mg4j.search.DocumentIteratorBuilderVisitor;
import it.unimi.dsi.mg4j.search.Interval;
import it.unimi.dsi.mg4j.search.IntervalIterators;
import it.unimi.dsi.mg4j.search.OrDocumentIterator;
import it.unimi.dsi.mg4j.tool.IndexBuilder;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import junit.framework.TestCase;
import org.apache.commons.configuration.ConfigurationException;
import test.it.unimi.dsi.mg4j.document.StringArrayDocumentCollection;
import test.it.unimi.dsi.mg4j.search.IntArrayDocumentIterator;

public class OrDocumentIteratorTest
extends TestCase {
    private BitStreamIndex index;
    private SimpleParser simpleParser;

    public void setUp() throws ConfigurationException, SecurityException, IOException, URISyntaxException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        String basename = File.createTempFile(((Object)((Object)this)).getClass().getSimpleName(), "test").getCanonicalPath();
        new IndexBuilder(basename, new StringArrayDocumentCollection("a", "b", "c")).run();
        this.index = DiskBasedIndex.getInstance(basename + "-text", true, true);
        this.simpleParser = new SimpleParser(this.index.termProcessor);
    }

    public void testSkipBug() throws QueryParserException, QueryBuilderVisitorException, IOException {
        Query query = this.simpleParser.parse("a | b | c");
        DocumentIteratorBuilderVisitor documentIteratorBuilderVisitor = new DocumentIteratorBuilderVisitor(null, this.index, Integer.MAX_VALUE);
        DocumentIterator documentIterator = query.accept(documentIteratorBuilderVisitor);
        OrDocumentIteratorTest.assertEquals((int)2, (int)documentIterator.skipTo(2));
        documentIterator.dispose();
    }

    public void testOr() throws IOException {
        IntArrayDocumentIterator i0 = new IntArrayDocumentIterator(new int[]{0, 2, 3, 4, 5, 6, 7}, new int[][][]{new int[][]{{0, 1}}, new int[][]{{0, 1}, {1, 2}}, new int[][]{{0, 1}, {1, 2}}, new int[][]{new int[0]}, new int[][]{new int[0]}, new int[0][], new int[0][]});
        IntArrayDocumentIterator i1 = new IntArrayDocumentIterator(new int[]{1, 2, 3, 4, 5, 6, 7}, new int[][][]{new int[][]{{1}}, new int[][]{{1, 3}, {3, 4}}, new int[][]{new int[0]}, new int[][]{new int[0]}, new int[0][], new int[][]{new int[0]}, new int[0][]});
        OrDocumentIterator orDocumentIterator = (OrDocumentIterator)OrDocumentIterator.getInstance(i0, i1);
        OrDocumentIteratorTest.assertTrue((boolean)orDocumentIterator.hasNext());
        OrDocumentIteratorTest.assertTrue((boolean)orDocumentIterator.hasNext());
        OrDocumentIteratorTest.assertEquals((int)0, (int)orDocumentIterator.nextDocument());
        OrDocumentIteratorTest.assertTrue((boolean)orDocumentIterator.intervalIterator().hasNext());
        OrDocumentIteratorTest.assertTrue((boolean)orDocumentIterator.intervalIterator().hasNext());
        OrDocumentIteratorTest.assertEquals((Object)Interval.valueOf(0, 1), (Object)orDocumentIterator.intervalIterator().nextInterval());
        OrDocumentIteratorTest.assertFalse((boolean)orDocumentIterator.intervalIterator().hasNext());
        OrDocumentIteratorTest.assertFalse((boolean)orDocumentIterator.intervalIterator().hasNext());
        OrDocumentIteratorTest.assertEquals((int)1, (int)orDocumentIterator.nextDocument());
        OrDocumentIteratorTest.assertEquals((Object)Interval.valueOf(1, 1), (Object)orDocumentIterator.intervalIterator().nextInterval());
        OrDocumentIteratorTest.assertFalse((boolean)orDocumentIterator.intervalIterator().hasNext());
        OrDocumentIteratorTest.assertEquals((int)2, (int)orDocumentIterator.nextDocument());
        OrDocumentIteratorTest.assertEquals((Object)Interval.valueOf(0, 1), (Object)orDocumentIterator.intervalIterator().nextInterval());
        OrDocumentIteratorTest.assertEquals((Object)Interval.valueOf(1, 2), (Object)orDocumentIterator.intervalIterator().nextInterval());
        OrDocumentIteratorTest.assertEquals((Object)Interval.valueOf(3, 4), (Object)orDocumentIterator.intervalIterator().nextInterval());
        OrDocumentIteratorTest.assertFalse((boolean)orDocumentIterator.intervalIterator().hasNext());
        OrDocumentIteratorTest.assertEquals((int)3, (int)orDocumentIterator.nextDocument());
        OrDocumentIteratorTest.assertEquals((Object)Interval.valueOf(0, 1), (Object)orDocumentIterator.intervalIterator().nextInterval());
        OrDocumentIteratorTest.assertEquals((Object)Interval.valueOf(1, 2), (Object)orDocumentIterator.intervalIterator().nextInterval());
        OrDocumentIteratorTest.assertFalse((boolean)orDocumentIterator.intervalIterator().hasNext());
        OrDocumentIteratorTest.assertEquals((int)4, (int)orDocumentIterator.nextDocument());
        OrDocumentIteratorTest.assertEquals((Object)IntervalIterators.TRUE, (Object)orDocumentIterator.intervalIterator());
        OrDocumentIteratorTest.assertEquals((int)5, (int)orDocumentIterator.nextDocument());
        OrDocumentIteratorTest.assertEquals((Object)IntervalIterators.TRUE, (Object)orDocumentIterator.intervalIterator());
        OrDocumentIteratorTest.assertEquals((int)6, (int)orDocumentIterator.nextDocument());
        OrDocumentIteratorTest.assertEquals((Object)IntervalIterators.TRUE, (Object)orDocumentIterator.intervalIterator());
        OrDocumentIteratorTest.assertEquals((int)7, (int)orDocumentIterator.nextDocument());
        OrDocumentIteratorTest.assertEquals((Object)IntervalIterators.FALSE, (Object)orDocumentIterator.intervalIterator());
    }
}

