/*
 * Decompiled with CFR 0.152.
 */
package test.it.unimi.dsi.mg4j.search.score;

import it.unimi.dsi.fastutil.objects.Object2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.Reference2DoubleMap;
import it.unimi.dsi.fastutil.objects.Reference2DoubleOpenHashMap;
import it.unimi.dsi.mg4j.index.BitStreamIndex;
import it.unimi.dsi.mg4j.index.DiskBasedIndex;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.index.TermProcessor;
import it.unimi.dsi.mg4j.query.nodes.Query;
import it.unimi.dsi.mg4j.query.nodes.QueryBuilderVisitorException;
import it.unimi.dsi.mg4j.query.parser.QueryParserException;
import it.unimi.dsi.mg4j.query.parser.SimpleParser;
import it.unimi.dsi.mg4j.search.DocumentIterator;
import it.unimi.dsi.mg4j.search.DocumentIteratorBuilderVisitor;
import it.unimi.dsi.mg4j.search.score.BM25Scorer;
import it.unimi.dsi.mg4j.search.score.CountScorer;
import it.unimi.dsi.mg4j.search.score.Scorer;
import it.unimi.dsi.mg4j.search.visitor.CounterCollectionVisitor;
import it.unimi.dsi.mg4j.search.visitor.CounterSetupVisitor;
import it.unimi.dsi.mg4j.search.visitor.TermCollectionVisitor;
import it.unimi.dsi.mg4j.tool.IndexBuilder;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.commons.configuration.ConfigurationException;
import test.it.unimi.dsi.mg4j.document.StringArrayDocumentCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScorerTest
extends TestCase {
    private StringArrayDocumentCollection documentCollection0;
    private StringArrayDocumentCollection documentCollection1;
    private static final double ASSERT_DIFF = 0.001;
    private String basename0;
    private String basename1;
    private String basename1bis;
    private BitStreamIndex index0;
    private BitStreamIndex index1;
    private BitStreamIndex index1bis;
    private SimpleParser simpleParser;

    public void setUp() throws ConfigurationException, SecurityException, IOException, URISyntaxException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        this.basename0 = File.createTempFile(ScorerTest.class.getSimpleName(), "test0").toString();
        this.basename1 = File.createTempFile(ScorerTest.class.getSimpleName(), "test1").toString();
        this.basename1bis = File.createTempFile(ScorerTest.class.getSimpleName(), "test1bis").toString();
        this.documentCollection0 = new StringArrayDocumentCollection("This sentence speaks really really really good of gods", "And this, is a list of all the green things in the green world", "get THIS not THAT");
        this.documentCollection1 = new StringArrayDocumentCollection("A C C", "D Z", "A X Z", "C X X", "Q");
        new IndexBuilder(this.basename0, this.documentCollection0).run();
        new IndexBuilder(this.basename1, this.documentCollection1).run();
        new IndexBuilder(this.basename1bis, this.documentCollection1).run();
        this.index0 = DiskBasedIndex.getInstance(this.basename0 + "-text", true, true);
        this.index1 = DiskBasedIndex.getInstance(this.basename1 + "-text", true, true);
        this.index1bis = DiskBasedIndex.getInstance(this.basename1bis + "-text", true, true);
        this.simpleParser = new SimpleParser(this.index0.termProcessor);
    }

    private void assertScores(String q, Index index, Scorer scorer, double[] expected) throws QueryParserException, QueryBuilderVisitorException, IOException {
        Query query = this.simpleParser.parse(q);
        DocumentIteratorBuilderVisitor documentIteratorBuilderVisitor = new DocumentIteratorBuilderVisitor(null, index, Integer.MAX_VALUE);
        DocumentIterator documentIterator = query.accept(documentIteratorBuilderVisitor);
        scorer.wrap(documentIterator);
        int i = 0;
        while (documentIterator.nextDocument() != -1) {
            double score = scorer.score();
            ScorerTest.assertEquals((String)("Item " + i + " (document " + documentIterator.document() + ")"), (double)expected[i], (double)score, (double)0.001);
            ++i;
        }
        documentIterator.dispose();
    }

    public void testBM25Scorer1() throws Exception {
        BM25Scorer scorer = new BM25Scorer(0.75, 0.95);
        this.assertScores("this", this.index0, scorer, new double[]{0.0, 0.0, 0.0});
        this.assertScores("list & things", this.index0, scorer, new double[]{0.8332});
        this.assertScores("good | green", this.index0, scorer, new double[]{0.5108, 0.5683});
    }

    public void testBM25Scorer4() throws Exception {
        BM25Scorer scorer = new BM25Scorer(0.75, 0.95);
        this.assertScores("A", this.index1, scorer, new double[]{0.3053, 0.3053});
        this.assertScores("A | W", this.index1, scorer, new double[]{0.3053, 0.3053});
        this.assertScores("W | A", this.index1, scorer, new double[]{0.3053, 0.3053});
        this.assertScores("A & A", this.index1, scorer, new double[]{0.3053, 0.3053});
        this.assertScores("A | A", this.index1, scorer, new double[]{0.3053, 0.3053});
        this.assertScores("C", this.index1, scorer, new double[]{0.4021, 0.3053});
        this.assertScores("C | W", this.index1, scorer, new double[]{0.4021, 0.3053});
        this.assertScores("W | C", this.index1, scorer, new double[]{0.4021, 0.3053});
        this.assertScores("C & C", this.index1, scorer, new double[]{0.4021, 0.3053});
        this.assertScores("C | C", this.index1, scorer, new double[]{0.4021, 0.3053});
        this.assertScores("Q", this.index1, scorer, new double[]{1.4408});
        this.assertScores("Q | W", this.index1, scorer, new double[]{1.4408});
        this.assertScores("W | Q", this.index1, scorer, new double[]{1.4408});
        this.assertScores("Q & Q", this.index1, scorer, new double[]{1.4408});
        this.assertScores("Q | Q", this.index1, scorer, new double[]{1.4408});
        this.assertScores("A & C", this.index1, scorer, new double[]{0.7074});
        this.assertScores("A & C | W", this.index1, scorer, new double[]{0.7074});
        this.assertScores("W | A & C", this.index1, scorer, new double[]{0.7074});
        this.assertScores("(A & C) & (A & C)", this.index1, scorer, new double[]{0.7074});
        this.assertScores("(A & C) | (A & C)", this.index1, scorer, new double[]{0.7074});
        this.assertScores("(A & C)~2", this.index1, scorer, new double[]{0.7074});
        this.assertScores("(A & C)~2 | W", this.index1, scorer, new double[]{0.7074});
        this.assertScores("W | (A & C)~2", this.index1, scorer, new double[]{0.7074});
        this.assertScores("(A & C)~2 & (A & C)~2", this.index1, scorer, new double[]{0.7074});
        this.assertScores("(A & C)~2 | (A & C)~2", this.index1, scorer, new double[]{0.7074});
        this.assertScores("A & X & Z", this.index1, scorer, new double[]{0.9159});
        this.assertScores("A & X & Z | W", this.index1, scorer, new double[]{0.9159});
        this.assertScores("W | A & X & Z", this.index1, scorer, new double[]{0.9159});
        this.assertScores("(A & X & Z) & (A & X & Z)", this.index1, scorer, new double[]{0.9159});
        this.assertScores("(A & X & Z) | (A & X & Z)", this.index1, scorer, new double[]{0.9159});
        this.assertScores("C | A", this.index1, scorer, new double[]{0.7074, 0.3053, 0.3053});
        this.assertScores("C | A | W", this.index1, scorer, new double[]{0.7074, 0.3053, 0.3053});
        this.assertScores("W | C | A", this.index1, scorer, new double[]{0.7074, 0.3053, 0.3053});
        this.assertScores("(C | A) & (C | A)", this.index1, scorer, new double[]{0.7074, 0.3053, 0.3053});
        this.assertScores("(C | A) | (C | A)", this.index1, scorer, new double[]{0.7074, 0.3053, 0.3053});
        this.assertScores("X | Z", this.index1, scorer, new double[]{0.3609, 0.6106, 0.4021});
        this.assertScores("X | Z | W", this.index1, scorer, new double[]{0.3609, 0.6106, 0.4021});
        this.assertScores("W | X | Z", this.index1, scorer, new double[]{0.3609, 0.6106, 0.4021});
        this.assertScores("(X | Z) & (X | Z)", this.index1, scorer, new double[]{0.3609, 0.6106, 0.4021});
        this.assertScores("(X | Z) | (X | Z)", this.index1, scorer, new double[]{0.3609, 0.6106, 0.4021});
    }

    public void testBM25Scorer5() throws Exception {
        BM25Scorer scorer = new BM25Scorer(0.75, 0.95);
        this.assertScores("A + X", this.index1, scorer, new double[]{0.3053, 0.4021, 0.4021});
        this.assertScores("D + Z", this.index1, scorer, new double[]{0.447, 0.3053});
    }

    private void assertScoresMultiIndex(String q, Object2ReferenceMap<String, Index> indexMap, Index defaultIndex, Scorer scorer, double[] expected) throws QueryParserException, QueryBuilderVisitorException, IOException {
        SimpleParser simpleParser = new SimpleParser((Set)new ObjectOpenHashSet((Object[])new String[]{"t", "u"}), "t", (Map<String, TermProcessor>)new Object2ReferenceOpenHashMap((Object[])new String[]{"t", "u"}, (Object[])new TermProcessor[]{this.index1.termProcessor, this.index1bis.termProcessor}));
        Query query = simpleParser.parse(q);
        DocumentIteratorBuilderVisitor documentIteratorBuilderVisitor = new DocumentIteratorBuilderVisitor(indexMap, defaultIndex, Integer.MAX_VALUE);
        DocumentIterator documentIterator = query.accept(documentIteratorBuilderVisitor);
        scorer.wrap(documentIterator);
        int i = 0;
        while (documentIterator.hasNext()) {
            documentIterator.next();
            double score = scorer.score();
            ScorerTest.assertEquals((String)("Item " + i + " (document " + documentIterator.document() + ")"), (double)expected[i], (double)score, (double)0.001);
            ++i;
        }
        ScorerTest.assertEquals((int)i, (int)expected.length);
        documentIterator.dispose();
    }

    public void testBM25ScorerMulti() throws Exception {
        BM25Scorer scorer = new BM25Scorer(0.75, 0.95);
        scorer.setWeights((Reference2DoubleMap<Index>)new Reference2DoubleOpenHashMap((Object[])new Index[]{this.index1, this.index1bis}, new double[]{1.0, 3.0}));
        Object2ReferenceOpenHashMap indexMap = new Object2ReferenceOpenHashMap((Object[])new String[]{"t", "u"}, (Object[])new Index[]{this.index1, this.index1bis});
        this.assertScoresMultiIndex("A", (Object2ReferenceMap<String, Index>)indexMap, this.index1, scorer, new double[]{0.076325, 0.076325});
        this.assertScoresMultiIndex("u:A", (Object2ReferenceMap<String, Index>)indexMap, this.index1, scorer, new double[]{0.228975, 0.228975});
        this.assertScoresMultiIndex("t:A", (Object2ReferenceMap<String, Index>)indexMap, this.index1, scorer, new double[]{0.076325, 0.076325});
        this.assertScoresMultiIndex("u:A & t:A", (Object2ReferenceMap<String, Index>)indexMap, this.index1, scorer, new double[]{0.3053, 0.3053});
        this.assertScoresMultiIndex("u:A | t:A", (Object2ReferenceMap<String, Index>)indexMap, this.index1, scorer, new double[]{0.3053, 0.3053});
        this.assertScoresMultiIndex("u:A & t:C", (Object2ReferenceMap<String, Index>)indexMap, this.index1, scorer, new double[]{0.3295});
        this.assertScoresMultiIndex("t:A & u:C", (Object2ReferenceMap<String, Index>)indexMap, this.index1, scorer, new double[]{0.3779});
        this.assertScoresMultiIndex("u:A | t:C", (Object2ReferenceMap<String, Index>)indexMap, this.index1, scorer, new double[]{0.3295, 0.228975, 0.076325});
        this.assertScoresMultiIndex("t:A | u:C", (Object2ReferenceMap<String, Index>)indexMap, this.index1, scorer, new double[]{0.3779, 0.076325, 0.228975});
        this.assertScoresMultiIndex("u:A | (u:A & t:C)", (Object2ReferenceMap<String, Index>)indexMap, this.index1, scorer, new double[]{0.3295, 0.228975});
        this.assertScoresMultiIndex("t:A | (u:A & t:C)", (Object2ReferenceMap<String, Index>)indexMap, this.index1, scorer, new double[]{0.405825, 0.076325});
        this.assertScoresMultiIndex("t:X & (t:A | u:C)", (Object2ReferenceMap<String, Index>)indexMap, this.index1, scorer, new double[]{0.15265, 0.3295});
        this.assertScoresMultiIndex("u:X & (u:A | t:C)", (Object2ReferenceMap<String, Index>)indexMap, this.index1, scorer, new double[]{0.45795, 0.3779});
    }

    public void testCounterSetup() throws Exception {
        TermCollectionVisitor termVisitor = new TermCollectionVisitor();
        CounterSetupVisitor setupVisitor = new CounterSetupVisitor(termVisitor);
        CounterCollectionVisitor counterCollectionVisitor = new CounterCollectionVisitor(setupVisitor);
        Query query = this.simpleParser.parse("this");
        DocumentIteratorBuilderVisitor documentIteratorBuilderVisitor = new DocumentIteratorBuilderVisitor(null, this.index0, Integer.MAX_VALUE);
        DocumentIterator indexIterator = query.accept(documentIteratorBuilderVisitor);
        indexIterator.nextDocument();
        termVisitor.prepare();
        indexIterator.accept(termVisitor);
        setupVisitor.prepare();
        indexIterator.accept(setupVisitor);
        ScorerTest.assertEquals((int)3, (int)setupVisitor.frequency[0]);
        ScorerTest.assertEquals((int)1, (int)indexIterator.nextDocument());
        counterCollectionVisitor.prepare();
        indexIterator.accept(counterCollectionVisitor);
        ScorerTest.assertEquals((int)1, (int)setupVisitor.count[0]);
        ScorerTest.assertEquals((int)2, (int)indexIterator.nextDocument());
        counterCollectionVisitor.prepare();
        indexIterator.accept(counterCollectionVisitor);
        ScorerTest.assertEquals((int)1, (int)setupVisitor.count[0]);
    }

    public void testCountScorer() throws QueryParserException, QueryBuilderVisitorException, IOException {
        CountScorer scorer = new CountScorer();
        Query query = this.simpleParser.parse("C");
        DocumentIteratorBuilderVisitor documentIteratorBuilderVisitor = new DocumentIteratorBuilderVisitor(null, this.index1, Integer.MAX_VALUE);
        DocumentIterator documentIterator = query.accept(documentIteratorBuilderVisitor);
        scorer.wrap(documentIterator);
        double[] expected = new double[]{2.0, 1.0};
        int i = 0;
        while (documentIterator.hasNext()) {
            documentIterator.next();
            double score = scorer.score();
            ScorerTest.assertEquals((String)("Item " + i), (double)expected[i], (double)score, (double)0.001);
            ++i;
        }
    }
}

