/*
 * Decompiled with CFR 0.152.
 */
package test.it.unimi.dsi.mg4j.util;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.mg4j.util.BloomFilter;
import java.util.Random;
import junit.framework.TestCase;

public class BloomFilterTest
extends TestCase {
    public void testAdd() {
        BloomFilter bloomFilter = new BloomFilter(10, 30);
        BloomFilterTest.assertTrue((boolean)bloomFilter.add("test"));
        BloomFilterTest.assertFalse((boolean)bloomFilter.add("test"));
        BloomFilterTest.assertTrue((boolean)bloomFilter.add("foo"));
        BloomFilterTest.assertTrue((boolean)bloomFilter.add("bar"));
        BloomFilterTest.assertEquals((long)3L, (long)bloomFilter.size());
        bloomFilter.clear();
        BloomFilterTest.assertTrue((boolean)bloomFilter.add(new int[]{0, 1}));
        BloomFilterTest.assertFalse((boolean)bloomFilter.add(new int[]{0, 1}));
        BloomFilterTest.assertTrue((boolean)bloomFilter.add(new int[]{1, 2}));
        BloomFilterTest.assertTrue((boolean)bloomFilter.add(new int[]{1, 0}));
        BloomFilterTest.assertEquals((long)3L, (long)bloomFilter.size());
    }

    public void testConflicts() {
        BloomFilter bloomFilter = new BloomFilter(1000, 11);
        LongOpenHashSet longs = new LongOpenHashSet();
        Random random = new Random(0L);
        int i = 1000;
        while (i-- != 0) {
            long l = random.nextLong();
            longs.add(l);
            bloomFilter.add(Long.toBinaryString(l));
        }
        BloomFilterTest.assertEquals((long)longs.size(), (long)bloomFilter.size());
    }
}

