/*
 * Decompiled with CFR 0.152.
 */
package test.it.unimi.dsi.mg4j.util.parser;

import it.unimi.dsi.mg4j.util.MutableString;
import it.unimi.dsi.mg4j.util.parser.BulletParser;
import it.unimi.dsi.mg4j.util.parser.Element;
import it.unimi.dsi.mg4j.util.parser.callback.Callback;
import it.unimi.dsi.mg4j.util.parser.callback.DefaultCallback;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.io.IOUtils;

public class BulletParserTest
extends TestCase {
    public void testParser() throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, FileNotFoundException, IOException {
        char[] text = IOUtils.toCharArray((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("test.html"), (String)"UTF-8");
        Callback mockCallback = (Callback)Proxy.getProxyClass(Callback.class.getClassLoader(), Callback.class).getConstructor(InvocationHandler.class).newInstance(new InvocationHandler(){
            int call = 0;
            String[] methods = new String[]{"configure", "startDocument", "endDocument"};

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (this.call < this.methods.length) {
                    Assert.assertEquals((String)method.getName(), (String)this.methods[this.call++]);
                }
                return Boolean.TRUE;
            }
        });
        new BulletParser().setCallback(mockCallback).parse(text, 0, text.length);
    }

    public void testScanEntityAtEndOfArray() {
        VisibleBulletParser parser = new VisibleBulletParser();
        char[] test = "&test".toCharArray();
        BulletParserTest.assertEquals((int)-1, (int)parser.scanEntity(test, 0, test.length, false, new MutableString()));
        BulletParserTest.assertEquals((int)-1, (int)parser.scanEntity(test, 0, test.length, true, new MutableString()));
        test = "&apos".toCharArray();
        BulletParserTest.assertEquals((int)-1, (int)parser.scanEntity(test, 0, test.length, false, new MutableString()));
        BulletParserTest.assertEquals((int)5, (int)parser.scanEntity(test, 0, test.length, true, new MutableString()));
    }

    public void testCdata() {
        BulletParser parser = new BulletParser();
        DefaultCallback callback = new DefaultCallback(){

            public boolean cdata(Element element, char[] text, int offset, int length) {
                Assert.assertEquals((String)"Test > 0", (String)new String(text, offset, length));
                return true;
            }
        };
        parser.setCallback(callback);
        parser.parseCDATA(true);
        parser.parse("<tag><![CDATA[Test > 0]]></tag>".toCharArray());
        parser.parse("<tag><![CDATA[Test > 0".toCharArray());
    }

    private final class VisibleBulletParser
    extends BulletParser {
        private VisibleBulletParser() {
        }

        public int scanEntity(char[] a, int offset, int length, boolean loose, MutableString entity) {
            return super.scanEntity(a, offset, length, loose, entity);
        }
    }
}

