/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.index;

import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMaps;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import it.unimi.dsi.mg4j.index.AbstractIndexIterator;
import it.unimi.dsi.mg4j.index.AbstractIndexReader;
import it.unimi.dsi.mg4j.index.BitStreamIndex;
import it.unimi.dsi.mg4j.index.BitStreamIndexReader;
import it.unimi.dsi.mg4j.index.CompressionFlags;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.index.IndexIterator;
import it.unimi.dsi.mg4j.index.payload.Payload;
import it.unimi.dsi.mg4j.io.InputBitStream;
import it.unimi.dsi.mg4j.io.InterpolativeCoding;
import it.unimi.dsi.mg4j.search.Interval;
import it.unimi.dsi.mg4j.search.IntervalIterator;
import it.unimi.dsi.mg4j.search.IntervalIterators;
import it.unimi.dsi.mg4j.util.Fast;
import java.io.IOException;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class SqrtSkipIndexReader
extends AbstractIndexReader {
    private static final Logger LOGGER = Fast.getLogger(BitStreamIndexReader.class);
    protected final BitStreamIndex index;
    private static final boolean ASSERTS = true;
    private static final boolean DEBUG = false;
    protected final SqrtSkipBitStreamIndexReaderIndexIterator indexIterator;

    public SqrtSkipIndexReader(BitStreamIndex index, InputBitStream ibs) {
        this.index = index;
        this.indexIterator = new SqrtSkipBitStreamIndexReaderIndexIterator(this, ibs);
    }

    private IndexIterator documents(CharSequence term, int termNumber) throws IOException {
        this.indexIterator.term(term);
        this.indexIterator.position(termNumber);
        return this.indexIterator;
    }

    public IndexIterator documents(int term) throws IOException {
        return this.documents(null, term);
    }

    public IndexIterator documents(CharSequence term) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("This " + this.getClass().getSimpleName() + " has been closed");
        }
        if (this.index.termMap != null) {
            int termIndex = this.index.termMap.getNumber(term);
            if (termIndex == -1) {
                return this.index.emptyIndexIterator;
            }
            return this.documents(term, termIndex);
        }
        throw new UnsupportedOperationException("Index " + this.index + " has no term map");
    }

    public IndexIterator nextIterator() throws IOException {
        return this.indexIterator.advance();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.index + "]";
    }

    public void close() throws IOException {
        super.close();
        this.indexIterator.ibs.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class SqrtSkipBitStreamIndexReaderIndexIterator
    extends AbstractIndexIterator
    implements IndexIterator {
        private final SqrtSkipIndexReader parent;
        protected final BitStreamIndex index;
        protected final InputBitStream ibs;
        private final IndexIntervalIterator intervalIterator;
        private final Reference2ReferenceMap<Index, IntervalIterator> singletonIntervalIterator;
        private final Index keyIndex;
        protected final boolean hasPositions;
        protected final boolean hasCounts;
        protected final boolean hasPayloads;
        protected final CompressionFlags.Coding pointerCoding;
        protected final CompressionFlags.Coding countCoding;
        protected final CompressionFlags.Coding positionCoding;
        protected final Payload payload;
        protected int b;
        protected int log2b;
        protected int currentTerm = -1;
        protected int frequency;
        protected boolean hasPointers;
        protected int count;
        protected int currentDocument;
        protected int numberOfDocumentRecord;
        protected int state;
        public int quantum;
        private long readBitsAtLastSkipTower;
        protected static final int BEFORE_TOWER = 0;
        protected static final int BEFORE_PAYLOAD = 1;
        protected static final int BEFORE_COUNT = 2;
        protected static final int BEFORE_POSITIONS = 3;
        protected static final int BEFORE_POINTER = 4;
        protected int[] positionCache = new int[16];
        private int skipPointer;
        private long skipAmount;

        public SqrtSkipBitStreamIndexReaderIndexIterator(SqrtSkipIndexReader reader, InputBitStream ibs) {
            this.parent = reader;
            this.ibs = ibs;
            this.index = reader.index;
            this.keyIndex = this.index.keyIndex;
            this.pointerCoding = this.index.pointerCoding;
            this.hasPayloads = this.index.hasPayloads;
            this.payload = this.hasPayloads ? this.index.payload.copy() : null;
            this.hasCounts = this.index.hasCounts;
            this.countCoding = this.index.countCoding;
            this.hasPositions = this.index.hasPositions;
            this.positionCoding = this.index.positionCoding;
            this.intervalIterator = this.index.hasPositions ? new IndexIntervalIterator() : null;
            this.singletonIntervalIterator = this.index.hasPositions ? Reference2ReferenceMaps.singleton((Object)this.keyIndex, (Object)this.intervalIterator) : null;
        }

        protected void position(int term) throws IOException {
            if (term == 0) {
                this.ibs.position(0L);
                this.ibs.readBits(0L);
            } else {
                if (this.index.offsets == null) {
                    throw new IllegalStateException("You cannot position an index without offsets");
                }
                long offset = this.index.offsets.getLong(term);
                this.ibs.position(offset);
                this.ibs.readBits(offset);
            }
            this.currentTerm = term;
            this.readFrequency();
        }

        protected IndexIterator advance() throws IOException {
            if (this.currentTerm == this.index.numberOfTerms - 1) {
                return null;
            }
            if (this.currentTerm != -1) {
                this.skipTo(Integer.MAX_VALUE);
                this.nextDocument();
            }
            ++this.currentTerm;
            this.readFrequency();
            return this;
        }

        private void readFrequency() throws IOException {
            switch (this.index.frequencyCoding) {
                case GAMMA: {
                    this.frequency = this.ibs.readGamma() + 1;
                    break;
                }
                case SHIFTED_GAMMA: {
                    this.frequency = this.ibs.readShiftedGamma() + 1;
                    break;
                }
                case DELTA: {
                    this.frequency = this.ibs.readDelta() + 1;
                    break;
                }
                default: {
                    throw new IllegalStateException("The required frequency coding (" + (Object)((Object)this.index.frequencyCoding) + ") is not supported.");
                }
            }
            boolean bl = this.hasPointers = this.frequency < this.index.numberOfDocuments;
            if (this.pointerCoding == CompressionFlags.Coding.GOLOMB && this.hasPointers) {
                this.b = Fast.golombModulus(this.frequency, this.index.numberOfDocuments);
                this.log2b = Fast.mostSignificantBit(this.b);
            }
            this.quantum = (int)Math.max(Math.round(Math.sqrt(this.frequency)), 16L);
            this.count = -1;
            this.currentDocument = -1;
            this.numberOfDocumentRecord = -1;
            this.state = 4;
        }

        @Override
        public Index index() {
            return this.keyIndex;
        }

        @Override
        public int frequency() {
            return this.frequency;
        }

        private void ensureCurrentDocument() {
            if (this.currentDocument < 0) {
                throw new IllegalStateException("nextDocument() has never been called for (term=" + this.currentTerm + ")");
            }
            if (this.currentDocument == Integer.MAX_VALUE) {
                throw new IllegalStateException("This reader is positioned beyond the end of list of (term=" + this.currentTerm + ")");
            }
        }

        private boolean endOfList() {
            assert (this.numberOfDocumentRecord <= this.frequency);
            return this.numberOfDocumentRecord >= this.frequency - 1;
        }

        @Override
        public int document() {
            this.ensureCurrentDocument();
            return this.currentDocument;
        }

        @Override
        public Payload payload() throws IOException {
            this.ensureCurrentDocument();
            if (!this.hasPayloads) {
                throw new UnsupportedOperationException("This index (" + this.index + ") does not contain payloads");
            }
            if (this.state <= 1) {
                if (this.state == 0) {
                    this.readTower();
                }
                this.payload.read(this.ibs);
                this.state = this.hasCounts ? 2 : 4;
            }
            return this.payload;
        }

        @Override
        public int count() throws IOException {
            if (this.count != -1) {
                return this.count;
            }
            this.ensureCurrentDocument();
            if (!this.hasCounts) {
                throw new UnsupportedOperationException("This index (" + this.index + ") does not contain counts");
            }
            if (this.state == 0) {
                this.readTower();
            }
            if (this.state == 1) {
                this.payload.read(this.ibs);
            }
            if (this.state != 2) {
                throw new IllegalStateException();
            }
            this.state = this.hasPositions ? 3 : 4;
            switch (this.countCoding) {
                case UNARY: {
                    this.count = this.ibs.readUnary() + 1;
                    break;
                }
                case SHIFTED_GAMMA: {
                    this.count = this.ibs.readShiftedGamma() + 1;
                    break;
                }
                case GAMMA: {
                    this.count = this.ibs.readGamma() + 1;
                    break;
                }
                case DELTA: {
                    this.count = this.ibs.readDelta() + 1;
                    break;
                }
                default: {
                    throw new IllegalStateException("The required count coding (" + (Object)((Object)this.countCoding) + ") is not supported.");
                }
            }
            return this.count;
        }

        protected void updatePositionCache() throws IOException {
            assert (this.state <= 3);
            if (!this.hasPositions) {
                throw new UnsupportedOperationException("This index(" + this.index + ") does not contain positions");
            }
            if (this.state < 3) {
                if (this.state == 0) {
                    this.readTower();
                }
                if (this.state == 1) {
                    this.payload.read(this.ibs);
                }
                if (this.state == 2) {
                    if (this.state != 2) {
                        throw new IllegalStateException();
                    }
                    switch (this.countCoding) {
                        case UNARY: {
                            this.count = this.ibs.readUnary() + 1;
                            break;
                        }
                        case SHIFTED_GAMMA: {
                            this.count = this.ibs.readShiftedGamma() + 1;
                            break;
                        }
                        case GAMMA: {
                            this.count = this.ibs.readGamma() + 1;
                            break;
                        }
                        case DELTA: {
                            this.count = this.ibs.readDelta() + 1;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("The required count coding (" + (Object)((Object)this.countCoding) + ") is not supported.");
                        }
                    }
                }
            }
            if (this.count > this.positionCache.length) {
                this.positionCache = new int[Math.max(this.positionCache.length * 2, this.count)];
            }
            int[] occ = this.positionCache;
            this.state = 4;
            switch (this.positionCoding) {
                case SHIFTED_GAMMA: {
                    this.ibs.readShiftedGammas(occ, this.count);
                    for (int i = 1; i < this.count; ++i) {
                        int n = i;
                        occ[n] = occ[n] + (occ[i - 1] + 1);
                    }
                    return;
                }
                case GAMMA: {
                    this.ibs.readGammas(occ, this.count);
                    for (int i = 1; i < this.count; ++i) {
                        int n = i;
                        occ[n] = occ[n] + (occ[i - 1] + 1);
                    }
                    return;
                }
                case DELTA: {
                    this.ibs.readDeltas(occ, this.count);
                    for (int i = 1; i < this.count; ++i) {
                        int n = i;
                        occ[n] = occ[n] + (occ[i - 1] + 1);
                    }
                    return;
                }
                case GOLOMB: {
                    assert (this.index.sizes != null);
                    int docSize = this.index.sizes.getInt(this.currentDocument);
                    if (this.count < 3) {
                        for (int i = 0; i < this.count; ++i) {
                            occ[i] = this.ibs.readMinimalBinary(docSize);
                        }
                    } else {
                        int bb = Fast.golombModulus(this.count, docSize);
                        int prev = -1;
                        if (bb != 0) {
                            int log2bb = Fast.mostSignificantBit(bb);
                            for (int i = 0; i < this.count; ++i) {
                                occ[i] = prev = this.ibs.readGolomb(bb, log2bb) + prev + 1;
                            }
                        } else {
                            for (int i = 0; i < this.count; ++i) {
                                occ[i] = i;
                            }
                        }
                    }
                    return;
                }
                case SKEWED_GOLOMB: {
                    assert (this.index.sizes != null);
                    int docSize2 = this.index.sizes.getInt(this.currentDocument);
                    if (this.count < 3) {
                        for (int i = 0; i < this.count; ++i) {
                            occ[i] = this.ibs.readMinimalBinary(docSize2);
                        }
                    } else {
                        int sb = this.ibs.readMinimalBinary(docSize2) + 1;
                        int prev2 = -1;
                        for (int i = 0; i < this.count; ++i) {
                            occ[i] = prev2 = this.ibs.readSkewedGolomb(sb) + prev2 + 1;
                        }
                    }
                    return;
                }
                case INTERPOLATIVE: {
                    InterpolativeCoding.read(this.ibs, occ, 0, this.count, 0, this.index.sizes.getInt(this.currentDocument) - 1);
                    return;
                }
            }
            throw new IllegalStateException("The required position coding (" + (Object)((Object)this.index.positionCoding) + ") is not supported.");
        }

        @Override
        public IntIterator positions() throws IOException {
            this.ensureCurrentDocument();
            if (this.state <= 3) {
                this.updatePositionCache();
            }
            return IntIterators.wrap((int[])this.positionCache, (int)0, (int)this.count);
        }

        @Override
        public int[] positionArray() throws IOException {
            this.ensureCurrentDocument();
            if (this.state <= 3) {
                this.updatePositionCache();
            }
            return this.positionCache;
        }

        @Override
        public int positions(int[] position) throws IOException {
            this.ensureCurrentDocument();
            if (this.state <= 3) {
                this.updatePositionCache();
            }
            if (position.length < this.count) {
                return -this.count;
            }
            int i = this.count;
            while (i-- != 0) {
                position[i] = this.positionCache[i];
            }
            return this.count;
        }

        @Override
        public int nextDocument() throws IOException {
            block42: {
                block41: {
                    if (this.state != 4) {
                        if (this.state == 0) {
                            this.readTower();
                        }
                        if (this.state == 1) {
                            this.payload.read(this.ibs);
                        }
                        if (this.state == 2) {
                            if (this.state != 2) {
                                throw new IllegalStateException();
                            }
                            this.state = this.hasPositions ? 3 : 4;
                            switch (this.countCoding) {
                                case UNARY: {
                                    this.count = this.ibs.readUnary() + 1;
                                    break;
                                }
                                case SHIFTED_GAMMA: {
                                    this.count = this.ibs.readShiftedGamma() + 1;
                                    break;
                                }
                                case GAMMA: {
                                    this.count = this.ibs.readGamma() + 1;
                                    break;
                                }
                                case DELTA: {
                                    this.count = this.ibs.readDelta() + 1;
                                    break;
                                }
                                default: {
                                    throw new IllegalStateException("The required count coding (" + (Object)((Object)this.countCoding) + ") is not supported.");
                                }
                            }
                        }
                        if (this.state == 3) {
                            this.state = 4;
                            switch (this.positionCoding) {
                                case SHIFTED_GAMMA: {
                                    this.ibs.skipShiftedGammas(this.count);
                                    break;
                                }
                                case GAMMA: {
                                    this.ibs.skipGammas(this.count);
                                    break;
                                }
                                case DELTA: {
                                    this.ibs.skipDeltas(this.count);
                                    break;
                                }
                                case GOLOMB: {
                                    assert (this.index.sizes != null);
                                    int docSize = this.index.sizes.getInt(this.currentDocument);
                                    if (this.count < 3) {
                                        for (int i = 0; i < this.count; ++i) {
                                            this.ibs.readMinimalBinary(docSize);
                                        }
                                    } else {
                                        int bb = Fast.golombModulus(this.count, docSize);
                                        if (bb == 0) break;
                                        int log2bb = Fast.mostSignificantBit(bb);
                                        for (int i = 0; i < this.count; ++i) {
                                            this.ibs.readGolomb(bb, log2bb);
                                        }
                                    }
                                    break;
                                }
                                case SKEWED_GOLOMB: {
                                    assert (this.index.sizes != null);
                                    int docSize = this.index.sizes.getInt(this.currentDocument);
                                    if (this.count < 3) {
                                        for (int i = 0; i < this.count; ++i) {
                                            this.ibs.readMinimalBinary(docSize);
                                        }
                                    } else {
                                        int sb = this.ibs.readMinimalBinary(docSize) + 1;
                                        for (int i = 0; i < this.count; ++i) {
                                            this.ibs.readSkewedGolomb(sb);
                                        }
                                    }
                                    break;
                                }
                                case INTERPOLATIVE: {
                                    InterpolativeCoding.read(this.ibs, null, 0, this.count, 0, this.index.sizes.getInt(this.currentDocument) - 1);
                                    break;
                                }
                                default: {
                                    throw new IllegalStateException("The required position coding (" + (Object)((Object)this.positionCoding) + ") is not supported.");
                                }
                            }
                        }
                    }
                    if (this.endOfList()) {
                        return -1;
                    }
                    if (!this.hasPointers) break block41;
                    switch (this.pointerCoding) {
                        case SHIFTED_GAMMA: {
                            this.currentDocument += this.ibs.readShiftedGamma() + 1;
                            break block42;
                        }
                        case GAMMA: {
                            this.currentDocument += this.ibs.readGamma() + 1;
                            break block42;
                        }
                        case DELTA: {
                            this.currentDocument += this.ibs.readDelta() + 1;
                            break block42;
                        }
                        case GOLOMB: {
                            this.currentDocument += this.ibs.readGolomb(this.b, this.log2b) + 1;
                            break block42;
                        }
                        default: {
                            throw new IllegalStateException("The required pointer coding (" + (Object)((Object)this.pointerCoding) + ") is not supported.");
                        }
                    }
                }
                ++this.currentDocument;
            }
            ++this.numberOfDocumentRecord;
            if (this.hasPayloads) {
                this.state = 1;
            } else if (this.hasCounts) {
                this.state = 2;
            }
            this.count = -1;
            if (this.numberOfDocumentRecord % this.quantum == 0) {
                this.state = 0;
            }
            return this.currentDocument;
        }

        private void readTower() throws IOException {
            assert (this.numberOfDocumentRecord % this.quantum == 0);
            if (this.state != 0) {
                throw new IllegalStateException("readTower() called in state " + this.state);
            }
            this.skipPointer = Integer.MAX_VALUE;
            this.skipAmount = -1L;
            if (this.frequency - this.numberOfDocumentRecord >= this.quantum) {
                this.skipPointer = this.currentDocument + this.ibs.readDelta();
                this.skipAmount = this.ibs.readLongDelta();
            }
            this.state = this.index.hasCounts ? 2 : 4;
            this.readBitsAtLastSkipTower = this.ibs.readBits();
        }

        @Override
        public int skipTo(int p) throws IOException {
            if (this.numberOfDocumentRecord == -1) {
                this.nextDocument();
            }
            if (this.currentDocument >= p) {
                return this.currentDocument;
            }
            if (this.state == 0) {
                this.readTower();
            }
            while (this.skipPointer < p) {
                this.ibs.skip(this.skipAmount - (this.ibs.readBits() - this.readBitsAtLastSkipTower));
                this.state = 0;
                this.currentDocument = this.skipPointer;
                this.numberOfDocumentRecord += this.quantum - this.numberOfDocumentRecord % this.quantum;
                if (this.numberOfDocumentRecord == this.frequency) {
                    this.currentDocument = Integer.MAX_VALUE;
                    this.state = 4;
                } else {
                    this.readTower();
                }
                this.count = -1;
                if (!this.endOfList()) continue;
                return p == Integer.MAX_VALUE ? Integer.MAX_VALUE : this.currentDocument;
            }
            while (this.currentDocument < p) {
                if (this.nextDocument() != -1) continue;
                return Integer.MAX_VALUE;
            }
            return this.currentDocument;
        }

        @Override
        public void dispose() throws IOException {
            this.parent.close();
        }

        public boolean hasNext() {
            return !this.endOfList();
        }

        @Override
        public int nextInt() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                return this.nextDocument();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            return this.index + " [" + this.currentTerm + "]";
        }

        @Override
        public Reference2ReferenceMap<Index, IntervalIterator> intervalIterators() throws IOException {
            this.intervalIterator();
            return this.singletonIntervalIterator;
        }

        @Override
        public IntervalIterator intervalIterator() throws IOException {
            return this.intervalIterator(this.keyIndex);
        }

        @Override
        public IntervalIterator intervalIterator(Index index) throws IOException {
            this.ensureCurrentDocument();
            if (index != this.keyIndex) {
                return IntervalIterators.TRUE;
            }
            assert (this.intervalIterator != null);
            this.intervalIterator.reset();
            return this.intervalIterator;
        }

        @Override
        public ReferenceSet<Index> indices() {
            return this.index.singletonSet;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class IndexIntervalIterator
        extends AbstractObjectIterator<Interval>
        implements IntervalIterator {
            int pos = -1;

            private IndexIntervalIterator() {
            }

            @Override
            public void reset() throws IOException {
                this.pos = -1;
                if (SqrtSkipBitStreamIndexReaderIndexIterator.this.state <= 3) {
                    SqrtSkipBitStreamIndexReaderIndexIterator.this.updatePositionCache();
                }
            }

            @Override
            public boolean hasNext() {
                return this.pos < SqrtSkipBitStreamIndexReaderIndexIterator.this.count - 1;
            }

            @Override
            public Interval next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return Interval.valueOf(SqrtSkipBitStreamIndexReaderIndexIterator.this.positionCache[++this.pos]);
            }

            @Override
            public Interval nextInterval() {
                return this.pos < SqrtSkipBitStreamIndexReaderIndexIterator.this.count - 1 ? Interval.valueOf(SqrtSkipBitStreamIndexReaderIndexIterator.this.positionCache[++this.pos]) : null;
            }

            @Override
            public int extent() {
                return 1;
            }

            public String toString() {
                return SqrtSkipBitStreamIndexReaderIndexIterator.this.index + ": " + SqrtSkipBitStreamIndexReaderIndexIterator.this.term + "[doc=" + SqrtSkipBitStreamIndexReaderIndexIterator.this.currentDocument + ", count=" + SqrtSkipBitStreamIndexReaderIndexIterator.this.count + ", pos=" + this.pos + "]";
            }
        }
    }
}

