/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics;

import edu.unc.genomics.AssemblyManagerDialog;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.Job;
import edu.unc.genomics.JobConfigPanel;
import edu.unc.genomics.JobException;
import edu.unc.genomics.JobQueue;
import edu.unc.genomics.JobQueueCellRenderer;
import edu.unc.genomics.JobQueueManager;
import edu.unc.genomics.SubmittedJob;
import edu.unc.genomics.ToolsTree;
import edu.unc.genomics.ToolsTreeModel;
import edu.unc.genomics.ToolsTreeNode;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.simplericity.macify.eawt.Application;
import org.simplericity.macify.eawt.ApplicationEvent;
import org.simplericity.macify.eawt.ApplicationListener;
import org.simplericity.macify.eawt.DefaultApplication;
import org.xml.sax.SAXException;

public class ToolRunnerFrame
extends JFrame
implements ApplicationListener {
    private static final long serialVersionUID = 6454774196137357898L;
    private static final Logger log = Logger.getLogger(ToolRunnerFrame.class);
    private final Application application = new DefaultApplication();
    private final JPanel contentPane = new JPanel();
    private final JSplitPane splitPane = new JSplitPane();
    private final JPanel mainPane = new JPanel();
    private final JProgressBar progressBar = new JProgressBar();
    private final JTabbedPane tabbedPane = new JTabbedPane(1);
    private final JobConfigPanel configurationPanel = new JobConfigPanel();
    private final JTextPane helpTextPanel = new JTextPane();
    private final ToolsTree toolsTree = new ToolsTree();
    private final JobQueue queue = new JobQueue();
    private final JobQueueManager queueManager = new JobQueueManager(this.queue);
    private final JList<SubmittedJob> queueList = new JList<SubmittedJob>(this.queue);

    public ToolRunnerFrame() {
        this.application.addApplicationListener((ApplicationListener)this);
        if (this.application.isMac()) {
            this.setDefaultCloseOperation(1);
        } else {
            this.setDefaultCloseOperation(3);
        }
        this.setTitle("Genomics Toolkit Tool Runner");
        this.setBounds(100, 100, 1000, 600);
        this.contentPane.setBorder(BorderFactory.createEmptyBorder());
        this.contentPane.setLayout(new BorderLayout(0, 0));
        this.setContentPane(this.contentPane);
        this.initializeChildren();
        this.initializeMenuBar();
    }

    private void initializeChildren() {
        this.splitPane.setBorder(BorderFactory.createEmptyBorder());
        this.contentPane.add((Component)this.splitPane, "Center");
        this.initializeQueuePanel();
        this.initializeToolsTree();
        this.mainPane.setLayout(new BorderLayout(0, 0));
        this.mainPane.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        this.mainPane.add((Component)this.tabbedPane, "Center");
        JPanel runPanel = new JPanel();
        runPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        runPanel.setLayout(new BoxLayout(runPanel, 0));
        runPanel.add(this.progressBar);
        JButton btnRun = new JButton("Run");
        btnRun.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolRunnerFrame.this.addJobToQueue();
            }
        });
        runPanel.add(btnRun);
        this.mainPane.add((Component)runPanel, "South");
        this.splitPane.setRightComponent(this.mainPane);
        this.initializeConfigurationPanel();
        this.initializeHelpPanel();
    }

    private void initializeMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu mnFileMenu = new JMenu("File");
        menuBar.add(mnFileMenu);
        JMenuItem mntmAssemblyManager = new JMenuItem("Assembly manager");
        mntmAssemblyManager.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMenuItem menuItem = (JMenuItem)e.getSource();
                JPopupMenu popupMenu = (JPopupMenu)menuItem.getParent();
                Component invoker = popupMenu.getInvoker();
                JComponent invokerAsJComponent = (JComponent)invoker;
                Container topLevel = invokerAsJComponent.getTopLevelAncestor();
                AssemblyManagerDialog dialog = new AssemblyManagerDialog((JFrame)topLevel);
                dialog.setVisible(true);
            }
        });
        mnFileMenu.add(mntmAssemblyManager);
        JMenu mnHelpMenu = new JMenu("Help");
        menuBar.add(mnHelpMenu);
        JMenuItem mntmHelpContents = new JMenuItem("Help Contents");
        mnHelpMenu.add(mntmHelpContents);
        if (!this.application.isMac()) {
            JMenuItem mntmAbout = new JMenuItem("About");
            mnHelpMenu.add(mntmAbout);
            mnHelpMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ToolRunnerFrame.this.handleAbout(null);
                }
            });
        }
    }

    private void initializeQueuePanel() {
        JPanel queuePanel = new JPanel();
        queuePanel.setLayout(new BoxLayout(queuePanel, 3));
        queuePanel.setBorder(BorderFactory.createEmptyBorder());
        this.contentPane.add((Component)queuePanel, "East");
        JLabel queueLabel = new JLabel("Job Queue");
        queueLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        queueLabel.setAlignmentX(0.5f);
        queuePanel.add(queueLabel);
        this.queueList.setBackground(this.contentPane.getBackground());
        this.queueList.setCellRenderer(new JobQueueCellRenderer());
        JScrollPane queueListScrollPane = new JScrollPane(this.queueList);
        queueListScrollPane.setBorder(BorderFactory.createEmptyBorder());
        queueListScrollPane.setBackground(this.contentPane.getBackground());
        queueListScrollPane.setPreferredSize(new Dimension(200, Integer.MAX_VALUE));
        queuePanel.add(queueListScrollPane);
    }

    private void initializeConfigurationPanel() {
        JScrollPane configScrollPane = new JScrollPane(this.configurationPanel);
        configScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.tabbedPane.addTab("Tool Configuration", null, configScrollPane, "Configure tool");
    }

    private void initializeHelpPanel() {
        JPanel helpPanel = new JPanel();
        this.tabbedPane.addTab("Help", null, helpPanel, null);
        helpPanel.setLayout(new BorderLayout(0, 0));
        this.helpTextPanel.setEditable(false);
        this.helpTextPanel.setBackground(this.tabbedPane.getBackground());
        Font mono = new Font("Monospaced", this.helpTextPanel.getFont().getStyle(), this.helpTextPanel.getFont().getSize());
        this.helpTextPanel.setFont(mono);
        JScrollPane helpScrollPane = new JScrollPane(this.helpTextPanel);
        helpScrollPane.setBorder(BorderFactory.createEmptyBorder());
        helpPanel.add(helpScrollPane);
    }

    private void initializeToolsTree() {
        try {
            ToolsTreeModel model = ToolsTreeModel.loadDefaultConfig();
            this.toolsTree.setModel(model);
        }
        catch (IOException | ParserConfigurationException | SAXException e1) {
            log.error((Object)"Error loading tool configuration file");
            e1.printStackTrace();
            System.exit(-1);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Error loading tool: " + e.getMessage()));
            e.printStackTrace();
            System.exit(-1);
        }
        this.toolsTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                ToolRunnerFrame.this.changeTool();
            }
        });
        JScrollPane toolsTreeScrollPane = new JScrollPane(this.toolsTree);
        toolsTreeScrollPane.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, Color.LIGHT_GRAY));
        this.splitPane.setLeftComponent(toolsTreeScrollPane);
    }

    private void changeTool() {
        Object node = this.toolsTree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        if (node instanceof ToolsTreeNode) {
            ToolsTreeNode toolNode = (ToolsTreeNode)node;
            try {
                Class<? extends CommandLineTool> tool = toolNode.getClazz();
                Job job = new Job(tool);
                this.configurationPanel.setJob(job);
                this.helpTextPanel.setText(job.getUsageText());
            }
            catch (IllegalAccessException | InstantiationException e) {
                log.error((Object)"Error initializing Job");
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "Error initializing job", "Job Initialization Error", 0);
            }
        }
    }

    private void addJobToQueue() {
        Job currentJob = this.configurationPanel.getJob();
        if (currentJob == null) {
            return;
        }
        log.info((Object)"Validating parameters for tool");
        if (!currentJob.validateArguments()) {
            this.configurationPanel.highlightInvalidArguments();
            return;
        }
        try {
            this.queueManager.submitJob(currentJob);
            this.configurationPanel.setJob(null);
        }
        catch (JobException e) {
            log.error((Object)"Error adding Job to queue");
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Error adding job to queue", "Job Queue Error", 0);
        }
    }

    public void handleAbout(ApplicationEvent event) {
        JOptionPane.showMessageDialog(this, "Java Genomics Toolkit v1.0");
        if (event != null) {
            event.setHandled(true);
        }
    }

    public void handleOpenApplication(ApplicationEvent event) {
    }

    public void handleOpenFile(ApplicationEvent event) {
    }

    public void handlePreferences(ApplicationEvent event) {
    }

    public void handlePrintFile(ApplicationEvent event) {
    }

    public void handleQuit(ApplicationEvent event) {
        boolean confirm = true;
        if (this.queueManager.isRunning()) {
            int result = JOptionPane.showConfirmDialog(this, "Jobs are currently running. Are you sure you want to quit?", "Confirm Quit", 2);
            boolean bl = confirm = result == 0;
        }
        if (confirm) {
            this.dispose();
            System.exit(0);
        }
    }

    public void handleReOpenApplication(ApplicationEvent event) {
        this.setVisible(true);
    }
}

