/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics;

import edu.unc.genomics.ValuedInterval;
import edu.unc.genomics.io.IntervalFileFormatException;
import edu.unc.genomics.util.ArrayUtils;

public class BedEntry
extends ValuedInterval {
    private static final long serialVersionUID = 8657984166944604756L;
    private String itemRgb;
    private int thickStart;
    private int thickEnd;
    private int blockCount;
    private int[] blockSizes;
    private int[] blockStarts;

    public BedEntry(String chr, int start, int stop) {
        super(chr, start, stop);
    }

    public static BedEntry parse(String line) {
        int stop;
        if (line.startsWith("#") || line.startsWith("track")) {
            return null;
        }
        String[] entry = line.split("\t");
        if (entry.length < 3) {
            throw new IntervalFileFormatException("Invalid Bed entry has < 3 columns");
        }
        String chr = entry[0];
        int start = Integer.parseInt(entry[1]) + 1;
        if (start > (stop = Integer.parseInt(entry[2]))) {
            throw new IntervalFileFormatException("Invalid Bed entry has start > stop");
        }
        BedEntry bed = new BedEntry(chr, start, stop);
        if (entry.length >= 4) {
            bed.setId(entry[3]);
        }
        if (entry.length >= 5 && !entry[4].equalsIgnoreCase(".")) {
            bed.setValue(Double.valueOf(entry[4]));
        }
        if (entry.length >= 6 && entry[5].equalsIgnoreCase("-")) {
            int tmp = bed.getStart();
            bed.setStart(stop);
            bed.setStop(tmp);
        }
        if (entry.length >= 8) {
            bed.setThickStart(Integer.parseInt(entry[6]) + 1);
            bed.setThickEnd(Integer.parseInt(entry[7]));
        }
        if (entry.length >= 9) {
            bed.setItemRgb(entry[8]);
        }
        if (entry.length >= 12) {
            bed.setBlockCount(Integer.parseInt(entry[9]));
            bed.setBlockSizes(ArrayUtils.mapToInt(entry[10].split(",")));
            bed.setBlockStarts(ArrayUtils.mapToInt(entry[11].split(",")));
        }
        return bed;
    }

    public String getItemRgb() {
        return this.itemRgb;
    }

    public void setItemRgb(String itemRgb) {
        this.itemRgb = itemRgb;
    }

    public int getThickStart() {
        return this.thickStart;
    }

    public void setThickStart(int thickStart) {
        this.thickStart = thickStart;
    }

    public int getThickEnd() {
        return this.thickEnd;
    }

    public void setThickEnd(int thickEnd) {
        this.thickEnd = thickEnd;
    }

    public int getBlockCount() {
        return this.blockCount;
    }

    public void setBlockCount(int blockCount) {
        this.blockCount = blockCount;
    }

    public int[] getBlockSizes() {
        return this.blockSizes;
    }

    public void setBlockSizes(int[] blockSizes) {
        this.blockSizes = blockSizes;
    }

    public int[] getBlockStarts() {
        return this.blockStarts;
    }

    public void setBlockStarts(int[] blockStarts) {
        this.blockStarts = blockStarts;
    }
}

