/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.test;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public final class StringBuffer2
implements Serializable,
CharSequence {
    private char[] value;
    private int count;
    private int hash = 0;
    private boolean shared;
    static final long serialVersionUID = 3388685877147921107L;
    private static final StringBuffer2 NULL = new StringBuffer2("null");

    public StringBuffer2() {
        this(16);
    }

    public StringBuffer2(int length) {
        this.value = new char[length];
        this.shared = false;
    }

    public StringBuffer2(String str) {
        this(str.length());
        this.append(str);
    }

    public StringBuffer2(StringBuffer2 str) {
        this(str.length());
        this.append(str);
    }

    public int length() {
        return this.count;
    }

    public int capacity() {
        return this.value.length;
    }

    private final void copy() {
        char[] newValue = new char[this.value.length];
        System.arraycopy(this.value, 0, newValue, 0, this.count);
        this.value = newValue;
        this.shared = false;
    }

    public void ensureCapacity(int minimumCapacity) {
        if (minimumCapacity > this.value.length) {
            this.expandCapacity(minimumCapacity);
        }
    }

    private void expandCapacity(int minimumCapacity) {
        int newCapacity = (this.value.length + 1) * 2;
        if (newCapacity < 0) {
            newCapacity = Integer.MAX_VALUE;
        } else if (minimumCapacity > newCapacity) {
            newCapacity = minimumCapacity;
        }
        char[] newValue = new char[newCapacity];
        System.arraycopy(this.value, 0, newValue, 0, this.count);
        this.value = newValue;
        this.shared = false;
    }

    public void setLength(int newLength) {
        if (newLength < 0) {
            throw new StringIndexOutOfBoundsException(newLength);
        }
        if (newLength > this.value.length) {
            this.expandCapacity(newLength);
        }
        if (this.count < newLength) {
            if (this.shared) {
                this.copy();
            }
            while (this.count < newLength) {
                this.value[this.count] = '\u0000';
                ++this.count;
            }
        } else {
            this.count = newLength;
            if (this.shared && newLength > 0) {
                this.copy();
            }
        }
        this.hash = 0;
    }

    public char charAt(int index) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.value[index];
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        if (srcBegin < 0) {
            throw new StringIndexOutOfBoundsException(srcBegin);
        }
        if (srcEnd < 0 || srcEnd > this.count) {
            throw new StringIndexOutOfBoundsException(srcEnd);
        }
        if (srcBegin > srcEnd) {
            throw new StringIndexOutOfBoundsException("srcBegin > srcEnd");
        }
        System.arraycopy(this.value, srcBegin, dst, dstBegin, srcEnd - srcBegin);
    }

    public void setCharAt(int index, char ch) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        if (this.shared) {
            this.copy();
        }
        this.value[index] = ch;
        this.hash = 0;
    }

    public StringBuffer2 append(Object obj) {
        return this.append(String.valueOf(obj));
    }

    public StringBuffer2 append(String str) {
        int len;
        int newcount;
        if (str == null) {
            str = String.valueOf(str);
        }
        if ((newcount = this.count + (len = str.length())) > this.value.length) {
            this.expandCapacity(newcount);
        }
        str.getChars(0, len, this.value, this.count);
        this.count = newcount;
        return this;
    }

    public StringBuffer2 append(StringBuffer2 sb) {
        int len;
        int newcount;
        if (sb == null) {
            sb = NULL;
        }
        if ((newcount = this.count + (len = sb.length())) > this.value.length) {
            this.expandCapacity(newcount);
        }
        sb.getChars(0, len, this.value, this.count);
        this.count = newcount;
        return this;
    }

    public StringBuffer2 append(char[] str) {
        int len = str.length;
        int newcount = this.count + len;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        }
        System.arraycopy(str, 0, this.value, this.count, len);
        this.count = newcount;
        return this;
    }

    public StringBuffer2 append(char[] str, int offset, int len) {
        int newcount = this.count + len;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        }
        System.arraycopy(str, offset, this.value, this.count, len);
        this.count = newcount;
        return this;
    }

    public StringBuffer2 append(boolean b) {
        return this.append(String.valueOf(b));
    }

    public StringBuffer2 append(char c) {
        int newcount = this.count + 1;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        }
        this.value[this.count++] = c;
        this.hash = 0;
        return this;
    }

    public StringBuffer2 append(int i) {
        return this.append(String.valueOf(i));
    }

    public StringBuffer2 append(long l) {
        return this.append(String.valueOf(l));
    }

    public StringBuffer2 append(float f) {
        return this.append(String.valueOf(f));
    }

    public StringBuffer2 append(double d) {
        return this.append(String.valueOf(d));
    }

    public StringBuffer2 delete(int start, int end) {
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (end > this.count) {
            end = this.count;
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException();
        }
        int len = end - start;
        if (len > 0) {
            if (this.shared) {
                this.copy();
            }
            System.arraycopy(this.value, start + len, this.value, start, this.count - end);
            this.count -= len;
        }
        return this;
    }

    public StringBuffer2 deleteCharAt(int index) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        if (this.shared) {
            this.copy();
        }
        System.arraycopy(this.value, index + 1, this.value, index, this.count - index - 1);
        --this.count;
        return this;
    }

    public StringBuffer2 replace(int start, int end, String str) {
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (end > this.count) {
            end = this.count;
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException();
        }
        int len = str.length();
        int newCount = this.count + len - (end - start);
        if (newCount > this.value.length) {
            this.expandCapacity(newCount);
        } else if (this.shared) {
            this.copy();
        }
        System.arraycopy(this.value, end, this.value, start + len, this.count - end);
        str.getChars(0, len, this.value, start);
        this.count = newCount;
        return this;
    }

    public String substring(int start) {
        return this.substring(start, this.count);
    }

    public CharSequence subSequence(int start, int end) {
        return this.substring(start, end);
    }

    public String substring(int start, int end) {
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (end > this.count) {
            throw new StringIndexOutOfBoundsException(end);
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException(end - start);
        }
        return new String(this.value, start, end - start);
    }

    public StringBuffer2 insert(int index, char[] str, int offset, int len) {
        if (index < 0 || index > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        if (offset < 0 || offset + len < 0 || offset + len > str.length) {
            throw new StringIndexOutOfBoundsException(offset);
        }
        if (len < 0) {
            throw new StringIndexOutOfBoundsException(len);
        }
        int newCount = this.count + len;
        if (newCount > this.value.length) {
            this.expandCapacity(newCount);
        } else if (this.shared) {
            this.copy();
        }
        System.arraycopy(this.value, index, this.value, index + len, this.count - index);
        System.arraycopy(str, offset, this.value, index, len);
        this.count = newCount;
        return this;
    }

    public StringBuffer2 insert(int offset, Object obj) {
        return this.insert(offset, String.valueOf(obj));
    }

    public StringBuffer2 insert(int offset, String str) {
        int len;
        int newcount;
        if (offset < 0 || offset > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        if (str == null) {
            str = String.valueOf(str);
        }
        if ((newcount = this.count + (len = str.length())) > this.value.length) {
            this.expandCapacity(newcount);
        } else if (this.shared) {
            this.copy();
        }
        System.arraycopy(this.value, offset, this.value, offset + len, this.count - offset);
        str.getChars(0, len, this.value, offset);
        this.count = newcount;
        return this;
    }

    public StringBuffer2 insert(int offset, char[] str) {
        if (offset < 0 || offset > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        int len = str.length;
        int newcount = this.count + len;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        } else if (this.shared) {
            this.copy();
        }
        System.arraycopy(this.value, offset, this.value, offset + len, this.count - offset);
        System.arraycopy(str, 0, this.value, offset, len);
        this.count = newcount;
        return this;
    }

    public StringBuffer2 insert(int offset, boolean b) {
        return this.insert(offset, String.valueOf(b));
    }

    public StringBuffer2 insert(int offset, char c) {
        int newcount = this.count + 1;
        if (newcount > this.value.length) {
            this.expandCapacity(newcount);
        } else if (this.shared) {
            this.copy();
        }
        System.arraycopy(this.value, offset, this.value, offset + 1, this.count - offset);
        this.value[offset] = c;
        this.count = newcount;
        this.hash = 0;
        return this;
    }

    public StringBuffer2 insert(int offset, int i) {
        return this.insert(offset, String.valueOf(i));
    }

    public StringBuffer2 insert(int offset, long l) {
        return this.insert(offset, String.valueOf(l));
    }

    public StringBuffer2 insert(int offset, float f) {
        return this.insert(offset, String.valueOf(f));
    }

    public StringBuffer2 insert(int offset, double d) {
        return this.insert(offset, String.valueOf(d));
    }

    public int lastIndexOf(char c, int from) {
        int i = Math.min(from + 1, this.length());
        while (i-- != 0) {
            if (this.value[i] != c) continue;
            return i;
        }
        return -1;
    }

    public StringBuffer2 reverse() {
        if (this.shared) {
            this.copy();
        }
        int n = this.count - 1;
        for (int j = n - 1 >> 1; j >= 0; --j) {
            char temp = this.value[j];
            this.value[j] = this.value[n - j];
            this.value[n - j] = temp;
        }
        this.hash = 0;
        return this;
    }

    public String toString() {
        return new String(this.value, 0, this.count);
    }

    void setShared() {
        this.shared = true;
    }

    public char[] getValue() {
        return this.value;
    }

    public int getCount() {
        return this.count;
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.value = (char[])this.value.clone();
        this.shared = false;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            int off = 0;
            char[] val = this.value;
            int len = this.count;
            for (int i = 0; i < len; ++i) {
                h = 31 * h + val[off++];
            }
            this.hash = h;
        }
        return h;
    }

    public boolean equals(Object anObject) {
        int n;
        CharSequence anotherString;
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof StringBuffer2) {
            anotherString = (StringBuffer2)anObject;
            n = this.count;
            if (n == ((StringBuffer2)anotherString).count) {
                char[] v1 = this.value;
                char[] v2 = ((StringBuffer2)anotherString).value;
                int i = 0;
                int j = 0;
                while (n-- != 0) {
                    if (v1[i++] == v2[j++]) continue;
                    return false;
                }
                return true;
            }
        }
        if (anObject instanceof String && (n = this.count) == ((String)(anotherString = (String)anObject)).length()) {
            int i = 0;
            int j = 0;
            while (n-- != 0) {
                if (this.value[i++] == ((String)anotherString).charAt(j++)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean regionMatches(boolean ignoreCase, int toffset, StringBuffer2 other, int ooffset, int len) {
        char[] ta = this.value;
        int to = 0 + toffset;
        char[] pa = other.value;
        int po = ooffset;
        if (ooffset < 0 || toffset < 0 || (long)toffset > (long)this.count - (long)len || (long)ooffset > (long)other.count - (long)len) {
            return false;
        }
        while (len-- > 0) {
            char u2;
            char u1;
            char c2;
            char c1;
            if ((c1 = ta[to++]) == (c2 = pa[po++]) || ignoreCase && ((u1 = Character.toUpperCase(c1)) == (u2 = Character.toUpperCase(c2)) || Character.toLowerCase(u1) == Character.toLowerCase(u2))) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIgnoreCase(StringBuffer2 anotherString) {
        return this == anotherString ? true : anotherString != null && anotherString.count == this.count && this.regionMatches(true, 0, anotherString, 0, this.count);
    }

    public int compareTo(StringBuffer2 anotherString) {
        int len1 = this.count;
        int len2 = anotherString.count;
        int n = Math.min(len1, len2);
        char[] v1 = this.value;
        char[] v2 = anotherString.value;
        int i = 0;
        int j = 0;
        if (i == j) {
            int lim = n + i;
            for (int k = i; k < lim; ++k) {
                char c1 = v1[k];
                char c2 = v2[k];
                if (c1 == c2) continue;
                return c1 - c2;
            }
        } else {
            while (n-- != 0) {
                char c2;
                char c1;
                if ((c1 = v1[i++]) == (c2 = v2[j++])) continue;
                return c1 - c2;
            }
        }
        return len1 - len2;
    }

    public int compareTo(Object o) {
        return this.compareTo((StringBuffer2)o);
    }

    public void toLowerCase() {
        int n = this.count;
        char[] val = this.value;
        while (n-- != 0) {
            val[n] = Character.toLowerCase(val[n]);
        }
        this.hash = 0;
    }

    public void toUpperCase() {
        int n = this.count;
        char[] val = this.value;
        while (n-- != 0) {
            val[n] = Character.toUpperCase(val[n]);
        }
        this.hash = 0;
    }

    public void trim() {
        int len = this.count;
        int i = 0;
        int st = 0;
        char[] val = this.value;
        while (i < len && val[i] <= ' ') {
            ++i;
            ++st;
        }
        if (st != 0) {
            while (i < len && val[i] > ' ') {
                val[i - st] = val[i];
                ++i;
            }
        } else {
            while (i < len && val[i] > ' ') {
                ++i;
            }
        }
        if (st != 0 || this.count != i - st) {
            this.hash = 0;
        }
        this.count = i - st;
    }

    public char lastChar() {
        if (this.count == 0) {
            new StringIndexOutOfBoundsException(0);
        }
        return this.value[this.count - 1];
    }
}

