/*
 * Decompiled with CFR 0.152.
 */
package test.it.unimi.dsi.mg4j.document;

import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMaps;
import it.unimi.dsi.mg4j.document.AbstractDocumentCollection;
import it.unimi.dsi.mg4j.document.Document;
import it.unimi.dsi.mg4j.document.DocumentCollection;
import it.unimi.dsi.mg4j.document.DocumentFactory;
import it.unimi.dsi.mg4j.document.IdentityDocumentFactory;
import it.unimi.dsi.mg4j.io.FastByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.configuration.ConfigurationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringArrayDocumentCollection
extends AbstractDocumentCollection {
    public final String[] document;
    final DocumentFactory factory;

    public StringArrayDocumentCollection(String ... document) throws ConfigurationException {
        this.factory = new IdentityDocumentFactory(new String[]{"encoding=UTF-8"});
        this.document = document;
    }

    public StringArrayDocumentCollection(DocumentFactory factory, String ... document) {
        this.factory = factory;
        this.document = document;
    }

    @Override
    public int size() {
        return this.document.length;
    }

    @Override
    public Document document(int index) throws IOException {
        return this.factory.getDocument(this.stream(index), this.metadata(index));
    }

    @Override
    public InputStream stream(int index) throws IOException {
        return new FastByteArrayInputStream(this.document[index].getBytes("UTF-8"));
    }

    @Override
    public Reference2ObjectMap<Enum<?>, Object> metadata(int index) throws IOException {
        return Reference2ObjectMaps.EMPTY_MAP;
    }

    @Override
    public DocumentCollection copy() {
        return this;
    }

    @Override
    public DocumentFactory factory() {
        return this.factory;
    }
}

