/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.document;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.mg4j.document.AbstractDocument;
import it.unimi.dsi.mg4j.document.AbstractDocumentCollection;
import it.unimi.dsi.mg4j.document.AbstractDocumentFactory;
import it.unimi.dsi.mg4j.document.AbstractDocumentIterator;
import it.unimi.dsi.mg4j.document.Document;
import it.unimi.dsi.mg4j.document.DocumentFactory;
import it.unimi.dsi.mg4j.document.DocumentIterator;
import it.unimi.dsi.mg4j.document.PropertyBasedDocumentFactory;
import it.unimi.dsi.mg4j.io.FastBufferedReader;
import it.unimi.dsi.mg4j.io.WordReader;
import it.unimi.dsi.mg4j.tool.Scan;
import it.unimi.dsi.mg4j.util.Fast;
import it.unimi.dsi.mg4j.util.MutableString;
import it.unimi.dsi.mg4j.util.parser.callback.AnchorExtractor;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipDocumentCollection
extends AbstractDocumentCollection
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Fast.getLogger(ZipDocumentCollection.class);
    private static final boolean DEBUG = false;
    private final String zipFilename;
    private transient ZipFile zipFile;
    private final DocumentFactory underlyingFactory;
    private transient DocumentFactory factory;
    private final int numberOfDocuments;
    private final boolean exact;

    public ZipDocumentCollection(String zipFilename, DocumentFactory underlyingFactory, int numberOfDocuments, boolean exact) throws IOException {
        this.zipFilename = zipFilename;
        this.underlyingFactory = underlyingFactory;
        this.numberOfDocuments = numberOfDocuments;
        this.exact = exact;
        this.zipFile = new ZipFile(new File(zipFilename));
        this.factory = new ZipFactory(exact, underlyingFactory);
    }

    @Override
    public ZipDocumentCollection copy() {
        try {
            return new ZipDocumentCollection(this.zipFilename, this.underlyingFactory, this.numberOfDocuments, this.exact);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Object readResolve() throws IOException {
        super.close();
        return new ZipDocumentCollection(this.zipFilename, this.underlyingFactory, this.numberOfDocuments, this.exact);
    }

    @Override
    public DocumentFactory factory() {
        return this.factory;
    }

    @Override
    public int size() {
        return this.numberOfDocuments;
    }

    private ZipEntry getEntry(int index) {
        this.ensureDocumentIndex(index);
        ZipEntry entry = this.zipFile.getEntry(Integer.toString(index));
        if (entry == null) {
            throw new NoSuchElementException("Failure retrieving entry " + index);
        }
        return entry;
    }

    @Override
    public Document document(int index) throws IOException {
        ZipEntry entry = this.getEntry(index);
        Reference2ObjectMap<Enum<?>, Object> metadata = this.metadata(index, entry);
        InputStream is = this.zipFile.getInputStream(entry);
        return this.factory.getDocument(is, metadata);
    }

    private Reference2ObjectMap<Enum<?>, Object> metadata(int index, ZipEntry entry) {
        if (entry == null) {
            entry = this.getEntry(index);
        }
        Reference2ObjectArrayMap metadata = new Reference2ObjectArrayMap(1);
        metadata.put((Object)PropertyBasedDocumentFactory.MetadataKeys.TITLE, (Object)entry.getComment());
        return metadata;
    }

    @Override
    public Reference2ObjectMap<Enum<?>, Object> metadata(int index) {
        return this.metadata(index, null);
    }

    @Override
    public InputStream stream(int index) throws IOException {
        ZipEntry entry = this.zipFile.getEntry(Integer.toString(index));
        entry.getComment();
        InputStream is = this.zipFile.getInputStream(entry);
        return is;
    }

    @Override
    public DocumentIterator iterator() {
        try {
            return new AbstractDocumentIterator(){
                final Reference2ObjectArrayMap<Enum<?>, Object> metadata = new Reference2ObjectArrayMap((Object[])new Enum[1], new Object[1]);
                ZipInputStream zis = new ZipInputStream(new FileInputStream(ZipDocumentCollection.access$100(ZipDocumentCollection.this).getName()));

                public Document nextDocument() throws IOException {
                    ZipEntry entry;
                    String name;
                    do {
                        if ((entry = this.zis.getNextEntry()) != null) continue;
                        return null;
                    } while (!Character.isDigit((name = entry.getName()).charAt(0)));
                    if (entry == null) {
                        return null;
                    }
                    String title = entry.getComment();
                    InputStream is = ZipDocumentCollection.this.zipFile.getInputStream(entry);
                    this.metadata.put((Object)PropertyBasedDocumentFactory.MetadataKeys.TITLE, (Object)title);
                    return ZipDocumentCollection.this.factory.getDocument(is, (Reference2ObjectMap<Enum<?>, Object>)this.metadata);
                }
            };
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.zipFile.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ZipFactory
    extends AbstractDocumentFactory {
        private static final long serialVersionUID = 1L;
        private final boolean exact;
        private final DocumentFactory underlyingFactory;

        protected ZipFactory(boolean exact, DocumentFactory underlyingFactory) {
            this.exact = exact;
            this.underlyingFactory = underlyingFactory;
        }

        @Override
        public ZipFactory copy() {
            return this;
        }

        @Override
        public int numberOfFields() {
            return this.underlyingFactory.numberOfFields();
        }

        @Override
        public String fieldName(int field) {
            this.ensureFieldIndex(field);
            return this.underlyingFactory.fieldName(field);
        }

        @Override
        public int fieldIndex(String fieldName) {
            return this.underlyingFactory.fieldIndex(fieldName);
        }

        @Override
        public DocumentFactory.FieldType fieldType(int field) {
            this.ensureFieldIndex(field);
            return this.underlyingFactory.fieldType(field);
        }

        @Override
        public Document getDocument(final InputStream rawContent, final Reference2ObjectMap<Enum<?>, Object> metadata) throws IOException {
            return new AbstractDocument(){
                int nextFieldToRead = 0;
                final MutableString uri = new MutableString();
                {
                    this.uri.readSelfDelimUTF8(rawContent).compact();
                }

                public CharSequence title() {
                    return (CharSequence)metadata.get((Object)PropertyBasedDocumentFactory.MetadataKeys.TITLE);
                }

                public String toString() {
                    return ((Object)this.title()).toString();
                }

                public CharSequence uri() {
                    return this.uri;
                }

                private void skipOneField() throws IOException, ClassNotFoundException {
                    switch (ZipFactory.this.fieldType(this.nextFieldToRead)) {
                        case TEXT: {
                            MutableString word = new MutableString();
                            MutableString nonWord = new MutableString();
                            do {
                                word.readSelfDelimUTF8(rawContent);
                                if (!ZipFactory.this.exact) continue;
                                nonWord.readSelfDelimUTF8(rawContent);
                            } while (word.length() > 0 || ZipFactory.this.exact && nonWord.length() > 0);
                            break;
                        }
                        case VIRTUAL: {
                            MutableString dummy = new MutableString();
                            int nfrag = Integer.parseInt(dummy.readSelfDelimUTF8(rawContent).toString());
                            for (int i = 0; i < 2 * nfrag; ++i) {
                                dummy.readSelfDelimUTF8(rawContent);
                            }
                            break;
                        }
                        default: {
                            new ObjectInputStream(rawContent).readObject();
                        }
                    }
                    ++this.nextFieldToRead;
                }

                private void skipToField(int field) throws IOException, ClassNotFoundException {
                    if (this.nextFieldToRead > field) {
                        throw new IllegalStateException("Trying to skip to field " + field + " after " + this.nextFieldToRead);
                    }
                    while (this.nextFieldToRead < field) {
                        this.skipOneField();
                    }
                }

                public Object content(final int field) {
                    ZipFactory.this.ensureFieldIndex(field);
                    Object result = null;
                    try {
                        this.skipToField(field);
                        if (ZipFactory.this.fieldType(this.nextFieldToRead) == DocumentFactory.FieldType.VIRTUAL) {
                            int nfrag = Integer.parseInt(new MutableString().readSelfDelimUTF8(rawContent).toString());
                            MutableString doc = new MutableString();
                            MutableString text = new MutableString();
                            Object[] fragArray = new Scan.VirtualDocumentFragment[nfrag];
                            for (int i = 0; i < nfrag; ++i) {
                                doc.readSelfDelimUTF8(rawContent);
                                text.readSelfDelimUTF8(rawContent);
                                fragArray[i] = new AnchorExtractor.Anchor(doc.copy(), text.copy());
                            }
                            result = new ObjectArrayList(fragArray);
                        } else if (ZipFactory.this.fieldType(this.nextFieldToRead) != DocumentFactory.FieldType.TEXT) {
                            result = new ObjectInputStream(rawContent).readObject();
                            ++this.nextFieldToRead;
                        } else {
                            result = new Reader(){
                                FastBufferedReader fbr = null;
                                int f = field;

                                public void close() {
                                }

                                public int read(char[] cbuf, int off, int len) throws IOException {
                                    if (this.fbr == null) {
                                        MutableString text = new MutableString();
                                        MutableString word = new MutableString();
                                        MutableString nonWord = new MutableString();
                                        do {
                                            text.append(word.readSelfDelimUTF8(rawContent));
                                            if (!ZipFactory.this.exact) continue;
                                            text.append(nonWord.readSelfDelimUTF8(rawContent));
                                        } while (word.length() > 0 || ZipFactory.this.exact && nonWord.length() > 0);
                                        this.fbr = new FastBufferedReader(text);
                                        ++nextFieldToRead;
                                    }
                                    return this.fbr.read(cbuf, off, len);
                                }
                            };
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                    return result;
                }

                public WordReader wordReader(int field) {
                    ZipFactory.this.ensureFieldIndex(field);
                    try {
                        this.skipToField(field);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    switch (ZipFactory.this.fieldType(field)) {
                        case TEXT: {
                            return new WordReader(){
                                private static final long serialVersionUID = 1L;

                                public boolean next(MutableString word, MutableString nonWord) throws IOException {
                                    boolean goOn;
                                    try {
                                        word.readSelfDelimUTF8(rawContent);
                                    }
                                    catch (EOFException e) {
                                        return false;
                                    }
                                    nonWord.length(0);
                                    if (ZipFactory.this.exact) {
                                        try {
                                            nonWord.readSelfDelimUTF8(rawContent);
                                        }
                                        catch (EOFException e) {
                                            return true;
                                        }
                                    }
                                    boolean bl = goOn = word.length() != 0 || ZipFactory.this.exact && nonWord.length() != 0;
                                    if (!goOn) {
                                        ++nextFieldToRead;
                                    }
                                    return goOn;
                                }

                                public WordReader setReader(Reader reader) {
                                    return this;
                                }

                                public WordReader copy() {
                                    throw new UnsupportedOperationException();
                                }
                            };
                        }
                        case VIRTUAL: {
                            return new FastBufferedReader();
                        }
                    }
                    return null;
                }
            };
        }
    }
}

