/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.index;

import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMaps;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import it.unimi.dsi.mg4j.index.AbstractIndexIterator;
import it.unimi.dsi.mg4j.index.AbstractIndexReader;
import it.unimi.dsi.mg4j.index.BitStreamHPIndex;
import it.unimi.dsi.mg4j.index.CompressionFlags;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.index.IndexIterator;
import it.unimi.dsi.mg4j.index.payload.Payload;
import it.unimi.dsi.mg4j.io.InputBitStream;
import it.unimi.dsi.mg4j.search.Interval;
import it.unimi.dsi.mg4j.search.IntervalIterator;
import it.unimi.dsi.mg4j.search.IntervalIterators;
import it.unimi.dsi.mg4j.util.Fast;
import java.io.IOException;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class BitStreamHPIndexReader
extends AbstractIndexReader {
    private static final Logger LOGGER = Fast.getLogger(BitStreamHPIndexReader.class);
    private static final boolean ASSERTS = false;
    private static final boolean DEBUG = false;
    private static final boolean COOKIES = false;
    protected final BitStreamHPIndex index;
    protected final BitStreamHPIndexReaderIndexIterator indexIterator;

    public BitStreamHPIndexReader(BitStreamHPIndex index, InputBitStream ibs, InputBitStream positions) {
        this.index = index;
        this.indexIterator = new BitStreamHPIndexReaderIndexIterator(this, ibs, positions);
    }

    private IndexIterator documents(CharSequence term, int termNumber) throws IOException {
        this.indexIterator.term(term);
        this.indexIterator.position(termNumber);
        return this.indexIterator;
    }

    public IndexIterator documents(int term) throws IOException {
        return this.documents(null, term);
    }

    public IndexIterator documents(CharSequence term) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("This " + this.getClass().getSimpleName() + " has been closed");
        }
        if (this.index.termMap != null) {
            int termIndex = this.index.termMap.getNumber(term);
            if (termIndex == -1) {
                return this.index.emptyIndexIterator;
            }
            return this.documents(term, termIndex);
        }
        throw new UnsupportedOperationException("Index " + this.index + " has no term map");
    }

    public IndexIterator nextIterator() throws IOException {
        return this.indexIterator.advance();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.index + "]";
    }

    public void close() throws IOException {
        super.close();
        this.indexIterator.ibs.close();
        this.indexIterator.positions.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class BitStreamHPIndexReaderIndexIterator
    extends AbstractIndexIterator
    implements IndexIterator {
        private final BitStreamHPIndexReader parent;
        protected final BitStreamHPIndex index;
        protected final InputBitStream ibs;
        private final InputBitStream positions;
        private final IndexIntervalIterator intervalIterator;
        private final Reference2ReferenceMap<Index, IntervalIterator> singletonIntervalIterator;
        private final Index keyIndex;
        protected final CompressionFlags.Coding pointerCoding;
        protected final CompressionFlags.Coding countCoding;
        protected final CompressionFlags.Coding positionCoding;
        protected int b;
        protected int log2b;
        protected int term = -1;
        protected int frequency;
        protected boolean hasPointers;
        protected int count;
        protected int currentDocument;
        protected int numberOfDocumentRecord;
        protected int state;
        public final int height;
        public final int quantum;
        public final int quantumModuloMask;
        public final int quantumDivisionShift;
        private int maxh;
        private int s;
        private int lowest;
        private int w;
        public final int wModuloMask;
        public final int wDivisionShift;
        private int[] towerTopB;
        private int[] towerTopLog2B;
        private int[] towerLowerB;
        private int[] towerLowerLog2B;
        private int[] pointerPrediction;
        private long[] bitSkip;
        private long[] positionsBitSkip;
        private int[] pointerSkip;
        private long readBitsAtLastSkipTower;
        private int pointerAtLastSkipTower;
        private int positionsToReadToReachCurrentPosition;
        private long positionsBitsOffset;
        private long lastPositionsIncrement;
        private int quantumBitLength;
        private int positionsQuantumBitLength;
        private int entryBitLength;
        protected static final int BEFORE_TOWER = 0;
        protected static final int BEFORE_COUNT = 1;
        protected static final int BEFORE_POINTER = 2;
        protected boolean positionsUnread;
        protected int[] positionCache = new int[16];
        protected long lastPositionsOffset;
        private long positionsLength;

        public BitStreamHPIndexReaderIndexIterator(BitStreamHPIndexReader parent, InputBitStream ibs, InputBitStream positions) {
            this.parent = parent;
            this.ibs = ibs;
            this.positions = positions;
            this.index = parent.index;
            this.keyIndex = this.index.keyIndex;
            this.pointerCoding = this.index.pointerCoding;
            this.countCoding = this.index.countCoding;
            this.positionCoding = this.index.positionCoding;
            this.intervalIterator = this.index.hasPositions ? new IndexIntervalIterator() : null;
            this.singletonIntervalIterator = this.index.hasPositions ? Reference2ReferenceMaps.singleton((Object)this.keyIndex, (Object)this.intervalIterator) : null;
            this.quantum = this.index.quantum;
            this.quantumModuloMask = this.quantum - 1;
            this.quantumDivisionShift = Fast.mostSignificantBit(this.quantum);
            this.height = this.index.height;
            this.w = (1 << this.height) * this.quantum;
            this.wModuloMask = this.w - 1;
            this.wDivisionShift = Fast.mostSignificantBit(this.w);
            this.bitSkip = new long[this.height + 1];
            this.positionsBitSkip = new long[this.height + 1];
            this.pointerSkip = new int[this.height + 1];
            this.towerTopB = new int[this.height + 1];
            this.towerTopLog2B = new int[this.height + 1];
            this.towerLowerB = new int[this.height + 1];
            this.towerLowerLog2B = new int[this.height + 1];
            this.pointerPrediction = new int[this.height + 1];
        }

        protected void position(int term) throws IOException {
            if (term == 0) {
                this.ibs.position(0L);
                this.ibs.readBits(0L);
                this.lastPositionsOffset = this.ibs.readLongDelta();
                this.positions.position(0L);
            } else {
                if (this.index.offsets == null) {
                    throw new IllegalStateException("You cannot position an index without offsets");
                }
                this.ibs.position(this.index.offsets.getLong(term));
                this.ibs.readBits(this.index.offsets.getLong(term));
                this.lastPositionsOffset = this.ibs.readLongDelta();
                this.positions.position(this.lastPositionsOffset);
            }
            this.positions.readBits(0L);
            this.term = term;
            this.readFrequency();
        }

        protected IndexIterator advance() throws IOException {
            if (this.term == this.index.numberOfTerms - 1) {
                return null;
            }
            if (this.term != -1) {
                this.skipTo(Integer.MAX_VALUE);
                this.nextDocument();
                this.positionsUnread = false;
            }
            long nextPositionsOffset = this.ibs.readLongDelta();
            this.positions.skip(nextPositionsOffset - this.lastPositionsOffset - this.positions.readBits());
            this.lastPositionsOffset = nextPositionsOffset;
            this.positions.readBits(0L);
            ++this.term;
            this.readFrequency();
            return this;
        }

        private void readFrequency() throws IOException {
            switch (this.index.frequencyCoding) {
                case GAMMA: {
                    this.frequency = this.ibs.readGamma() + 1;
                    break;
                }
                case SHIFTED_GAMMA: {
                    this.frequency = this.ibs.readShiftedGamma() + 1;
                    break;
                }
                case DELTA: {
                    this.frequency = this.ibs.readDelta() + 1;
                    break;
                }
                default: {
                    throw new IllegalStateException("The required frequency coding (" + (Object)((Object)this.index.frequencyCoding) + ") is not supported.");
                }
            }
            boolean bl = this.hasPointers = this.frequency < this.index.numberOfDocuments;
            if (this.pointerCoding == CompressionFlags.Coding.GOLOMB && this.hasPointers) {
                this.b = Fast.golombModulus(this.frequency, this.index.numberOfDocuments);
                this.log2b = Fast.mostSignificantBit(this.b);
            }
            this.entryBitLength = -1;
            this.positionsQuantumBitLength = -1;
            this.quantumBitLength = -1;
            this.lowest = Integer.MAX_VALUE;
            long pointerQuantumSigma = Fast.quantumSigma(this.frequency, this.index.numberOfDocuments, this.quantum);
            for (int i = Math.min(this.height, Fast.mostSignificantBit(this.frequency >> this.quantumDivisionShift)); i >= 0; --i) {
                this.towerTopB[i] = Fast.gaussianGolombModulus(pointerQuantumSigma, i + 1);
                this.towerTopLog2B[i] = Fast.mostSignificantBit(this.towerTopB[i]);
                this.towerLowerB[i] = Fast.gaussianGolombModulus(pointerQuantumSigma, i);
                this.towerLowerLog2B[i] = Fast.mostSignificantBit(this.towerLowerB[i]);
                this.pointerPrediction[i] = (int)(((long)this.quantum * (1L << i) * (long)this.index.numberOfDocuments + (long)(this.frequency / 2)) / (long)this.frequency);
            }
            this.count = -1;
            this.currentDocument = -1;
            this.numberOfDocumentRecord = -1;
            this.positionsBitsOffset = 0L;
            this.positionsBitSkip[0] = 0L;
            this.positionsToReadToReachCurrentPosition = 0;
            this.lastPositionsIncrement = 0L;
            this.state = 2;
        }

        @Override
        public Index index() {
            return this.keyIndex;
        }

        @Override
        public int frequency() {
            return this.frequency;
        }

        private void ensureCurrentDocument() {
            if (this.currentDocument < 0) {
                throw new IllegalStateException("nextDocument() has never been called for (term=" + this.term + ")");
            }
            if (this.currentDocument == Integer.MAX_VALUE) {
                throw new IllegalStateException("This reader is positioned beyond the end of list of (term=" + this.term + ")");
            }
        }

        private boolean endOfList() {
            return this.numberOfDocumentRecord >= this.frequency - 1;
        }

        @Override
        public int document() {
            return this.currentDocument;
        }

        @Override
        public Payload payload() throws IOException {
            throw new UnsupportedOperationException("This index (" + this.index + ") does not contain payloads");
        }

        @Override
        public int count() throws IOException {
            if (this.count != -1) {
                return this.count;
            }
            if (this.state == 0) {
                this.readTower();
            }
            this.state = 2;
            switch (this.countCoding) {
                case UNARY: {
                    this.count = this.ibs.readUnary() + 1;
                    break;
                }
                case SHIFTED_GAMMA: {
                    this.count = this.ibs.readShiftedGamma() + 1;
                    break;
                }
                case GAMMA: {
                    this.count = this.ibs.readGamma() + 1;
                    break;
                }
                case DELTA: {
                    this.count = this.ibs.readDelta() + 1;
                    break;
                }
                default: {
                    throw new IllegalStateException("The required count coding (" + (Object)((Object)this.countCoding) + ") is not supported.");
                }
            }
            return this.count;
        }

        protected void updatePositionCache() throws IOException {
            this.positionsUnread = false;
            this.count();
            if (this.positionsBitsOffset > this.positions.readBits()) {
                this.positions.skip(this.positionsBitsOffset - this.positions.readBits());
            }
            if (this.positionsToReadToReachCurrentPosition > 0) {
                switch (this.positionCoding) {
                    case SHIFTED_GAMMA: {
                        this.positions.skipShiftedGammas(this.positionsToReadToReachCurrentPosition);
                        break;
                    }
                    case GAMMA: {
                        this.positions.skipGammas(this.positionsToReadToReachCurrentPosition);
                        break;
                    }
                    case DELTA: {
                        this.positions.skipDeltas(this.positionsToReadToReachCurrentPosition);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("The required position coding (" + (Object)((Object)this.positionCoding) + ") is not supported.");
                    }
                }
            }
            this.positionsToReadToReachCurrentPosition = -this.count;
            if (this.count > this.positionCache.length) {
                this.positionCache = new int[Math.max(this.positionCache.length * 2, this.count)];
            }
            int[] occ = this.positionCache;
            switch (this.positionCoding) {
                case SHIFTED_GAMMA: {
                    this.positions.readShiftedGammas(occ, this.count);
                    for (int i = 1; i < this.count; ++i) {
                        int n = i;
                        occ[n] = occ[n] + (occ[i - 1] + 1);
                    }
                    return;
                }
                case GAMMA: {
                    this.positions.readGammas(occ, this.count);
                    for (int i = 1; i < this.count; ++i) {
                        int n = i;
                        occ[n] = occ[n] + (occ[i - 1] + 1);
                    }
                    return;
                }
                case DELTA: {
                    this.positions.readDeltas(occ, this.count);
                    for (int i = 1; i < this.count; ++i) {
                        int n = i;
                        occ[n] = occ[n] + (occ[i - 1] + 1);
                    }
                    return;
                }
            }
            throw new IllegalStateException("The required position coding (" + (Object)((Object)this.index.positionCoding) + ") is not supported.");
        }

        @Override
        public IntIterator positions() throws IOException {
            if (this.positionsUnread) {
                this.updatePositionCache();
            }
            return IntIterators.wrap((int[])this.positionCache, (int)0, (int)this.count);
        }

        @Override
        public int[] positionArray() throws IOException {
            if (this.positionsUnread) {
                this.updatePositionCache();
            }
            return this.positionCache;
        }

        @Override
        public int positions(int[] position) throws IOException {
            if (this.positionsUnread) {
                this.updatePositionCache();
            }
            if (position.length < this.count) {
                return -this.count;
            }
            int i = this.count;
            while (i-- != 0) {
                position[i] = this.positionCache[i];
            }
            return this.count;
        }

        @Override
        public int nextDocument() throws IOException {
            block19: {
                block18: {
                    if (this.state != 2) {
                        if (this.state == 0) {
                            this.readTower();
                        }
                        if (this.state == 1) {
                            switch (this.countCoding) {
                                case UNARY: {
                                    this.count = this.ibs.readUnary() + 1;
                                    break;
                                }
                                case SHIFTED_GAMMA: {
                                    this.count = this.ibs.readShiftedGamma() + 1;
                                    break;
                                }
                                case GAMMA: {
                                    this.count = this.ibs.readGamma() + 1;
                                    break;
                                }
                                case DELTA: {
                                    this.count = this.ibs.readDelta() + 1;
                                    break;
                                }
                                default: {
                                    throw new IllegalStateException("The required count coding (" + (Object)((Object)this.countCoding) + ") is not supported.");
                                }
                            }
                            this.state = 2;
                        }
                    }
                    if (this.endOfList()) {
                        return -1;
                    }
                    if (!this.hasPointers) break block18;
                    switch (this.pointerCoding) {
                        case SHIFTED_GAMMA: {
                            this.currentDocument += this.ibs.readShiftedGamma() + 1;
                            break block19;
                        }
                        case GAMMA: {
                            this.currentDocument += this.ibs.readGamma() + 1;
                            break block19;
                        }
                        case DELTA: {
                            this.currentDocument += this.ibs.readDelta() + 1;
                            break block19;
                        }
                        case GOLOMB: {
                            this.currentDocument += this.ibs.readGolomb(this.b, this.log2b) + 1;
                            break block19;
                        }
                        default: {
                            throw new IllegalStateException("The required pointer coding (" + (Object)((Object)this.pointerCoding) + ") is not supported.");
                        }
                    }
                }
                ++this.currentDocument;
            }
            ++this.numberOfDocumentRecord;
            if ((this.numberOfDocumentRecord & this.quantumModuloMask) == 0) {
                this.state = 0;
                this.positionsToReadToReachCurrentPosition = 0;
            } else {
                this.state = 1;
                this.positionsToReadToReachCurrentPosition += this.count;
            }
            this.count = -1;
            this.positionsUnread = true;
            return this.currentDocument;
        }

        private void readTower() throws IOException {
            this.lastPositionsIncrement = this.maxh >= 0 ? this.positionsBitSkip[0] : 0L;
            this.readTower(-1);
            this.positionsBitsOffset += this.lastPositionsIncrement;
        }

        private void readTower(int pointer) throws IOException {
            int j;
            int towerLength = 0;
            long bitsAtTowerStart = 0L;
            boolean truncated = false;
            int cacheOffset = this.numberOfDocumentRecord & this.wModuloMask;
            int k = cacheOffset >> this.quantumDivisionShift;
            this.s = k == 0 ? this.height : Fast.leastSignificantBit(k);
            int cache = this.frequency - this.w * (this.numberOfDocumentRecord >> this.wDivisionShift);
            if (cache < this.w) {
                this.maxh = Fast.mostSignificantBit((cache >> this.quantumDivisionShift) - k);
                if (this.maxh < this.s) {
                    this.s = this.maxh;
                    truncated = true;
                } else {
                    truncated = false;
                }
            } else {
                cache = this.w;
                this.maxh = this.height;
                truncated = k == 0;
            }
            int i = this.s;
            if (this.s >= 0) {
                if (k == 0) {
                    if (this.quantumBitLength < 0) {
                        this.quantumBitLength = this.ibs.readDelta();
                        this.positionsQuantumBitLength = this.ibs.readDelta();
                        this.entryBitLength = this.ibs.readDelta();
                    } else {
                        this.quantumBitLength += Fast.nat2int(this.ibs.readDelta());
                        this.positionsQuantumBitLength += Fast.nat2int(this.ibs.readDelta());
                        this.entryBitLength += Fast.nat2int(this.ibs.readDelta());
                    }
                }
                if (this.s > 0) {
                    towerLength = this.entryBitLength * (this.s + 1) + Fast.nat2int(this.ibs.readDelta());
                }
                bitsAtTowerStart = this.ibs.readBits();
                if (truncated) {
                    this.pointerSkip[this.s] = Fast.nat2int(this.ibs.readGolomb(this.towerTopB[this.s], this.towerTopLog2B[this.s])) + this.pointerPrediction[this.s];
                    this.bitSkip[this.s] = (long)(this.quantumBitLength * (1 << this.s) + this.entryBitLength * ((1 << this.s + 1) - this.s - 2)) + Fast.nat2int(this.ibs.readLongDelta());
                    this.positionsBitSkip[this.s] = (long)(this.positionsQuantumBitLength * (1 << this.s)) + Fast.nat2int(this.ibs.readLongDelta());
                } else {
                    this.pointerSkip[this.s] = this.pointerSkip[this.s + 1] - (this.currentDocument - this.pointerAtLastSkipTower);
                    this.bitSkip[this.s] = this.bitSkip[this.s + 1] - (bitsAtTowerStart - this.readBitsAtLastSkipTower) - (long)towerLength;
                    this.positionsBitSkip[this.s] = this.positionsBitSkip[this.s + 1] - this.positionsBitSkip[this.s];
                }
                if (this.currentDocument + this.pointerSkip[i] > pointer) {
                    for (i = this.s - 1; i >= 0; --i) {
                        this.pointerSkip[i] = Fast.nat2int(this.ibs.readGolomb(this.towerLowerB[i], this.towerLowerLog2B[i])) + this.pointerSkip[i + 1] / 2;
                        this.bitSkip[i] = (this.bitSkip[i + 1] - (long)(this.entryBitLength * (i + 1))) / 2L - Fast.nat2int(this.ibs.readLongDelta());
                        this.positionsBitSkip[i] = this.positionsBitSkip[i + 1] / 2L - Fast.nat2int(this.ibs.readLongDelta());
                        if (this.currentDocument + this.pointerSkip[i] <= pointer) break;
                    }
                }
            }
            if (i > 0) {
                long fix = this.ibs.readBits() - bitsAtTowerStart;
                j = this.s;
                while (j >= i) {
                    int n = j--;
                    this.bitSkip[n] = this.bitSkip[n] + ((long)towerLength - fix);
                }
            } else {
                this.state = 1;
            }
            long deltaBits = this.ibs.readBits() - this.readBitsAtLastSkipTower;
            int deltaPointers = this.currentDocument - this.pointerAtLastSkipTower;
            j = Fast.mostSignificantBit(k ^ cache >> this.quantumDivisionShift);
            while (j >= this.s + 1) {
                int n = j;
                this.bitSkip[n] = this.bitSkip[n] - deltaBits;
                int n2 = j;
                this.positionsBitSkip[n2] = this.positionsBitSkip[n2] - this.lastPositionsIncrement;
                int n3 = j--;
                this.pointerSkip[n3] = this.pointerSkip[n3] - deltaPointers;
            }
            this.readBitsAtLastSkipTower = this.ibs.readBits();
            this.pointerAtLastSkipTower = this.currentDocument;
            this.lowest = i < 0 ? 0 : i;
        }

        @Override
        public int skipTo(int p) throws IOException {
            if (this.numberOfDocumentRecord == -1) {
                this.nextDocument();
            }
            if (this.currentDocument >= p) {
                return this.currentDocument;
            }
            if (this.state == 0) {
                this.lastPositionsIncrement = this.maxh >= 0 ? this.positionsBitSkip[0] : 0L;
                this.readTower(p);
                this.positionsBitsOffset += this.lastPositionsIncrement;
            }
            int[] pointerSkip = this.pointerSkip;
            while (this.maxh >= 0 && (this.lowest != 0 || this.pointerAtLastSkipTower + pointerSkip[0] <= p)) {
                int i;
                int cacheOffset = this.numberOfDocumentRecord & this.wModuloMask;
                int k = cacheOffset >> this.quantumDivisionShift;
                int top = Fast.mostSignificantBit(k ^ Math.min(this.w, this.frequency - this.numberOfDocumentRecord + cacheOffset) >> this.quantumDivisionShift);
                for (i = this.lowest; i <= top && this.pointerAtLastSkipTower + pointerSkip[i] <= p; ++i) {
                }
                if (--i < 0) break;
                this.ibs.skip(this.bitSkip[i] - (this.ibs.readBits() - this.readBitsAtLastSkipTower));
                this.lastPositionsIncrement = this.positionsBitSkip[i];
                this.positionsBitsOffset += this.lastPositionsIncrement;
                this.state = 0;
                this.currentDocument = pointerSkip[i] + this.pointerAtLastSkipTower;
                this.numberOfDocumentRecord += ((k & -(1 << i)) + (1 << i)) * this.quantum - cacheOffset;
                if (this.numberOfDocumentRecord == this.frequency) {
                    this.currentDocument = Integer.MAX_VALUE;
                    this.positionsUnread = false;
                    this.state = 2;
                } else {
                    this.positionsUnread = true;
                    this.readTower(p);
                }
                this.count = -1;
                this.positionsToReadToReachCurrentPosition = 0;
                if (!this.endOfList()) continue;
                return p == Integer.MAX_VALUE ? Integer.MAX_VALUE : this.currentDocument;
            }
            while (this.currentDocument < p) {
                if (this.nextDocument() != -1) continue;
                return Integer.MAX_VALUE;
            }
            return this.currentDocument;
        }

        @Override
        public void dispose() throws IOException {
            this.parent.close();
        }

        public boolean hasNext() {
            return !this.endOfList();
        }

        @Override
        public int nextInt() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                return this.nextDocument();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            return this.index + " [" + this.term + "]";
        }

        @Override
        public Reference2ReferenceMap<Index, IntervalIterator> intervalIterators() throws IOException {
            this.intervalIterator();
            return this.singletonIntervalIterator;
        }

        @Override
        public IntervalIterator intervalIterator() throws IOException {
            return this.intervalIterator(this.keyIndex);
        }

        @Override
        public IntervalIterator intervalIterator(Index index) throws IOException {
            if (index != this.keyIndex) {
                return IntervalIterators.TRUE;
            }
            this.intervalIterator.reset();
            return this.intervalIterator;
        }

        @Override
        public ReferenceSet<Index> indices() {
            return this.index.singletonSet;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class IndexIntervalIterator
        extends AbstractObjectIterator<Interval>
        implements IntervalIterator {
            int pos = -1;

            private IndexIntervalIterator() {
            }

            @Override
            public void reset() throws IOException {
                this.pos = -1;
                if (BitStreamHPIndexReaderIndexIterator.this.positionsUnread) {
                    BitStreamHPIndexReaderIndexIterator.this.updatePositionCache();
                }
            }

            @Override
            public boolean hasNext() {
                return this.pos < BitStreamHPIndexReaderIndexIterator.this.count - 1;
            }

            @Override
            public Interval next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return Interval.valueOf(BitStreamHPIndexReaderIndexIterator.this.positionCache[++this.pos]);
            }

            @Override
            public Interval nextInterval() {
                return this.pos < BitStreamHPIndexReaderIndexIterator.this.count - 1 ? Interval.valueOf(BitStreamHPIndexReaderIndexIterator.this.positionCache[++this.pos]) : null;
            }

            @Override
            public int extent() {
                return 1;
            }

            public String toString() {
                return BitStreamHPIndexReaderIndexIterator.this.index + ": " + BitStreamHPIndexReaderIndexIterator.this.term + "[doc=" + BitStreamHPIndexReaderIndexIterator.this.currentDocument + ", count=" + BitStreamHPIndexReaderIndexIterator.this.count + ", pos=" + this.pos + "]";
            }
        }
    }
}

