/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.search;

import it.unimi.dsi.fastutil.ints.IntHeapSemiIndirectPriorityQueue;
import it.unimi.dsi.fastutil.objects.ObjectHeapSemiIndirectPriorityQueue;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.search.AbstractCompositeDocumentIterator;
import it.unimi.dsi.mg4j.search.AbstractUnionDocumentIterator;
import it.unimi.dsi.mg4j.search.DocumentIterator;
import it.unimi.dsi.mg4j.search.DocumentIterators;
import it.unimi.dsi.mg4j.search.Interval;
import it.unimi.dsi.mg4j.search.IntervalIterator;
import it.unimi.dsi.mg4j.search.IntervalIterators;
import it.unimi.dsi.mg4j.search.Intervals;
import java.io.IOException;

public class OrDocumentIterator
extends AbstractUnionDocumentIterator
implements DocumentIterator {
    private static final boolean DEBUG = false;

    public static DocumentIterator getInstance(DocumentIterator ... documentIterator) throws IOException {
        if (documentIterator.length == 0) {
            return DocumentIterators.EMPTY_ITERATOR;
        }
        if (documentIterator.length == 1) {
            return documentIterator[0];
        }
        return new OrDocumentIterator(documentIterator);
    }

    protected OrDocumentIterator(DocumentIterator ... documentIterator) throws IOException {
        super(documentIterator);
    }

    protected IntervalIterator getComposedIntervalIterator(Index index) {
        return this.indexIterator == null ? new OrIntervalIterator(index) : new OrIndexIntervalIterator(index);
    }

    protected class OrIndexIntervalIterator
    extends AbstractCompositeDocumentIterator.AbstractCompositeIndexIntervalIterator
    implements IntervalIterator {
        private static final boolean DEBUG = false;
        private static final boolean ASSERTS = false;
        final Index index;
        private final IntHeapSemiIndirectPriorityQueue positionQueue;

        public OrIndexIntervalIterator(Index index) {
            super(OrDocumentIterator.this.n);
            this.index = index;
            this.positionQueue = new IntHeapSemiIndirectPriorityQueue(this.curr);
        }

        public void reset() throws IOException {
            this.positionQueue.clear();
            int i = OrDocumentIterator.this.computeFront();
            while (i-- != 0) {
                int k = OrDocumentIterator.this.front[i];
                if (OrDocumentIterator.this.indexIterator[k].index() != this.index) continue;
                this.position[k] = OrDocumentIterator.this.indexIterator[k].positionArray();
                this.count[k] = OrDocumentIterator.this.indexIterator[k].count();
                this.currPos[k] = 0;
                this.curr[k] = this.position[k][0];
                this.positionQueue.enqueue(k);
            }
            this.next = Interval.valueOf(this.curr[this.positionQueue.first()]);
        }

        public Interval nextInterval() {
            if (this.next != null) {
                Interval result = this.next;
                this.next = null;
                return result;
            }
            if (this.positionQueue.isEmpty()) {
                return null;
            }
            int first = this.positionQueue.first();
            int previous = this.curr[first];
            do {
                int n = first;
                this.currPos[n] = this.currPos[n] + 1;
                if (this.currPos[n] == this.count[first]) {
                    this.positionQueue.dequeue();
                    if (!this.positionQueue.isEmpty()) continue;
                    return null;
                }
                this.curr[first] = this.position[first][this.currPos[first]];
                this.positionQueue.changed();
            } while (this.curr[first = this.positionQueue.first()] == previous);
            return Interval.valueOf(this.curr[first]);
        }

        public int extent() {
            return 1;
        }
    }

    private class OrIntervalIterator
    extends AbstractCompositeDocumentIterator.AbstractCompositeIntervalIterator {
        final Index index;
        private ObjectHeapSemiIndirectPriorityQueue<Interval> intervalQueue;
        private int lastLeft;

        public OrIntervalIterator(Index index) {
            super(OrDocumentIterator.this.n);
            this.index = index;
            this.intervalQueue = new ObjectHeapSemiIndirectPriorityQueue((Object[])this.curr, Intervals.ENDS_BEFORE_OR_IS_SUFFIX);
        }

        public void reset() throws IOException {
            this.lastLeft = Integer.MIN_VALUE;
            this.next = null;
            this.intervalQueue.clear();
            int i = OrDocumentIterator.this.computeFront();
            while (i-- != 0) {
                int k = OrDocumentIterator.this.front[i];
                this.intervalIterator[k] = OrDocumentIterator.this.documentIterator[k].intervalIterator(this.index);
                if (this.intervalIterator[k] == IntervalIterators.TRUE || (this.curr[k] = this.intervalIterator[k].nextInterval()) == null) continue;
                this.intervalQueue.enqueue(k);
            }
        }

        public Interval nextInterval() throws IOException {
            int first;
            block4: {
                if (this.next != null) {
                    Interval result = this.next;
                    this.next = null;
                    return result;
                }
                if (this.intervalQueue.isEmpty()) {
                    return null;
                }
                while (true) {
                    first = this.intervalQueue.first();
                    if (this.curr[first].left > this.lastLeft) break block4;
                    this.curr[first] = this.intervalIterator[first].nextInterval();
                    if (this.curr[first] != null) {
                        this.intervalQueue.changed();
                        continue;
                    }
                    this.intervalQueue.dequeue();
                    if (this.intervalQueue.isEmpty()) break;
                }
                return null;
            }
            this.lastLeft = this.curr[first].left;
            return this.curr[first];
        }

        public int extent() {
            int s = Integer.MAX_VALUE;
            int i = OrDocumentIterator.this.computeFront();
            while (i-- != 0) {
                int k = OrDocumentIterator.this.front[i];
                int e = this.curr[k] != null ? this.intervalIterator[k].extent() : Integer.MAX_VALUE;
                if (e >= s) continue;
                s = e;
            }
            return s;
        }
    }
}

