/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.test;

import it.unimi.dsi.mg4j.io.FastBufferedReader;
import it.unimi.dsi.mg4j.util.MutableString;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Random;

public class FastBufferedReaderTest {
    private FastBufferedReaderTest() {
    }

    private static void fatal(String msg) {
        System.out.println(msg);
        System.exit(1);
    }

    private static void ensure(boolean cond, String msg) {
        if (cond) {
            return;
        }
        FastBufferedReaderTest.fatal(msg);
    }

    public static void main(String[] arg) throws IOException {
        String fileName = arg[0];
        MutableString ms = new MutableString();
        int l = (int)new File(fileName).length();
        FastBufferedReader br = new FastBufferedReader(new FileReader(fileName), 2);
        BufferedReader test = new BufferedReader(new FileReader(fileName));
        Random r = new Random();
        char[] b1 = new char[32768];
        char[] b2 = new char[32768];
        block6: while (true) {
            switch (r.nextInt(4)) {
                case 0: {
                    System.err.println("read()");
                    int a1 = br.read();
                    int a2 = test.read();
                    FastBufferedReaderTest.ensure(a1 == a2, "Buffered read() returned " + a1 + " instead of " + a2);
                    if (a1 != -1) break;
                    return;
                }
                case 1: {
                    int off = r.nextInt(b1.length);
                    int len = r.nextInt(b1.length - off + 1);
                    int a1 = br.read(b1, off, len);
                    int a2 = test.read(b2, off, len);
                    System.err.println("read(b, " + off + ", " + len + ")");
                    FastBufferedReaderTest.ensure(a1 == a2, "Buffered read(b, " + off + ", " + len + ") returned " + a1 + " instead of " + a2);
                    int i = off;
                    while (true) {
                        if (i >= off + len) continue block6;
                        FastBufferedReaderTest.ensure(b1[i] == b2[i], "Buffered read(b, " + off + ", " + len + ") has a mismatch at position " + i);
                        ++i;
                    }
                }
                case 2: {
                    int pos = r.nextInt(l / 2 + 1);
                    int a1 = (int)br.skip(pos);
                    int a2 = (int)test.skip(pos);
                    System.err.println("skip(" + pos + ")");
                    FastBufferedReaderTest.ensure(a1 == a2, "skip() returned " + a1 + " instead of " + a2);
                    break;
                }
                case 3: {
                    MutableString ms2 = br.readLine(ms);
                    String s = test.readLine();
                    System.err.println("readLine()");
                    FastBufferedReaderTest.ensure(s == null && ms2 == null || ms.equals(s), "readLine() returned " + ms + " instead of " + s);
                }
            }
        }
    }
}

