/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.ngs;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.Interval;
import edu.unc.genomics.ReadMapperTool;
import edu.unc.genomics.io.IntervalFileReader;
import java.io.IOException;
import java.util.Iterator;

public class BaseAlignCounts
extends ReadMapperTool {
    @Parameter(names={"-x", "--extend"}, description="Extend reads from 5' end (default = fragment length)")
    public Integer extend = -1;

    @Override
    public float[] compute(IntervalFileReader<? extends Interval> reader, Interval chunk) throws IOException {
        float[] count = new float[chunk.length()];
        int paddedStart = chunk.getStart();
        int paddedStop = chunk.getStop();
        if (this.extend != null && this.extend != -1) {
            paddedStart = Math.max(chunk.getStart() - this.extend - 1, 1);
            paddedStop = Math.min(chunk.getStop() + this.extend + 1, this.assembly.getChrLength(chunk.getChr()));
        }
        Iterator it = reader.query(chunk.getChr(), paddedStart, paddedStop);
        while (it.hasNext()) {
            Interval entry = (Interval)it.next();
            int entryStop = entry.getStop();
            if (this.extend != null && this.extend != -1) {
                entryStop = entry.isWatson() ? entry.getStart() + this.extend - 1 : entry.getStart() - this.extend + 1;
            }
            int low = Math.max(Math.min(entry.getStart(), entryStop), chunk.getStart());
            int high = Math.min(Math.max(entry.getStart(), entryStop), chunk.getStop());
            for (int i = low; i <= high; ++i) {
                int n = i - chunk.getStart();
                count[n] = count[n] + 1.0f;
            }
        }
        return count;
    }

    public static void main(String[] args) {
        new BaseAlignCounts().instanceMain(args);
    }
}

