/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.ngs;

import edu.unc.genomics.Interval;
import edu.unc.genomics.ReadMapperTool;
import edu.unc.genomics.io.IntervalFileReader;
import java.io.IOException;
import java.util.Iterator;

public class RollingReadLength
extends ReadMapperTool {
    @Override
    public float[] compute(IntervalFileReader<? extends Interval> reader, Interval chunk) throws IOException {
        int[] sum = new int[chunk.length()];
        int[] count = new int[chunk.length()];
        Iterator it = reader.query(chunk);
        while (it.hasNext()) {
            Interval entry = (Interval)it.next();
            int entryStart = Math.max(entry.low(), chunk.getStart());
            int entryStop = Math.min(entry.high(), chunk.getStop());
            for (int i = entryStart; i <= entryStop; ++i) {
                int n = i - chunk.getStart();
                sum[n] = sum[n] + entry.length();
                int n2 = i - chunk.getStart();
                count[n2] = count[n2] + 1;
            }
        }
        float[] avg = new float[chunk.length()];
        for (int i = 0; i < avg.length; ++i) {
            avg[i] = count[i] == 0 ? Float.NaN : (float)sum[i] / (float)count[i];
        }
        return avg;
    }

    public static void main(String[] args) {
        new RollingReadLength().instanceMain(args);
    }
}

