/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.nucleosomes;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.CommandLineToolException;
import edu.unc.genomics.Interval;
import edu.unc.genomics.ReadablePathValidator;
import edu.unc.genomics.io.IntervalFileReader;
import edu.unc.utils.Samtools;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import net.sf.picard.reference.FastaSequenceIndex;
import net.sf.picard.reference.FastaSequenceIndexEntry;
import net.sf.picard.reference.IndexedFastaSequenceFile;
import net.sf.picard.reference.ReferenceSequence;
import net.sf.samtools.util.StringUtil;
import org.apache.log4j.Logger;

public class SequencePreferences
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(SequencePreferences.class);
    @Parameter(names={"-i", "--input"}, description="Input file (reads/intervals)", required=true, validateWith=ReadablePathValidator.class)
    public Path inputFile;
    @Parameter(names={"-n", "--order"}, description="Order of frequencies to compute")
    public int order = 2;
    @Parameter(names={"-w", "--width"}, description="Distance from fragment center to count frequencies")
    public int width = 200;
    @Parameter(names={"-o", "--output"}, description="Output file", required=true)
    public Path outputFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws IOException {
        block25: {
            if (!IndexedFastaSequenceFile.canCreateIndexedFastaReader((File)this.inputFile.toFile())) {
                try {
                    Samtools.indexFasta(this.inputFile);
                }
                catch (Exception e) {
                    log.error((Object)"Error indexing FASTA file with samtools. Is samtools available in the PATH?");
                    throw new CommandLineToolException("Error indexing FASTA file with samtools");
                }
            }
            IndexedFastaSequenceFile fasta = new IndexedFastaSequenceFile(this.inputFile.toFile());
            Path indexFile = this.inputFile.resolveSibling(this.inputFile.getFileName() + ".fai");
            FastaSequenceIndex faidx = new FastaSequenceIndex(indexFile.toFile());
            try (IntervalFileReader reader = IntervalFileReader.autodetect((Path)this.inputFile);){
                for (FastaSequenceIndexEntry contig : faidx) {
                    log.debug((Object)("Processing FASTA entry " + contig.getContig() + " (length = " + contig.getSize() + ")"));
                    int start = 1;
                    while ((long)start <= contig.getSize()) {
                        int stop = start + 300000 - 1;
                        int paddedStart = Math.max(start - this.width, 1);
                        int paddedStop = (int)Math.min((long)(stop + this.width), contig.getSize());
                        Interval chunk = new Interval(contig.getContig(), start, stop);
                        log.debug((Object)("Processing chunk " + chunk));
                        ReferenceSequence seq = fasta.getSubsequenceAt(contig.getContig(), (long)paddedStart, (long)paddedStop);
                        String bases = StringUtil.bytesToString((byte[])seq.getBases());
                        Iterator it = reader.query(chunk);
                        while (it.hasNext()) {
                            Interval interval = (Interval)it.next();
                            int fragmentStart = interval.center() - this.width;
                            int fragmentStop = interval.center() + this.width;
                            if (fragmentStart < chunk.getStart() || fragmentStop > chunk.getStop()) continue;
                            for (int i = fragmentStart; i <= fragmentStop; ++i) {
                            }
                        }
                        start = stop + 1;
                    }
                }
            }
            PrintWriter writer = new PrintWriter(Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]));
            var5_6 = null;
            if (writer == null) break block25;
            if (var5_6 != null) {
                try {
                    writer.close();
                }
                catch (Throwable x2) {
                    var5_6.addSuppressed(x2);
                }
            } else {
                writer.close();
            }
        }
    }

    public static void main(String[] args) {
        new SequencePreferences().instanceMain(args);
    }
}

