/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.dna;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.CommandLineToolException;
import edu.unc.genomics.Interval;
import edu.unc.genomics.ReadablePathValidator;
import edu.unc.genomics.io.BedFileWriter;
import edu.unc.utils.Samtools;
import edu.unc.utils.SequenceUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import net.sf.picard.reference.FastaSequenceIndex;
import net.sf.picard.reference.FastaSequenceIndexEntry;
import net.sf.picard.reference.IndexedFastaSequenceFile;
import net.sf.picard.reference.ReferenceSequence;
import net.sf.samtools.util.SequenceUtil;
import net.sf.samtools.util.StringUtil;
import org.apache.log4j.Logger;

public class FindNMers
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(FindNMers.class);
    @Parameter(names={"-i", "--input"}, description="Input file (FASTA)", required=true, validateWith=ReadablePathValidator.class)
    public Path inputFile;
    @Parameter(names={"-n", "--nmer"}, description="NMer to search for", required=true)
    public String nmerStr;
    @Parameter(names={"-m", "--mismatches"}, description="Number of allowed mismatches")
    public int allowedMismatches = 0;
    @Parameter(names={"-r", "--rc"}, description="Search reverse complement as well")
    public boolean rc = false;
    @Parameter(names={"-o", "--output"}, description="Output file (Wiggle)", required=true)
    public Path outputFile;
    private byte[] nmer;
    private byte[] rcNmer;

    @Override
    public void run() throws IOException {
        log.debug((Object)("Searching for NMer " + this.nmerStr));
        this.nmer = StringUtil.stringToBytes((String)this.nmerStr);
        this.rcNmer = Arrays.copyOf(this.nmer, this.nmer.length);
        SequenceUtil.reverseComplement((byte[])this.rcNmer);
        if (this.rc) {
            log.debug((Object)("Searching for reverse complement " + StringUtil.bytesToString((byte[])this.rcNmer)));
        }
        if (!IndexedFastaSequenceFile.canCreateIndexedFastaReader((File)this.inputFile.toFile())) {
            try {
                Samtools.indexFasta(this.inputFile);
            }
            catch (Exception e) {
                log.error((Object)"Error indexing FASTA file with samtools. Is samtools available in the PATH?");
                throw new CommandLineToolException("Error indexing FASTA file with samtools");
            }
        }
        IndexedFastaSequenceFile fasta = new IndexedFastaSequenceFile(this.inputFile.toFile());
        Path indexFile = this.inputFile.resolveSibling(this.inputFile.getFileName() + ".fai");
        FastaSequenceIndex faidx = new FastaSequenceIndex(indexFile.toFile());
        try (BedFileWriter writer = new BedFileWriter(this.outputFile, new OpenOption[0]);){
            for (FastaSequenceIndexEntry contig : faidx) {
                log.debug((Object)("Processing FASTA entry " + contig.getContig() + " (length = " + contig.getSize() + ")"));
                int start = 1;
                while ((long)start <= contig.getSize()) {
                    Interval match;
                    int stop = (int)Math.min((long)(start + 10000000 - 1), contig.getSize());
                    log.debug((Object)("Processing chunk " + contig.getContig() + ":" + start + "-" + stop));
                    ReferenceSequence seq = fasta.getSubsequenceAt(contig.getContig(), (long)start, (long)stop);
                    byte[] bases = seq.getBases();
                    int pos = 0;
                    while ((pos = SequenceUtils.indexOf(bases, this.nmer, this.allowedMismatches, pos)) != -1) {
                        match = new Interval(contig.getContig(), start + pos, start + pos + this.nmer.length);
                        writer.write(match);
                        ++pos;
                    }
                    if (this.rc) {
                        pos = 0;
                        while ((pos = SequenceUtils.indexOf(bases, this.rcNmer, this.allowedMismatches, pos)) != -1) {
                            match = new Interval(contig.getContig(), start + pos + this.rcNmer.length, start + pos);
                            writer.write(match);
                            ++pos;
                        }
                    }
                    start = stop + 1;
                }
            }
        }
    }

    public static void main(String[] args) {
        new FindNMers().instanceMain(args);
    }
}

