/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics;

import com.beust.jcommander.Parameter;
import edu.ucsc.genome.TrackHeader;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.CommandLineToolException;
import edu.unc.genomics.Contig;
import edu.unc.genomics.Interval;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.io.WigFileReader;
import edu.unc.genomics.io.WigFileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class WigMathTool
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(WigMathTool.class);
    @Parameter(names={"-c", "--chunk"}, description="Size to chunk each chromosome into when processing (bp)")
    public int chunkSize = 10000000;
    @Parameter(names={"-f", "--fixedstep"}, description="Force fixedStep output")
    public boolean fixedStep = false;
    @Parameter(names={"-o", "--output"}, description="Output file", required=true)
    public Path outputFile;
    protected List<WigFileReader> inputs = new ArrayList<WigFileReader>();

    protected void addInputFile(WigFileReader wig) {
        this.inputs.add(wig);
    }

    protected abstract void setup();

    protected abstract float[] compute(Interval var1) throws IOException, WigFileException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() throws IOException {
        log.debug((Object)"Executing setup operations");
        this.setup();
        log.debug((Object)"Processing files and writing result to disk");
        try (WigFileWriter writer = new WigFileWriter(this.outputFile, TrackHeader.newWiggle());){
            Set<String> chromosomes = WigMathTool.getCommonChromosomes(this.inputs);
            log.debug((Object)("Found " + chromosomes.size() + " chromosomes in common between all inputs"));
            for (String chr : chromosomes) {
                int start = WigMathTool.getMaxChrStart(this.inputs, chr);
                int stop = WigMathTool.getMinChrStop(this.inputs, chr);
                log.debug((Object)("Queueing chromosome " + chr + " region " + start + "-" + stop));
                int bp = start;
                while (bp < stop) {
                    float[] result;
                    int chunkStart = bp;
                    int chunkStop = Math.min(bp + this.chunkSize - 1, stop);
                    Interval chunk = new Interval(chr, chunkStart, chunkStop);
                    log.debug((Object)("Processing chunk " + chunk));
                    try {
                        result = this.compute(chunk);
                    }
                    catch (WigFileException | IOException e) {
                        throw new CommandLineToolException("Exception while processing chunk " + chunk, e);
                    }
                    if (result.length != chunk.length()) {
                        log.error((Object)("Expected result length=" + chunk.length() + ", got=" + result.length));
                        throw new CommandLineToolException("Result of Wig computation is not the expected length!");
                    }
                    if (this.fixedStep) {
                        writer.writeFixedStepContig(new Contig(chunk, result));
                    } else {
                        writer.write(new Contig(chunk, result));
                    }
                    bp = chunkStop + 1;
                }
            }
        }
        finally {
            this.close();
        }
    }

    private void close() throws IOException {
        for (WigFileReader wig : this.inputs) {
            wig.close();
        }
    }

    public static int getMaxChrStart(List<WigFileReader> wigs, String chr) {
        int max = -1;
        for (WigFileReader wig : wigs) {
            if (wig.getChrStart(chr) <= max) continue;
            max = wig.getChrStart(chr);
        }
        return max;
    }

    public static int getMinChrStop(List<WigFileReader> wigs, String chr) {
        if (wigs.size() == 0) {
            return -1;
        }
        int min = Integer.MAX_VALUE;
        for (WigFileReader wig : wigs) {
            if (wig.getChrStop(chr) >= min) continue;
            min = wig.getChrStop(chr);
        }
        return min;
    }

    public static Set<String> getCommonChromosomes(List<WigFileReader> wigs) {
        if (wigs == null || wigs.size() == 0) {
            return new HashSet<String>();
        }
        Set chromosomes = wigs.get(0).chromosomes();
        Iterator it = chromosomes.iterator();
        block0: while (it.hasNext()) {
            String chr = (String)it.next();
            for (WigFileReader wig : wigs) {
                if (wig.includes(chr)) continue;
                it.remove();
                continue block0;
            }
        }
        return chromosomes;
    }
}

