/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.dst;

import edu.emory.mathcs.jtransforms.dst.DoubleDST_1D;
import edu.emory.mathcs.jtransforms.dst.DoubleDST_2D;
import edu.emory.mathcs.jtransforms.dst.DoubleDST_3D;
import edu.emory.mathcs.utils.IOUtils;

public class AccuracyCheckDoubleDST {
    private static int[] sizes1D = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 32, 64, 100, 120, 128, 256, 310, 512, 1024, 1056, 2048, 8192, 10158, 16384, 32768, 65536, 131072};
    private static int[] sizes2D = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 32, 64, 100, 120, 128, 256, 310, 511, 512, 1024};
    private static int[] sizes3D = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 32, 64, 100, 128};
    private static double eps = Math.pow(2.0, -52.0);

    private AccuracyCheckDoubleDST() {
    }

    public static void checkAccuracyDST_1D() {
        System.out.println("Checking accuracy of 1D DST...");
        for (int i = 0; i < sizes1D.length; ++i) {
            DoubleDST_1D doubleDST_1D = new DoubleDST_1D(sizes1D[i]);
            double d = 0.0;
            double[] dArray = new double[sizes1D[i]];
            IOUtils.fillMatrix_1D(sizes1D[i], dArray);
            double[] dArray2 = new double[sizes1D[i]];
            IOUtils.fillMatrix_1D(sizes1D[i], dArray2);
            doubleDST_1D.forward(dArray, true);
            doubleDST_1D.inverse(dArray, true);
            d = AccuracyCheckDoubleDST.computeRMSE(dArray, dArray2);
            if (d > eps) {
                System.err.println("\tsize = " + sizes1D[i] + ";\terror = " + d);
            } else {
                System.out.println("\tsize = " + sizes1D[i] + ";\terror = " + d);
            }
            dArray = null;
            dArray2 = null;
            doubleDST_1D = null;
            System.gc();
        }
    }

    public static void checkAccuracyDST_2D() {
        Object object;
        Object object2;
        double d;
        DoubleDST_2D doubleDST_2D;
        int n;
        System.out.println("Checking accuracy of 2D DST (double[] input)...");
        for (n = 0; n < sizes2D.length; ++n) {
            doubleDST_2D = new DoubleDST_2D(sizes2D[n], sizes2D[n]);
            d = 0.0;
            object2 = new double[sizes2D[n] * sizes2D[n]];
            IOUtils.fillMatrix_2D(sizes2D[n], sizes2D[n], object2);
            object = new double[sizes2D[n] * sizes2D[n]];
            IOUtils.fillMatrix_2D(sizes2D[n], sizes2D[n], object);
            doubleDST_2D.forward((double[])object2, true);
            doubleDST_2D.inverse((double[])object2, true);
            d = AccuracyCheckDoubleDST.computeRMSE(object2, object);
            if (d > eps) {
                System.err.println("\tsize = " + sizes2D[n] + " x " + sizes2D[n] + ";\terror = " + d);
            } else {
                System.out.println("\tsize = " + sizes2D[n] + " x " + sizes2D[n] + ";\terror = " + d);
            }
            object2 = null;
            object = null;
            doubleDST_2D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 2D DST (double[][] input)...");
        for (n = 0; n < sizes2D.length; ++n) {
            doubleDST_2D = new DoubleDST_2D(sizes2D[n], sizes2D[n]);
            d = 0.0;
            object2 = new double[sizes2D[n]][sizes2D[n]];
            IOUtils.fillMatrix_2D(sizes2D[n], sizes2D[n], (double[][])object2);
            object = new double[sizes2D[n]][sizes2D[n]];
            IOUtils.fillMatrix_2D(sizes2D[n], sizes2D[n], (double[][])object);
            doubleDST_2D.forward((double[][])object2, true);
            doubleDST_2D.inverse((double[][])object2, true);
            d = AccuracyCheckDoubleDST.computeRMSE((double[][])object2, (double[][])object);
            if (d > eps) {
                System.err.println("\tsize = " + sizes2D[n] + " x " + sizes2D[n] + ";\terror = " + d);
            } else {
                System.out.println("\tsize = " + sizes2D[n] + " x " + sizes2D[n] + ";\terror = " + d);
            }
            object2 = null;
            object = null;
            doubleDST_2D = null;
            System.gc();
        }
    }

    public static void checkAccuracyDST_3D() {
        Object object;
        Object object2;
        double d;
        DoubleDST_3D doubleDST_3D;
        int n;
        System.out.println("Checking accuracy of 3D DST (double[] input)...");
        for (n = 0; n < sizes3D.length; ++n) {
            doubleDST_3D = new DoubleDST_3D(sizes3D[n], sizes3D[n], sizes3D[n]);
            d = 0.0;
            object2 = new double[sizes3D[n] * sizes3D[n] * sizes3D[n]];
            IOUtils.fillMatrix_3D(sizes3D[n], sizes3D[n], sizes3D[n], object2);
            object = new double[sizes3D[n] * sizes3D[n] * sizes3D[n]];
            IOUtils.fillMatrix_3D(sizes3D[n], sizes3D[n], sizes3D[n], object);
            doubleDST_3D.forward((double[])object2, true);
            doubleDST_3D.inverse((double[])object2, true);
            d = AccuracyCheckDoubleDST.computeRMSE(object2, object);
            if (d > eps) {
                System.err.println("\tsize = " + sizes3D[n] + " x " + sizes3D[n] + " x " + sizes3D[n] + ";\t\terror = " + d);
            } else {
                System.out.println("\tsize = " + sizes3D[n] + " x " + sizes3D[n] + " x " + sizes3D[n] + ";\t\terror = " + d);
            }
            object2 = null;
            object = null;
            doubleDST_3D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 3D DST (double[][][] input)...");
        for (n = 0; n < sizes3D.length; ++n) {
            doubleDST_3D = new DoubleDST_3D(sizes3D[n], sizes3D[n], sizes3D[n]);
            d = 0.0;
            object2 = new double[sizes3D[n]][sizes3D[n]][sizes3D[n]];
            IOUtils.fillMatrix_3D(sizes3D[n], sizes3D[n], sizes3D[n], (double[][][])object2);
            object = new double[sizes3D[n]][sizes3D[n]][sizes3D[n]];
            IOUtils.fillMatrix_3D(sizes3D[n], sizes3D[n], sizes3D[n], (double[][][])object);
            doubleDST_3D.forward((double[][][])object2, true);
            doubleDST_3D.inverse((double[][][])object2, true);
            d = AccuracyCheckDoubleDST.computeRMSE((double[][][])object2, (double[][][])object);
            if (d > eps) {
                System.err.println("\tsize = " + sizes3D[n] + " x " + sizes3D[n] + " x " + sizes3D[n] + ";\t\terror = " + d);
            } else {
                System.out.println("\tsize = " + sizes3D[n] + " x " + sizes3D[n] + " x " + sizes3D[n] + ";\t\terror = " + d);
            }
            object2 = null;
            object = null;
            doubleDST_3D = null;
            System.gc();
        }
    }

    private static double computeRMSE(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Arrays are not the same size.");
        }
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            double d2 = dArray[i] - dArray2[i];
            d += d2 * d2;
        }
        return Math.sqrt(d / (double)dArray.length);
    }

    private static double computeRMSE(double[][] dArray, double[][] dArray2) {
        if (dArray.length != dArray2.length || dArray[0].length != dArray2[0].length) {
            throw new IllegalArgumentException("Arrays are not the same size.");
        }
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[0].length; ++j) {
                double d2 = dArray[i][j] - dArray2[i][j];
                d += d2 * d2;
            }
        }
        return Math.sqrt(d / (double)(dArray.length * dArray[0].length));
    }

    private static double computeRMSE(double[][][] dArray, double[][][] dArray2) {
        if (dArray.length != dArray2.length || dArray[0].length != dArray2[0].length || dArray[0][0].length != dArray2[0][0].length) {
            throw new IllegalArgumentException("Arrays are not the same size.");
        }
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[0].length; ++j) {
                for (int k = 0; k < dArray[0][0].length; ++k) {
                    double d2 = dArray[i][j][k] - dArray2[i][j][k];
                    d += d2 * d2;
                }
            }
        }
        return Math.sqrt(d / (double)(dArray.length * dArray[0].length * dArray[0][0].length));
    }

    public static void main(String[] stringArray) {
        AccuracyCheckDoubleDST.checkAccuracyDST_1D();
        AccuracyCheckDoubleDST.checkAccuracyDST_2D();
        AccuracyCheckDoubleDST.checkAccuracyDST_3D();
        System.exit(0);
    }
}

