/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.ngs;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.Interval;
import edu.unc.genomics.ReadablePathValidator;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.io.WigFileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.log4j.Logger;

public class FindOutlierRegions
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(FindOutlierRegions.class);
    @Parameter(names={"-i", "--input"}, description="Input file", required=true, validateWith=ReadablePathValidator.class)
    public Path inputFile;
    @Parameter(names={"-w", "--window"}, description="Window size", required=true)
    public int windowSize;
    @Parameter(names={"-t", "--threshold"}, description="Threshold (fold x mean)")
    public float fold = 3.0f;
    @Parameter(names={"-b", "--below"}, description="Search for outliers below the threshold")
    public boolean below = false;
    @Parameter(names={"-o", "--output"}, description="Output file (bed)", required=true)
    public Path outputFile;
    int flip = 1;
    double threshold;
    DescriptiveStatistics stats = new DescriptiveStatistics();

    @Override
    public void run() throws IOException {
        this.stats.setWindowSize(this.windowSize);
        if (this.below) {
            this.flip = -1;
        }
        try (WigFileReader reader = WigFileReader.autodetect((Path)this.inputFile);
             PrintWriter writer = new PrintWriter(Files.newBufferedWriter(this.outputFile, Charset.defaultCharset(), new OpenOption[0]));){
            this.threshold = (double)this.fold * reader.mean();
            for (String chr : reader.chromosomes()) {
                int start = reader.getChrStart(chr);
                int stop = reader.getChrStop(chr);
                log.debug((Object)("Processing chromosome " + chr + " region " + start + "-" + stop));
                int bp = start;
                Integer outlierStart = null;
                this.stats.clear();
                while (bp < stop) {
                    int chunkStart = bp;
                    int chunkStop = Math.min(bp + 10000000 - 1, stop);
                    Interval chunk = new Interval(chr, chunkStart, chunkStop);
                    log.debug((Object)("Processing chunk " + chunk));
                    try {
                        float[] data = reader.query(chunk).getValues();
                        for (int i = 0; i < data.length; ++i) {
                            this.stats.addValue((double)data[i]);
                            if (outlierStart == null) {
                                if (!((double)this.flip * this.stats.getMean() > (double)this.flip * this.threshold)) continue;
                                outlierStart = bp + i - this.windowSize;
                                continue;
                            }
                            if (!((double)this.flip * this.stats.getMean() < (double)this.flip * this.threshold)) continue;
                            int outlierStop = bp + i;
                            writer.println(chr + "\t" + outlierStart + "\t" + outlierStop);
                            outlierStart = null;
                        }
                    }
                    catch (WigFileException e) {
                        log.fatal((Object)("Wig file error while processing chunk " + chr + ":" + start + "-" + stop));
                        e.printStackTrace();
                        throw new RuntimeException("Wig file error while processing chunk " + chr + ":" + start + "-" + stop);
                    }
                    bp = chunkStop + 1;
                }
            }
        }
    }

    public static void main(String[] args) throws IOException, WigFileException {
        new FindOutlierRegions().instanceMain(args);
    }
}

