/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.genomics.nucleosomes;

import com.beust.jcommander.Parameter;
import edu.unc.genomics.CommandLineTool;
import edu.unc.genomics.CommandLineToolException;
import edu.unc.genomics.Interval;
import edu.unc.genomics.NucleosomeCall;
import edu.unc.genomics.ReadablePathValidator;
import edu.unc.genomics.io.IntervalFileWriter;
import edu.unc.genomics.io.WigFileException;
import edu.unc.genomics.io.WigFileReader;
import edu.unc.utils.SortUtils;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.log4j.Logger;

public class GreedyCaller
extends CommandLineTool {
    private static final Logger log = Logger.getLogger(GreedyCaller.class);
    @Parameter(names={"-d", "--dyads"}, description="Dyad counts file", required=true, validateWith=ReadablePathValidator.class)
    public Path dyadsFile;
    @Parameter(names={"-s", "--smoothed"}, description="Smoothed dyad counts file", required=true, validateWith=ReadablePathValidator.class)
    public Path smoothedDyadsFile;
    @Parameter(names={"-n", "--size"}, description="Nucleosome size (bp)")
    public int nucleosomeSize = 147;
    @Parameter(names={"-o", "--output"}, description="Output file", required=true)
    public Path outputFile;

    @Override
    public void run() throws IOException {
        int halfNuc = this.nucleosomeSize / 2;
        int count = 0;
        try (WigFileReader dyadsReader = WigFileReader.autodetect((Path)this.dyadsFile);
             WigFileReader smoothedDyadsReader = WigFileReader.autodetect((Path)this.smoothedDyadsFile);
             IntervalFileWriter writer = new IntervalFileWriter(this.outputFile, new OpenOption[0]);){
            writer.writeComment("#chr\tstart\tstop\tlength\tlengthStdev\tdyad\tdyadStdev\tconditionalPosition\tdyadMean\toccupancy");
            for (String chr : smoothedDyadsReader.chromosomes()) {
                log.debug((Object)("Processing chromosome " + chr));
                int chunkStart = smoothedDyadsReader.getChrStart(chr);
                int chrStop = smoothedDyadsReader.getChrStop(chr);
                while (chunkStart < chrStop) {
                    float[] smoothed;
                    float[] dyads;
                    int chunkStop = chunkStart + 10000000 - 1;
                    int paddedStart = Math.max(chunkStart - this.nucleosomeSize, smoothedDyadsReader.getChrStart(chr));
                    int paddedStop = Math.min(chunkStop + this.nucleosomeSize, smoothedDyadsReader.getChrStop(chr));
                    log.debug((Object)("Processing chunk " + chunkStart + "-" + chunkStop));
                    try {
                        dyads = dyadsReader.query(chr, paddedStart, paddedStop).getValues();
                        smoothed = smoothedDyadsReader.query(chr, paddedStart, paddedStop).getValues();
                    }
                    catch (WigFileException | IOException e) {
                        throw new CommandLineToolException(e);
                    }
                    int[] sortedIndices = SortUtils.sortIndices(smoothed);
                    for (int j = sortedIndices.length - 1; j >= 0; --j) {
                        int i = sortedIndices[j];
                        int dyad = paddedStart + i;
                        if (!(smoothed[i] > 0.0f)) continue;
                        int nucStart = Math.max(paddedStart, dyad - halfNuc);
                        int nucStop = Math.min(dyad + halfNuc, paddedStop);
                        NucleosomeCall call = new NucleosomeCall(chr, nucStart, nucStop);
                        call.setDyad(dyad);
                        double occupancy = 0.0;
                        double weightedSum = 0.0;
                        double smoothedSum = 0.0;
                        for (int bp = nucStart; bp <= nucStop; ++bp) {
                            occupancy += (double)dyads[bp - paddedStart];
                            weightedSum += (double)(dyads[bp - paddedStart] * (float)bp);
                            smoothedSum += (double)smoothed[bp - paddedStart];
                        }
                        call.setOccupancy(occupancy);
                        double dyadMean = weightedSum / occupancy;
                        if (!(occupancy > 0.0)) continue;
                        call.setDyadMean((int)Math.round(dyadMean));
                        call.setConditionalPosition((double)smoothed[i] / smoothedSum);
                        double sumOfSquares = 0.0;
                        for (int bp = nucStart; bp <= nucStop; ++bp) {
                            sumOfSquares += (double)dyads[bp - paddedStart] * Math.pow((double)bp - dyadMean, 2.0);
                        }
                        double variance = sumOfSquares / occupancy;
                        call.setDyadStdev(Math.sqrt(variance));
                        if (chunkStart <= dyad && dyad <= chunkStop) {
                            writer.write((Interval)call);
                            ++count;
                        }
                        int low = Math.max(i - this.nucleosomeSize, 0);
                        int high = Math.min(i + this.nucleosomeSize, smoothed.length - 1);
                        for (int k = low; k <= high; ++k) {
                            smoothed[k] = 0.0f;
                        }
                    }
                    chunkStart = chunkStop + 1;
                }
            }
        }
        log.info((Object)("Called " + count + " nucleosomes"));
    }

    public static void main(String[] args) {
        new GreedyCaller().instanceMain(args);
    }
}

